/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import appeng.api.util.AEColor;
import appeng.blockentity.networking.CableBusBlockEntity;
import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IDurabilityBar;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.utils.GradientUtil;
import com.lowdragmc.lowdraglib.Platform;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2504;
import net.minecraft.class_2506;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ColorSprayBehaviour
implements IDurabilityBar,
IInteractionItem,
IAddInformation {
    private static final ImmutableMap<class_1767, class_2248> GLASS_MAP;
    private static final ImmutableMap<class_1767, class_2248> GLASS_PANE_MAP;
    private static final ImmutableMap<class_1767, class_2248> TERRACOTTA_MAP;
    private static final ImmutableMap<class_1767, class_2248> WOOL_MAP;
    private static final ImmutableMap<class_1767, class_2248> CARPET_MAP;
    private static final ImmutableMap<class_1767, class_2248> CONCRETE_MAP;
    private static final ImmutableMap<class_1767, class_2248> CONCRETE_POWDER_MAP;
    private static final ImmutableMap<class_1767, class_2248> SHULKER_BOX_MAP;
    private static final ImmutableMap<class_1767, class_2248> CANDLE_MAP;
    private static final ImmutableMap<class_1767, class_2248> SEAT_MAP;
    private final Supplier<class_1799> empty;
    private final class_1767 color;
    public final int totalUses;
    private final class_3545<float[], float[]> durabilityBarColors;

    private static class_2960 getId(String modid, class_1767 color, String postfix) {
        return new class_2960(modid, "%s_%s".formatted(color.method_15434(), postfix));
    }

    public ColorSprayBehaviour(Supplier<class_1799> empty, int totalUses, int color) {
        this.empty = empty;
        class_1767[] colors = class_1767.values();
        this.color = color >= colors.length || color < 0 ? null : colors[color];
        int colorValue = this.color == null ? 0x969696 : this.color.method_16357();
        this.totalUses = totalUses;
        this.durabilityBarColors = GradientUtil.getGradient(colorValue, 10);
    }

    @Override
    public float getDurabilityForDisplay(class_1799 stack) {
        return (float)this.getUsesLeft(stack) / (float)this.totalUses;
    }

    @Override
    public int getBarColor(class_1799 stack) {
        float f = Math.max(0.0f, this.getDurabilityForDisplay(stack));
        return ColorSprayBehaviour.mixColors(f, (float[])this.durabilityBarColors.method_15442(), (float[])this.durabilityBarColors.method_15441());
    }

    private static int mixColors(float ratio, float[] ... colors) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        ratio *= 1.0f / (float)colors.length;
        for (float[] color : colors) {
            r += color[0] * ratio;
            g += color[1] * ratio;
            b += color[2] * ratio;
        }
        return ((int)(r * 255.0f) & 0xFF) << 16 | ((int)(g * 255.0f) & 0xFF) << 8 | ((int)(b * 255.0f) & 0xFF) << 0;
    }

    @Override
    public void appendHoverText(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        int remainingUses = this.getUsesLeft(stack);
        if (this.color != null) {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)("behaviour.paintspray." + this.color.method_15434() + ".tooltip")));
        } else {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"behaviour.paintspray.solvent.tooltip"));
        }
        tooltipComponents.add((class_2561)class_2561.method_43469((String)"behaviour.paintspray.uses", (Object[])new Object[]{remainingUses}));
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_1937 level = context.method_8045();
        class_2350 facing = context.method_8038();
        class_2338 pos = context.method_8037();
        class_1799 stack = context.method_8041();
        if (player != null) {
            if (!this.tryPaintBlock(player, level, pos, facing)) {
                return class_1269.field_5811;
            }
            this.useItemDurability(player, context.method_20287(), stack, this.empty.get());
            GTSoundEntries.SPRAY_CAN_TOOL.play(level, null, player.method_19538(), 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private boolean tryPaintBlock(class_1657 player, class_1937 world, class_2338 pos, class_2350 side) {
        class_2680 blockState = world.method_8320(pos);
        class_2248 block = blockState.method_26204();
        if (this.color == null) {
            return ColorSprayBehaviour.tryStripBlockColor(player, world, pos, block, side);
        }
        return ColorSprayBehaviour.recolorBlockState(world, pos, side, this.color) || this.tryPaintSpecialBlock(player, world, pos, block);
    }

    private static boolean recolorBlockState(class_1937 level, class_2338 pos, class_2350 side, class_1767 color) {
        class_2680 state = level.method_8320(pos);
        for (class_2769 property : state.method_28501()) {
            if (property.method_11902() != class_1767.class) continue;
            state.method_11657(property, (Comparable)color);
            return true;
        }
        return false;
    }

    private boolean tryPaintSpecialBlock(class_1657 player, class_1937 world, class_2338 pos, class_2248 block) {
        CableBusBlockEntity cable;
        IMachineBlockEntity machineBe;
        MetaMachine mte;
        if (block.method_9564().method_26164(CustomTags.GLASS_BLOCKS_BLOCK) && ColorSprayBehaviour.recolorBlockNoState(GLASS_MAP, this.color, world, pos, class_2246.field_10033)) {
            return true;
        }
        if (block.method_9564().method_26164(CustomTags.GLASS_PANES_BLOCK) && ColorSprayBehaviour.recolorBlockNoState(GLASS_PANE_MAP, this.color, world, pos, class_2246.field_10285)) {
            return true;
        }
        if (block.method_9564().method_26164(class_3481.field_36265) && ColorSprayBehaviour.recolorBlockNoState(TERRACOTTA_MAP, this.color, world, pos, class_2246.field_10415)) {
            return true;
        }
        if (block.method_9564().method_26164(class_3481.field_15481) && ColorSprayBehaviour.recolorBlockNoState(WOOL_MAP, this.color, world, pos)) {
            return true;
        }
        if (block.method_9564().method_26164(class_3481.field_15479) && ColorSprayBehaviour.recolorBlockNoState(CARPET_MAP, this.color, world, pos)) {
            return true;
        }
        if (block.method_9564().method_26164(CustomTags.CONCRETE) && ColorSprayBehaviour.recolorBlockNoState(CONCRETE_MAP, this.color, world, pos)) {
            return true;
        }
        if (block.method_9564().method_26164(CustomTags.CONCRETE_POWDER) && ColorSprayBehaviour.recolorBlockNoState(CONCRETE_POWDER_MAP, this.color, world, pos)) {
            return true;
        }
        if (block.method_9564().method_26164(class_3481.field_21490) && ColorSprayBehaviour.recolorBlockNoState(SHULKER_BOX_MAP, this.color, world, pos, class_2246.field_10603)) {
            return true;
        }
        if (block.method_9564().method_26164(class_3481.field_26983) && ColorSprayBehaviour.recolorBlockNoState(CANDLE_MAP, this.color, world, pos)) {
            return true;
        }
        class_2586 be = world.method_8321(pos);
        if (be instanceof IMachineBlockEntity && (mte = (machineBe = (IMachineBlockEntity)be).getMetaMachine()) != null) {
            if (mte.getPaintingColor() != this.color.method_16357()) {
                mte.setPaintingColor(this.color.method_16357());
                return true;
            }
            return false;
        }
        if (be instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)be;
            if (pipe.getPaintingColor() != this.color.method_16357()) {
                pipe.setPaintingColor(this.color.method_16357());
                return true;
            }
            return false;
        }
        if (GTCEu.isAE2Loaded() && be instanceof CableBusBlockEntity && (cable = (CableBusBlockEntity)be).getColor().ordinal() != this.color.ordinal()) {
            cable.recolourBlock(null, AEColor.values()[this.color.ordinal()], player);
            return true;
        }
        return false;
    }

    private static boolean recolorBlockNoState(Map<class_1767, class_2248> map, class_1767 color, class_1937 world, class_2338 pos) {
        return ColorSprayBehaviour.recolorBlockNoState(map, color, world, pos, null);
    }

    private static boolean recolorBlockNoState(Map<class_1767, class_2248> map, class_1767 color, class_1937 world, class_2338 pos, class_2248 _default) {
        class_2248 newBlock = map.getOrDefault(color, _default);
        class_2680 old = world.method_8320(pos);
        if (newBlock == class_2246.field_10124) {
            newBlock = _default;
        }
        if (newBlock != null && newBlock != old.method_26204()) {
            class_2680 state = newBlock.method_9564();
            for (class_2769 property : old.method_28501()) {
                state.method_11657(property, old.method_11654(property));
            }
            world.method_8652(pos, state, 3);
            return true;
        }
        return false;
    }

    private static boolean tryStripBlockColor(class_1657 player, class_1937 world, class_2338 pos, class_2248 block, class_2350 side) {
        IMachineBlockEntity machineBe;
        MetaMachine mte;
        if (block instanceof class_2506) {
            world.method_8652(pos, class_2246.field_10033.method_9564(), 3);
            return true;
        }
        if (block instanceof class_2504) {
            world.method_8652(pos, class_2246.field_10285.method_9564(), 3);
            return true;
        }
        if (block.method_9564().method_26164(class_3481.field_36265) && block != class_2246.field_10415) {
            world.method_8652(pos, class_2246.field_10415.method_9564(), 3);
            return true;
        }
        if (block.method_9564().method_26164(class_3481.field_15481) && block != class_2246.field_10446) {
            world.method_8652(pos, class_2246.field_10446.method_9564(), 3);
            return true;
        }
        if (block.method_9564().method_26164(class_3481.field_15479) && block != class_2246.field_10466) {
            world.method_8652(pos, class_2246.field_10466.method_9564(), 3);
            return true;
        }
        if (block.method_9564().method_26164(CustomTags.CONCRETE) && block != class_2246.field_10107) {
            world.method_8652(pos, class_2246.field_10107.method_9564(), 3);
            return true;
        }
        if (block.method_9564().method_26164(CustomTags.CONCRETE_POWDER) && block != class_2246.field_10197) {
            world.method_8652(pos, class_2246.field_10197.method_9564(), 3);
            return true;
        }
        if (block.method_9564().method_26164(class_3481.field_21490) && block != class_2246.field_10603) {
            ColorSprayBehaviour.recolorBlockNoState(SHULKER_BOX_MAP, null, world, pos, class_2246.field_10603);
            return true;
        }
        if (block.method_9564().method_26164(class_3481.field_26983) && block != class_2246.field_27100) {
            ColorSprayBehaviour.recolorBlockNoState(CANDLE_MAP, class_1767.field_7952, world, pos);
            return true;
        }
        class_2586 be = world.method_8321(pos);
        if (be instanceof IMachineBlockEntity && (mte = (machineBe = (IMachineBlockEntity)be).getMetaMachine()) != null) {
            if (mte.isPainted()) {
                mte.setPaintingColor(mte.getDefaultPaintingColor());
                return true;
            }
            return false;
        }
        if (be instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)be;
            if (pipe.isPainted()) {
                pipe.setPaintingColor(pipe.getDefaultPaintingColor());
                return true;
            }
            return false;
        }
        if (GTCEu.isAE2Loaded() && be instanceof CableBusBlockEntity) {
            CableBusBlockEntity cable = (CableBusBlockEntity)be;
            if (cable.getColor() != AEColor.TRANSPARENT) {
                cable.recolourBlock(null, AEColor.TRANSPARENT, player);
                return true;
            }
            return false;
        }
        class_2680 state = world.method_8320(pos);
        for (class_2769 prop : state.method_28501()) {
            if (prop.method_11902() != class_1767.class) continue;
            class_2680 defaultState = block.method_9564();
            class_1767 defaultColor = class_1767.field_7952;
            try {
                defaultColor = (class_1767)defaultState.method_11654(prop);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ColorSprayBehaviour.recolorBlockState(world, pos, side, defaultColor);
            return true;
        }
        return false;
    }

    public boolean useItemDurability(class_1657 player, class_1268 hand, class_1799 stack, class_1799 replacementStack) {
        int usesLeft = this.getUsesLeft(stack);
        if (!player.method_7337()) {
            if (--usesLeft <= 0) {
                if (replacementStack.method_7960()) {
                    stack.method_7934(1);
                } else {
                    player.method_6122(hand, replacementStack);
                }
                return true;
            }
            ColorSprayBehaviour.setUsesLeft(stack, usesLeft);
        }
        return true;
    }

    public final int getUsesLeft(class_1799 stack) {
        class_2487 tagCompound = stack.method_7969();
        if (tagCompound == null || !tagCompound.method_10573("UsesLeft", 3)) {
            return this.totalUses;
        }
        return tagCompound.method_10550("UsesLeft");
    }

    public static void setUsesLeft(class_1799 itemStack, int usesLeft) {
        class_2487 tagCompound = itemStack.method_7948();
        tagCompound.method_10569("UsesLeft", usesLeft);
    }

    static {
        ImmutableMap.Builder glassBuilder = ImmutableMap.builder();
        ImmutableMap.Builder glassPaneBuilder = ImmutableMap.builder();
        ImmutableMap.Builder terracottaBuilder = ImmutableMap.builder();
        ImmutableMap.Builder woolBuilder = ImmutableMap.builder();
        ImmutableMap.Builder carpetBuilder = ImmutableMap.builder();
        ImmutableMap.Builder concreteBuilder = ImmutableMap.builder();
        ImmutableMap.Builder concretePowderBuilder = ImmutableMap.builder();
        ImmutableMap.Builder shulkerBoxBuilder = ImmutableMap.builder();
        ImmutableMap.Builder candleBuilder = ImmutableMap.builder();
        ImmutableMap.Builder seatBuilder = ImmutableMap.builder();
        for (class_1767 color : class_1767.values()) {
            if (color.ordinal() > 15 && Platform.isModLoaded((String)"tinted")) {
                glassBuilder.put((Object)color, (Object)((class_2248)class_7923.field_41175.method_10223(ColorSprayBehaviour.getId("tinted", color, "stained_glass"))));
                glassPaneBuilder.put((Object)color, (Object)((class_2248)class_7923.field_41175.method_10223(ColorSprayBehaviour.getId("tinted", color, "stained_glass_pane"))));
                terracottaBuilder.put((Object)color, (Object)((class_2248)class_7923.field_41175.method_10223(ColorSprayBehaviour.getId("tinted", color, "terracotta"))));
                woolBuilder.put((Object)color, (Object)((class_2248)class_7923.field_41175.method_10223(ColorSprayBehaviour.getId("tinted", color, "wool"))));
                carpetBuilder.put((Object)color, (Object)((class_2248)class_7923.field_41175.method_10223(ColorSprayBehaviour.getId("tinted", color, "carpet"))));
                concreteBuilder.put((Object)color, (Object)((class_2248)class_7923.field_41175.method_10223(ColorSprayBehaviour.getId("tinted", color, "concrete"))));
                concretePowderBuilder.put((Object)color, (Object)((class_2248)class_7923.field_41175.method_10223(ColorSprayBehaviour.getId("tinted", color, "concrete_powder"))));
                shulkerBoxBuilder.put((Object)color, (Object)((class_2248)class_7923.field_41175.method_10223(ColorSprayBehaviour.getId("tinted", color, "shulker_box"))));
                candleBuilder.put((Object)color, (Object)((class_2248)class_7923.field_41175.method_10223(ColorSprayBehaviour.getId("tinted", color, "candle"))));
                continue;
            }
            glassBuilder.put((Object)color, (Object)((class_2248)class_7923.field_41175.method_10223(ColorSprayBehaviour.getId("minecraft", color, "stained_glass"))));
            glassPaneBuilder.put((Object)color, (Object)((class_2248)class_7923.field_41175.method_10223(ColorSprayBehaviour.getId("minecraft", color, "stained_glass_pane"))));
            terracottaBuilder.put((Object)color, (Object)((class_2248)class_7923.field_41175.method_10223(ColorSprayBehaviour.getId("minecraft", color, "terracotta"))));
            woolBuilder.put((Object)color, (Object)((class_2248)class_7923.field_41175.method_10223(ColorSprayBehaviour.getId("minecraft", color, "wool"))));
            carpetBuilder.put((Object)color, (Object)((class_2248)class_7923.field_41175.method_10223(ColorSprayBehaviour.getId("minecraft", color, "carpet"))));
            concreteBuilder.put((Object)color, (Object)((class_2248)class_7923.field_41175.method_10223(ColorSprayBehaviour.getId("minecraft", color, "concrete"))));
            concretePowderBuilder.put((Object)color, (Object)((class_2248)class_7923.field_41175.method_10223(ColorSprayBehaviour.getId("minecraft", color, "concrete_powder"))));
            shulkerBoxBuilder.put((Object)color, (Object)((class_2248)class_7923.field_41175.method_10223(ColorSprayBehaviour.getId("minecraft", color, "shulker_box"))));
            candleBuilder.put((Object)color, (Object)((class_2248)class_7923.field_41175.method_10223(ColorSprayBehaviour.getId("minecraft", color, "candle"))));
        }
        GLASS_MAP = glassBuilder.build();
        GLASS_PANE_MAP = glassPaneBuilder.build();
        TERRACOTTA_MAP = terracottaBuilder.build();
        WOOL_MAP = woolBuilder.build();
        CARPET_MAP = carpetBuilder.build();
        CONCRETE_MAP = concreteBuilder.build();
        CONCRETE_POWDER_MAP = concretePowderBuilder.build();
        SHULKER_BOX_MAP = shulkerBoxBuilder.build();
        CANDLE_MAP = candleBuilder.build();
        SEAT_MAP = seatBuilder.build();
    }
}

