/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.ICoilType;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.recipe.FacadeCoverRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeSerializer;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.recipe.ShapedEnergyTransferRecipe;
import com.gregtechceu.gtceu.api.recipe.StrictShapedRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.sound.ExistingSoundEntry;
import com.gregtechceu.gtceu.common.data.GCyMRecipeTypes;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gregtechceu.gtceu.common.recipe.RPMCondition;
import com.gregtechceu.gtceu.common.recipe.RockBreakerCondition;
import com.gregtechceu.gtceu.data.recipe.RecipeHelper;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.integration.kjs.GTRegistryObjectBuilderTypes;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.utils.CycleItemStackHandler;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.simibubi.create.AllBlocks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class GTRecipeTypes {
    public static final String STEAM = "steam";
    public static final String ELECTRIC = "electric";
    public static final String GENERATOR = "generator";
    public static final String MULTIBLOCK = "multiblock";
    public static final String DUMMY = "dummy";
    public static final String KINETIC = "kinetic";
    public static final GTRecipeType STEAM_BOILER_RECIPES = GTRecipeTypes.register("steam_boiler", "steam", new class_3956[0]).setMaxIOSize(1, 0, 1, 1).setProgressBar(GuiTextures.PROGRESS_BAR_BOILER_FUEL.get(true), ProgressTexture.FillDirection.DOWN_TO_UP).onRecipeBuild((builder, provider) -> {
        int duration = builder.duration / 12 / 80;
        if (duration > 0) {
            LARGE_BOILER_RECIPES.copyFrom((GTRecipeBuilder)builder).duration(duration).save((Consumer<class_2444>)provider);
        }
    }).setMaxTooltips(1).setSound(GTSoundEntries.FURNACE);
    public static final GTRecipeType FURNACE_RECIPES = GTRecipeTypes.register("electric_furnace", "electric", class_3956.field_17546).setMaxIOSize(1, 1, 0, 0).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.EUt(4L)).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.FURNACE_OVERLAY_1).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSteamProgressBar(GuiTextures.PROGRESS_BAR_ARROW_STEAM, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.FURNACE);
    public static final GTRecipeType ALLOY_SMELTER_RECIPES = GTRecipeTypes.register("alloy_smelter", "electric", new class_3956[0]).setMaxIOSize(2, 1, 0, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.FURNACE_OVERLAY_1).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSteamProgressBar(GuiTextures.PROGRESS_BAR_ARROW_STEAM, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.FURNACE);
    public static final GTRecipeType ARC_FURNACE_RECIPES = GTRecipeTypes.register("arc_furnace", "electric", new class_3956[0]).setMaxIOSize(1, 4, 1, 1).setEUIO(IO.IN).setProgressBar(GuiTextures.PROGRESS_BAR_ARC_FURNACE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.ARC).onRecipeBuild((recipeBuilder, provider) -> {
        if (recipeBuilder.input.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList()).isEmpty() && recipeBuilder.tickInput.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList()).isEmpty()) {
            recipeBuilder.inputFluids(GTMaterials.Oxygen.getFluid(recipeBuilder.duration));
        }
    });
    public static final GTRecipeType ASSEMBLER_RECIPES = GTRecipeTypes.register("assembler", "electric", new class_3956[0]).setMaxIOSize(9, 1, 1, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.CIRCUIT_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_CIRCUIT, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.ASSEMBLER);
    public static final GTRecipeType AUTOCLAVE_RECIPES = GTRecipeTypes.register("autoclave", "electric", new class_3956[0]).setMaxIOSize(2, 2, 1, 1).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.CRYSTAL_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_CRYSTALLIZATION, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.FURNACE);
    public static final GTRecipeType BENDER_RECIPES = GTRecipeTypes.register("bender", "electric", new class_3956[0]).setMaxIOSize(2, 1, 0, 0).setEUIO(IO.IN).setSlotOverlay(false, false, false, (IGuiTexture)GuiTextures.BENDER_OVERLAY).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.INT_CIRCUIT_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_BENDING, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.MOTOR);
    public static final GTRecipeType BREWING_RECIPES = GTRecipeTypes.register("brewery", "electric", new class_3956[0]).setMaxIOSize(1, 0, 1, 1).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.duration(128).EUt(4L)).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.BREWER_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.CHEMICAL);
    public static final GTRecipeType MACERATOR_RECIPES = GTRecipeTypes.register("macerator", "electric", new class_3956[0]).setMaxIOSize(1, 4, 0, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.CRUSHED_ORE_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_MACERATE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSteamProgressBar(GuiTextures.PROGRESS_BAR_MACERATE_STEAM, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.MACERATOR);
    public static final GTRecipeType CANNER_RECIPES = GTRecipeTypes.register("canner", "electric", new class_3956[0]).setMaxIOSize(2, 2, 1, 1).setEUIO(IO.IN).setSlotOverlay(false, false, false, (IGuiTexture)GuiTextures.CANNER_OVERLAY).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.CANISTER_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.CANISTER_OVERLAY).setSlotOverlay(false, true, (IGuiTexture)GuiTextures.DARK_CANISTER_OVERLAY).setSlotOverlay(true, true, (IGuiTexture)GuiTextures.DARK_CANISTER_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_CANNER, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.BATH);
    public static final GTRecipeType CENTRIFUGE_RECIPES = GTRecipeTypes.register("centrifuge", "electric", new class_3956[0]).setMaxIOSize(2, 6, 1, 6).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.EUt(5L)).setSlotOverlay(false, false, false, (IGuiTexture)GuiTextures.EXTRACTOR_OVERLAY).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.CANISTER_OVERLAY).setSlotOverlay(false, true, true, (IGuiTexture)GuiTextures.CENTRIFUGE_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_EXTRACT, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.CENTRIFUGE);
    public static final GTRecipeType CHEMICAL_BATH_RECIPES = GTRecipeTypes.register("chemical_bath", "electric", new class_3956[0]).setMaxIOSize(1, 6, 1, 1).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.EUt(GTValues.VA[1])).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.BREWER_OVERLAY).setSlotOverlay(true, false, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setSlotOverlay(true, false, true, (IGuiTexture)GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_MIXER, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.BATH);
    public static final GTRecipeType CHEMICAL_RECIPES = GTRecipeTypes.register("chemical_reactor", "electric", new class_3956[0]).setMaxIOSize(2, 2, 3, 2).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.EUt(GTValues.VA[1])).setSlotOverlay(false, false, false, (IGuiTexture)GuiTextures.MOLECULAR_OVERLAY_1).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.MOLECULAR_OVERLAY_2).setSlotOverlay(false, true, false, (IGuiTexture)GuiTextures.MOLECULAR_OVERLAY_3).setSlotOverlay(false, true, true, (IGuiTexture)GuiTextures.MOLECULAR_OVERLAY_4).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.VIAL_OVERLAY_1).setSlotOverlay(true, true, (IGuiTexture)GuiTextures.VIAL_OVERLAY_2).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTValues.FOOLS.get() != false ? GTSoundEntries.SCIENCE : GTSoundEntries.CHEMICAL).setMaxTooltips(4).onRecipeBuild((recipeBuilder, provider) -> LARGE_CHEMICAL_RECIPES.copyFrom((GTRecipeBuilder)recipeBuilder).save((Consumer<class_2444>)provider));
    public static final GTRecipeType COMPRESSOR_RECIPES = GTRecipeTypes.register("compressor", "electric", new class_3956[0]).setMaxIOSize(1, 1, 0, 0).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.duration(200).EUt(2L)).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.COMPRESSOR_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_COMPRESS, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSteamProgressBar(GuiTextures.PROGRESS_BAR_COMPRESS_STEAM, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.COMPRESSOR);
    public static final GTRecipeType CUTTER_RECIPES = GTRecipeTypes.register("cutter", "electric", new class_3956[0]).setMaxIOSize(1, 2, 1, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.SAWBLADE_OVERLAY).setSlotOverlay(true, false, false, (IGuiTexture)GuiTextures.CUTTER_OVERLAY).setSlotOverlay(true, false, true, (IGuiTexture)GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_SLICE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.CUT).setMaxTooltips(4).onRecipeBuild((recipeBuilder, provider) -> {
        if (recipeBuilder.input.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList()).isEmpty() && recipeBuilder.tickInput.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList()).isEmpty()) {
            recipeBuilder.copy(new class_2960(recipeBuilder.id.toString() + "_water")).inputFluids(GTMaterials.Water.getFluid((int)Math.max(4L, Math.min(1000L, (long)recipeBuilder.duration * recipeBuilder.EUt() / 320L)))).duration(recipeBuilder.duration * 2).save((Consumer<class_2444>)provider);
            recipeBuilder.copy(new class_2960(recipeBuilder.id.toString() + "_distilled_water")).inputFluids(GTMaterials.DistilledWater.getFluid((int)Math.max(3L, Math.min(750L, (long)recipeBuilder.duration * recipeBuilder.EUt() / 426L)))).duration((int)((double)recipeBuilder.duration * 1.5)).save((Consumer<class_2444>)provider);
            recipeBuilder.inputFluids(GTMaterials.Lubricant.getFluid((int)Math.max(1L, Math.min(250L, (long)recipeBuilder.duration * recipeBuilder.EUt() / 1280L)))).duration(Math.max(1, recipeBuilder.duration));
        }
    });
    public static final GTRecipeType DISTILLERY_RECIPES = GTRecipeTypes.register("distillery", "electric", new class_3956[0]).setMaxIOSize(1, 1, 1, 1).setEUIO(IO.IN).setSlotOverlay(false, true, (IGuiTexture)GuiTextures.BEAKER_OVERLAY_1).setSlotOverlay(true, true, (IGuiTexture)GuiTextures.BEAKER_OVERLAY_4).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.INT_CIRCUIT_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.BOILER);
    public static final GTRecipeType ELECTROLYZER_RECIPES = GTRecipeTypes.register("electrolyzer", "electric", new class_3956[0]).setMaxIOSize(2, 6, 1, 6).setEUIO(IO.IN).setSlotOverlay(false, false, false, (IGuiTexture)GuiTextures.LIGHTNING_OVERLAY_1).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.CANISTER_OVERLAY).setSlotOverlay(false, true, true, (IGuiTexture)GuiTextures.LIGHTNING_OVERLAY_2).setProgressBar(GuiTextures.PROGRESS_BAR_EXTRACT, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.ELECTROLYZER);
    public static final GTRecipeType ELECTROMAGNETIC_SEPARATOR_RECIPES = GTRecipeTypes.register("electromagnetic_separator", "electric", new class_3956[0]).setMaxIOSize(1, 3, 0, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.CRUSHED_ORE_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_MAGNET, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.ARC);
    public static final GTRecipeType EXTRACTOR_RECIPES = GTRecipeTypes.register("extractor", "electric", new class_3956[0]).setMaxIOSize(1, 1, 0, 1).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.duration(400).EUt(2L)).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.EXTRACTOR_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_EXTRACT, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSteamProgressBar(GuiTextures.PROGRESS_BAR_EXTRACT_STEAM, ProgressTexture.FillDirection.LEFT_TO_RIGHT);
    public static final GTRecipeType EXTRUDER_RECIPES = GTRecipeTypes.register("extruder", "electric", new class_3956[0]).setMaxIOSize(2, 1, 0, 0).setEUIO(IO.IN).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.MOLD_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_EXTRUDER, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.COMPRESSOR);
    public static final GTRecipeType FERMENTING_RECIPES = GTRecipeTypes.register("fermenter", "electric", new class_3956[0]).setMaxIOSize(1, 1, 1, 1).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.EUt(2L)).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.DUST_OVERLAY).setSlotOverlay(true, false, true, (IGuiTexture)GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.CHEMICAL);
    public static final GTRecipeType FLUID_HEATER_RECIPES = GTRecipeTypes.register("fluid_heater", "electric", new class_3956[0]).setMaxIOSize(1, 0, 1, 1).setEUIO(IO.IN).setSlotOverlay(false, true, (IGuiTexture)GuiTextures.HEATING_OVERLAY_1).setSlotOverlay(true, true, (IGuiTexture)GuiTextures.HEATING_OVERLAY_2).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.INT_CIRCUIT_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.BOILER);
    public static final GTRecipeType FLUID_SOLIDFICATION_RECIPES = GTRecipeTypes.register("fluid_solidifier", "electric", new class_3956[0]).setMaxIOSize(1, 1, 1, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.SOLIDIFIER_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.COOLING);
    public static final GTRecipeType FORGE_HAMMER_RECIPES = GTRecipeTypes.register("forge_hammer", "electric", new class_3956[0]).setMaxIOSize(1, 1, 0, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.HAMMER_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_HAMMER, ProgressTexture.FillDirection.UP_TO_DOWN).setSteamProgressBar(GuiTextures.PROGRESS_BAR_HAMMER_STEAM, ProgressTexture.FillDirection.UP_TO_DOWN).setSound(GTSoundEntries.FORGE_HAMMER);
    public static final GTRecipeType FORMING_PRESS_RECIPES = GTRecipeTypes.register("forming_press", "electric", new class_3956[0]).setMaxIOSize(6, 1, 0, 0).setEUIO(IO.IN).setProgressBar(GuiTextures.PROGRESS_BAR_COMPRESS, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.COMPRESSOR);
    public static final GTRecipeType LATHE_RECIPES = GTRecipeTypes.register("lathe", "electric", new class_3956[0]).setMaxIOSize(1, 2, 0, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.PIPE_OVERLAY_1).setSlotOverlay(true, false, false, (IGuiTexture)GuiTextures.PIPE_OVERLAY_2).setSlotOverlay(true, false, true, (IGuiTexture)GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_LATHE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.CUT);
    public static final GTRecipeType MIXER_RECIPES = GTRecipeTypes.register("mixer", "electric", new class_3956[0]).setMaxIOSize(6, 1, 2, 1).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_MIXER, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.MIXER);
    public static final GTRecipeType ORE_WASHER_RECIPES = GTRecipeTypes.register("ore_washer", "electric", new class_3956[0]).setMaxIOSize(2, 3, 1, 0).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.duration(400).EUt(16L)).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.CRUSHED_ORE_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_BATH, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.BATH);
    public static final GTRecipeType PACKER_RECIPES = GTRecipeTypes.register("packer", "electric", new class_3956[0]).setMaxIOSize(2, 2, 0, 0).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.EUt(12L).duration(10)).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.BOX_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.BOXED_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_UNPACKER, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.ASSEMBLER);
    public static final GTRecipeType POLARIZER_RECIPES = GTRecipeTypes.register("polarizer", "electric", new class_3956[0]).setMaxIOSize(1, 1, 0, 0).setEUIO(IO.IN).setProgressBar(GuiTextures.PROGRESS_BAR_MAGNET, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.ARC);
    public static final GTRecipeType LASER_ENGRAVER_RECIPES = GTRecipeTypes.register("laser_engraver", "electric", new class_3956[0]).setMaxIOSize(2, 1, 0, 0).setEUIO(IO.IN).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.LENS_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setMaxTooltips(4).setSound(GTSoundEntries.ELECTROLYZER);
    public static final GTRecipeType SIFTER_RECIPES = GTRecipeTypes.register("sifter", "electric", new class_3956[0]).setMaxIOSize(1, 6, 0, 0).setEUIO(IO.IN).setProgressBar(GuiTextures.PROGRESS_BAR_SIFT, ProgressTexture.FillDirection.UP_TO_DOWN).setSound(new ExistingSoundEntry(class_3417.field_15144, class_3419.field_15245));
    public static final GTRecipeType THERMAL_CENTRIFUGE_RECIPES = GTRecipeTypes.register("thermal_centrifuge", "electric", new class_3956[0]).setMaxIOSize(1, 3, 0, 0).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.duration(400).EUt(30L)).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.CRUSHED_ORE_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.CENTRIFUGE);
    public static final GTRecipeType WIREMILL_RECIPES = GTRecipeTypes.register("wiremill", "electric", new class_3956[0]).setMaxIOSize(1, 1, 0, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.WIREMILL_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_WIREMILL, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.MOTOR);
    public static final GTRecipeType CIRCUIT_ASSEMBLER_RECIPES = GTRecipeTypes.register("circuit_assembler", "electric", new class_3956[0]).setMaxIOSize(6, 1, 1, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.CIRCUIT_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_CIRCUIT_ASSEMBLER, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.ASSEMBLER).setMaxTooltips(4).onRecipeBuild((recipeBuilder, provider) -> {
        if (recipeBuilder.input.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList()).isEmpty() && recipeBuilder.tickInput.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList()).isEmpty()) {
            recipeBuilder.copy(new class_2960(recipeBuilder.id.toString() + "_soldering_alloy")).inputFluids(GTMaterials.SolderingAlloy.getFluid(Math.max(1, 72 * recipeBuilder.getSolderMultiplier()))).save((Consumer<class_2444>)provider);
            recipeBuilder.inputFluids(GTMaterials.Tin.getFluid(Math.max(1, 144 * recipeBuilder.getSolderMultiplier())));
        }
    });
    public static final GTRecipeType GAS_COLLECTOR_RECIPES = GTRecipeTypes.register("gas_collector", "electric", new class_3956[0]).setMaxIOSize(1, 0, 0, 1).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.INT_CIRCUIT_OVERLAY).setSlotOverlay(true, true, (IGuiTexture)GuiTextures.CENTRIFUGE_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_GAS_COLLECTOR, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setMaxTooltips(4).setSound(GTSoundEntries.COOLING);
    public static final GTRecipeType ROCK_BREAKER_RECIPES = GTRecipeTypes.register("rock_breaker", "electric", new class_3956[0]).setMaxIOSize(1, 4, 0, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.CRUSHED_ORE_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_MACERATE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSteamProgressBar(GuiTextures.PROGRESS_BAR_MACERATE_STEAM, ProgressTexture.FillDirection.LEFT_TO_RIGHT).prepareBuilder(recipeBuilder -> recipeBuilder.addCondition(RockBreakerCondition.INSTANCE)).setUiBuilder((recipe, widgetGroup) -> {
        class_3611 fluidA = (class_3611)class_7923.field_41173.method_10223(new class_2960(recipe.data.method_10558("fluidA")));
        class_3611 fluidB = (class_3611)class_7923.field_41173.method_10223(new class_2960(recipe.data.method_10558("fluidB")));
        if (fluidA != class_3612.field_15906) {
            widgetGroup.addWidget((Widget)new TankWidget((IFluidStorage)new FluidStorage(FluidStack.create((class_3611)fluidA, (long)1000L)), widgetGroup.getSize().width - 30, widgetGroup.getSize().height - 30, false, false).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT).setShowAmount(false));
        }
        if (fluidB != class_3612.field_15906) {
            widgetGroup.addWidget((Widget)new TankWidget((IFluidStorage)new FluidStorage(FluidStack.create((class_3611)fluidB, (long)1000L)), widgetGroup.getSize().width - 30 - 20, widgetGroup.getSize().height - 30, false, false).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT).setShowAmount(false));
        }
    }).setMaxTooltips(4).setSound(GTSoundEntries.FIRE);
    public static final GTRecipeType COMBUSTION_GENERATOR_FUELS = GTRecipeTypes.register("combustion_generator", "generator", new class_3956[0]).setMaxIOSize(0, 0, 1, 0).setEUIO(IO.OUT).setSlotOverlay(false, true, true, (IGuiTexture)GuiTextures.FURNACE_OVERLAY_2).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.COMBUSTION);
    public static final GTRecipeType GAS_TURBINE_FUELS = GTRecipeTypes.register("gas_turbine", "generator", new class_3956[0]).setMaxIOSize(0, 0, 1, 0).setEUIO(IO.OUT).setSlotOverlay(false, true, true, (IGuiTexture)GuiTextures.DARK_CANISTER_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_GAS_COLLECTOR, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.TURBINE);
    public static final GTRecipeType STEAM_TURBINE_FUELS = GTRecipeTypes.register("steam_turbine", "generator", new class_3956[0]).setMaxIOSize(0, 0, 1, 1).setEUIO(IO.OUT).setSlotOverlay(false, true, true, (IGuiTexture)GuiTextures.CENTRIFUGE_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_GAS_COLLECTOR, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.TURBINE);
    public static final GTRecipeType PLASMA_GENERATOR_FUELS = GTRecipeTypes.register("plasma_generator", "generator", new class_3956[0]).setMaxIOSize(0, 0, 1, 1).setEUIO(IO.OUT).setSlotOverlay(false, true, true, (IGuiTexture)GuiTextures.CENTRIFUGE_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_GAS_COLLECTOR, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.TURBINE);
    public static final GTRecipeType LARGE_BOILER_RECIPES = GTRecipeTypes.register("large_boiler", "multiblock", new class_3956[0]).setMaxIOSize(1, 0, 1, 1).setProgressBar(GuiTextures.PROGRESS_BAR_BOILER_FUEL.get(true), ProgressTexture.FillDirection.DOWN_TO_UP).setMaxTooltips(1).setSound(GTSoundEntries.FURNACE);
    public static final GTRecipeType COKE_OVEN_RECIPES = GTRecipeTypes.register("coke_oven", "multiblock", new class_3956[0]).setMaxIOSize(1, 1, 0, 1).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setMaxTooltips(1).setSound(GTSoundEntries.FIRE);
    public static final GTRecipeType PRIMITIVE_BLAST_FURNACE_RECIPES = GTRecipeTypes.register("primitive_blast_furnace", "multiblock", new class_3956[0]).setMaxIOSize(3, 3, 0, 0).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setMaxTooltips(1).setSound(GTSoundEntries.FIRE);
    public static final GTRecipeType BLAST_RECIPES = GTRecipeTypes.register("electric_blast_furnace", "multiblock", new class_3956[0]).setMaxIOSize(3, 3, 1, 1).setEUIO(IO.IN).addDataInfo(data -> {
        int temp = data.method_10550("ebf_temp");
        ICoilType requiredCoil = ICoilType.getMinRequiredType(temp);
        if (requiredCoil == null || requiredCoil.getMaterial() == null) {
            return LocalizationUtils.format((String)"gtceu.recipe.temperature", (Object[])new Object[]{temp});
        }
        return LocalizationUtils.format((String)"gtceu.recipe.temperature_and_coil", (Object[])new Object[]{temp, class_1074.method_4662((String)requiredCoil.getMaterial().getUnlocalizedName(), (Object[])new Object[0])});
    }).setUiBuilder((recipe, widgetGroup) -> {
        int temp = recipe.data.method_10550("ebf_temp");
        ArrayList<List<class_1799>> items = new ArrayList<List<class_1799>>();
        items.add(GTBlocks.ALL_COILS.entrySet().stream().filter(coil -> ((ICoilType)coil.getKey()).getCoilTemperature() >= temp).map(coil -> new class_1799((class_1935)((Supplier)coil.getValue()).get())).toList());
        widgetGroup.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(items), 0, widgetGroup.getSize().width - 25, widgetGroup.getSize().height - 32, false, false));
    }).setSound(GTSoundEntries.FURNACE);
    public static final GTRecipeType DISTILLATION_RECIPES = GTRecipeTypes.register("distillation_tower", "multiblock", new class_3956[0]).setMaxIOSize(0, 1, 1, 12).setEUIO(IO.IN).setSound(GTSoundEntries.CHEMICAL).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).onRecipeBuild((recipeBuilder, provider) -> {
        if (recipeBuilder.data.method_10577("disable_distillery")) {
            return;
        }
        if (recipeBuilder.output.containsKey(FluidRecipeCapability.CAP)) {
            class_1799 outputItem;
            long EUt = (Long)EURecipeCapability.CAP.of(recipeBuilder.tickInput.get(EURecipeCapability.CAP).get(0).getContent());
            Content inputContent = recipeBuilder.input.get(FluidRecipeCapability.CAP).get(0);
            FluidIngredient input = (FluidIngredient)FluidRecipeCapability.CAP.of(inputContent.getContent());
            class_1799[] outputs = recipeBuilder.output.containsKey(ItemRecipeCapability.CAP) ? ((class_1856)ItemRecipeCapability.CAP.of(recipeBuilder.output.get(ItemRecipeCapability.CAP).get(0).getContent())).method_8105() : null;
            Object object = outputItem = outputs == null || outputs.length == 0 ? class_1799.field_8037 : outputs[0];
            if (input.isEmpty()) {
                return;
            }
            List<Content> contents = recipeBuilder.output.get(FluidRecipeCapability.CAP);
            for (int i = 0; i < contents.size(); ++i) {
                Content outputContent = contents.get(i);
                FluidIngredient output = (FluidIngredient)FluidRecipeCapability.CAP.of(outputContent.getContent());
                if (output.isEmpty()) continue;
                GTRecipeBuilder builder = DISTILLERY_RECIPES.recipeBuilder(recipeBuilder.id.method_12832() + "_to_" + class_7923.field_41173.method_10221((Object)output.getStacks()[0].getFluid()).method_12832(), new Object[0]).EUt(Math.max(1L, EUt / 4L)).circuitMeta(i + 1);
                int ratio = RecipeHelper.getRatioForDistillery(input, output, outputItem);
                int recipeDuration = (int)((double)recipeBuilder.duration * OverclockingLogic.STANDARD_OVERCLOCK_DURATION_DIVISOR);
                boolean shouldDivide = ratio != 1;
                boolean fluidsDivisible = RecipeHelper.isFluidStackDivisibleForDistillery(input, ratio) && RecipeHelper.isFluidStackDivisibleForDistillery(output, ratio);
                FluidIngredient dividedInputFluid = input.copy();
                dividedInputFluid.setAmount(Math.max(1L, dividedInputFluid.getAmount() / (long)ratio));
                FluidIngredient dividedOutputFluid = output.copy();
                dividedOutputFluid.setAmount(Math.max(1L, dividedOutputFluid.getAmount() / (long)ratio));
                if (shouldDivide && fluidsDivisible) {
                    builder.chance(inputContent.chance).tierChanceBoost(inputContent.tierChanceBoost).inputFluids(dividedInputFluid).chance(outputContent.chance).tierChanceBoost(outputContent.tierChanceBoost).outputFluids(dividedOutputFluid).duration(Math.max(1, recipeDuration / ratio));
                } else if (!shouldDivide) {
                    if (!outputItem.method_7960()) {
                        builder.outputItems(outputItem);
                    }
                    builder.conditions.addAll(recipeBuilder.conditions);
                    builder.chance(inputContent.chance).tierChanceBoost(inputContent.tierChanceBoost).inputFluids(input).chance(outputContent.chance).tierChanceBoost(outputContent.tierChanceBoost).outputFluids(output).duration(recipeDuration).save((Consumer<class_2444>)provider);
                    continue;
                }
                if (!outputItem.method_7960()) {
                    boolean itemsDivisible;
                    boolean bl = itemsDivisible = outputItem.method_7947() % ratio == 0 && fluidsDivisible;
                    if (fluidsDivisible && itemsDivisible) {
                        class_1799 stack = outputItem.method_7972();
                        stack.method_7939(stack.method_7947() / ratio);
                        builder.outputItems(stack);
                    }
                }
                builder.save((Consumer<class_2444>)provider);
            }
        }
    });
    public static final GTRecipeType PYROLYSE_RECIPES = GTRecipeTypes.register("pyrolyse_oven", "multiblock", new class_3956[0]).setMaxIOSize(2, 1, 1, 1).setEUIO(IO.IN).setSound(GTSoundEntries.FIRE);
    public static final GTRecipeType CRACKING_RECIPES = GTRecipeTypes.register("cracker", "multiblock", new class_3956[0]).setMaxIOSize(1, 0, 2, 2).setEUIO(IO.IN).setSlotOverlay(false, true, (IGuiTexture)GuiTextures.CRACKING_OVERLAY_1).setSlotOverlay(true, true, (IGuiTexture)GuiTextures.CRACKING_OVERLAY_2).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.CIRCUIT_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_CRACKING, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.FIRE);
    public static final GTRecipeType IMPLOSION_RECIPES = GTRecipeTypes.register("implosion_compressor", "multiblock", new class_3956[0]).setMaxIOSize(3, 2, 0, 0).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.duration(20).EUt(GTValues.VA[1])).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.IMPLOSION_OVERLAY_1).setSlotOverlay(false, false, false, (IGuiTexture)GuiTextures.IMPLOSION_OVERLAY_2).setSlotOverlay(true, false, true, (IGuiTexture)GuiTextures.DUST_OVERLAY).setSound(new ExistingSoundEntry(class_3417.field_15152, class_3419.field_15245));
    public static final GTRecipeType VACUUM_RECIPES = GTRecipeTypes.register("vacuum_freezer", "multiblock", new class_3956[0]).setMaxIOSize(1, 1, 2, 1).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.EUt(GTValues.VA[2])).setSound(GTSoundEntries.COOLING);
    public static final GTRecipeType ASSEMBLY_LINE_RECIPES = GTRecipeTypes.register("assembly_line", "multiblock", new class_3956[0]).setMaxIOSize(16, 1, 4, 0).setEUIO(IO.IN).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.ASSEMBLER);
    public static final GTRecipeType LARGE_CHEMICAL_RECIPES = GTRecipeTypes.register("large_chemical_reactor", "multiblock", new class_3956[0]).setMaxIOSize(3, 3, 5, 4).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.EUt(GTValues.VA[1])).setSlotOverlay(false, false, false, (IGuiTexture)GuiTextures.MOLECULAR_OVERLAY_1).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.MOLECULAR_OVERLAY_2).setSlotOverlay(false, true, false, (IGuiTexture)GuiTextures.MOLECULAR_OVERLAY_3).setSlotOverlay(false, true, true, (IGuiTexture)GuiTextures.MOLECULAR_OVERLAY_4).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.VIAL_OVERLAY_1).setSlotOverlay(true, true, (IGuiTexture)GuiTextures.VIAL_OVERLAY_2).setSound(GTValues.FOOLS.get() != false ? GTSoundEntries.SCIENCE : GTSoundEntries.CHEMICAL).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSmallRecipeMap(CHEMICAL_RECIPES);
    public static final GTRecipeType FUSION_RECIPES = GTRecipeTypes.register("fusion_reactor", "multiblock", new class_3956[0]).setMaxIOSize(0, 0, 2, 1).setEUIO(IO.IN).setProgressBar(GuiTextures.PROGRESS_BAR_FUSION, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.ARC).addDataInfo(data -> LocalizationUtils.format((String)"gtceu.recipe.eu_to_start", (Object[])new Object[]{data.method_10537("eu_to_start")}));
    public static final GTRecipeType DUMMY_RECIPES = new GTRecipeType(GTCEu.id("dummy"), "dummy", new class_3956[0]);
    @Nullable
    public static GTRecipeType CREATE_MIXER_RECIPES;

    public static GTRecipeType register(String name, String group, class_3956<?> ... proxyRecipes) {
        GTRecipeType recipeType = new GTRecipeType(GTCEu.id(name), group, proxyRecipes);
        GTRegistries.register(class_7923.field_41188, recipeType.registryName, recipeType);
        GTRegistries.register(class_7923.field_41189, recipeType.registryName, new GTRecipeSerializer());
        GTRegistries.RECIPE_TYPES.register(recipeType.registryName, recipeType);
        return recipeType;
    }

    public static void init() {
        GCyMRecipeTypes.init();
        if (GTCEu.isCreateLoaded()) {
            CREATE_MIXER_RECIPES = GTRecipeTypes.register("create_mixer", KINETIC, new class_3956[0]).setMaxIOSize(6, 1, 2, 1).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_MIXER, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.MIXER).setMaxTooltips(4).setUiBuilder((recipe, group) -> {
                if (!recipe.conditions.isEmpty() && recipe.conditions.get(0) instanceof RPMCondition) {
                    ItemStackTransfer transfer = new ItemStackTransfer(AllBlocks.SHAFT.asStack());
                    group.addWidget((Widget)new SlotWidget((IItemTransfer)transfer, 0, group.getSize().width - 30, group.getSize().height - 30, false, false));
                }
            });
            MIXER_RECIPES.onRecipeBuild((builder, provider) -> {
                assert (CREATE_MIXER_RECIPES != null);
                CREATE_MIXER_RECIPES.copyFrom((GTRecipeBuilder)builder).duration(Math.max(builder.duration / 2, 1)).rpm(64.0f).save((Consumer<class_2444>)provider);
            });
        }
        if (GTCEu.isKubeJSLoaded()) {
            GTRegistryObjectBuilderTypes.registerFor(GTRegistries.RECIPE_TYPES.getRegistryName());
        }
        GTRegistries.register(class_7923.field_41189, GTCEu.id("gt_recipe_serializer"), GTRecipeSerializer.SERIALIZER);
        GTRegistries.register(class_7923.field_41189, GTCEu.id("facade_cover_serializer"), FacadeCoverRecipe.SERIALIZER);
        GTRegistries.register(class_7923.field_41189, GTCEu.id("strict_shaped_recipe_serializer"), StrictShapedRecipe.SERIALIZER);
        GTRegistries.register(class_7923.field_41189, GTCEu.id("shaped_energy_transfer_recipe_serializer"), ShapedEnergyTransferRecipe.SERIALIZER);
    }

    public static GTRecipeType get(String name) {
        return (GTRecipeType)GTRegistries.RECIPE_TYPES.get(GTCEu.appendId(name));
    }
}

