/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.detector;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.cover.filter.FilterHandler;
import com.gregtechceu.gtceu.api.cover.filter.FilterHandlers;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.IntInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.common.cover.detector.DetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.ItemDetectorCover;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.gregtechceu.gtceu.utils.RedstoneUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextBoxWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class AdvancedItemDetectorCover
extends ItemDetectorCover
implements IUICover {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(AdvancedItemDetectorCover.class, DetectorCover.MANAGED_FIELD_HOLDER);
    private static final int DEFAULT_MIN = 64;
    private static final int DEFAULT_MAX = 512;
    @Persisted
    private int minValue = 64;
    @Persisted
    private int maxValue = 512;
    @Persisted
    @DescSynced
    protected final FilterHandler<class_1799, ItemFilter> filterHandler = FilterHandlers.item(this);

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public AdvancedItemDetectorCover(CoverDefinition definition, ICoverable coverHolder, class_2350 attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    @Override
    public List<class_1799> getAdditionalDrops() {
        List<class_1799> list = super.getAdditionalDrops();
        if (!this.filterHandler.getFilterItem().method_7960()) {
            list.add(this.filterHandler.getFilterItem());
        }
        return list;
    }

    @Override
    protected void update() {
        if (this.coverHolder.getOffsetTimer() % 20L != 0L) {
            return;
        }
        ItemFilter filter = this.filterHandler.getFilter();
        IItemTransfer itemTransfer = this.getItemTransfer();
        if (itemTransfer == null) {
            return;
        }
        int storedItems = 0;
        for (int i = 0; i < itemTransfer.getSlots(); ++i) {
            if (!filter.test(itemTransfer.getStackInSlot(i))) continue;
            storedItems += itemTransfer.getStackInSlot(i).method_7947();
        }
        this.setRedstoneSignalOutput(RedstoneUtil.computeRedstoneBetweenValues(storedItems, this.maxValue, this.minValue, this.isInverted()));
    }

    public void setMinValue(int minValue) {
        this.minValue = class_3532.method_15340((int)minValue, (int)0, (int)(this.maxValue - 1));
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = Math.max(maxValue, 0);
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 176, 170);
        group.addWidget((Widget)new LabelWidget(10, 5, "cover.advanced_item_detector.label"));
        group.addWidget((Widget)new TextBoxWidget(10, 55, 65, List.of(LocalizationUtils.format((String)"cover.advanced_item_detector.min", (Object[])new Object[0]))));
        group.addWidget((Widget)new TextBoxWidget(10, 80, 65, List.of(LocalizationUtils.format((String)"cover.advanced_item_detector.max", (Object[])new Object[0]))));
        group.addWidget((Widget)new IntInputWidget(80, 50, 86, 20, this::getMinValue, this::setMinValue));
        group.addWidget((Widget)new IntInputWidget(80, 75, 86, 20, this::getMaxValue, this::setMaxValue));
        group.addWidget((Widget)new ToggleButtonWidget(9, 20, 20, 20, (IGuiTexture)GuiTextures.INVERT_REDSTONE_BUTTON, this::isInverted, this::setInverted){

            @Override
            public void updateScreen() {
                super.updateScreen();
                this.setHoverTooltips(List.copyOf(LangHandler.getMultiLang("cover.advanced_item_detector.invert." + (this.isPressed ? "enabled" : "disabled"))));
            }
        });
        group.addWidget(this.filterHandler.createFilterSlotUI(148, 100));
        group.addWidget(this.filterHandler.createFilterConfigUI(10, 100, 156, 60));
        return group;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public FilterHandler<class_1799, ItemFilter> getFilterHandler() {
        return this.filterHandler;
    }
}

