/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.cover.filter.FilterHandler;
import com.gregtechceu.gtceu.api.cover.filter.FilterHandlers;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.api.gui.widget.IntInputWidget;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.syncdata.RequireRerender;
import com.gregtechceu.gtceu.api.transfer.item.ItemTransferDelegate;
import com.gregtechceu.gtceu.common.blockentity.ItemPipeBlockEntity;
import com.gregtechceu.gtceu.common.cover.data.DistributionMode;
import com.gregtechceu.gtceu.common.cover.data.ManualIOMode;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_6328;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public class ConveyorCover
extends CoverBehavior
implements IUICover,
IControllable {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ConveyorCover.class, CoverBehavior.MANAGED_FIELD_HOLDER);
    public final int tier;
    public final int maxItemTransferRate;
    @Persisted
    protected int transferRate;
    @Persisted
    @DescSynced
    @RequireRerender
    protected IO io;
    @Persisted
    @DescSynced
    protected DistributionMode distributionMode;
    @Persisted
    @DescSynced
    protected ManualIOMode manualIOMode = ManualIOMode.DISABLED;
    @Persisted
    protected boolean isWorkingEnabled = true;
    protected int itemsLeftToTransferLastSecond;
    private Widget ioModeSwitch;
    @Persisted
    @DescSynced
    protected final FilterHandler<class_1799, ItemFilter> filterHandler;
    protected final ConditionalSubscriptionHandler subscriptionHandler;
    private final Map<class_2350, IItemTransfer> itemTransferWrappers = new EnumMap<class_2350, IItemTransfer>(class_2350.class);

    public ConveyorCover(CoverDefinition definition, ICoverable coverHolder, class_2350 attachedSide, int tier) {
        super(definition, coverHolder, attachedSide);
        this.tier = tier;
        this.itemsLeftToTransferLastSecond = this.transferRate = (this.maxItemTransferRate = 2 * (int)Math.pow(4.0, Math.min(tier, 6)));
        this.io = IO.OUT;
        this.distributionMode = DistributionMode.INSERT_FIRST;
        this.subscriptionHandler = new ConditionalSubscriptionHandler(coverHolder, this::update, this::isSubscriptionActive);
        this.filterHandler = FilterHandlers.item(this).onFilterLoaded(f -> this.configureFilter()).onFilterUpdated(f -> this.configureFilter()).onFilterRemoved(f -> this.configureFilter());
    }

    protected boolean isSubscriptionActive() {
        return this.isWorkingEnabled() && this.getAdjacentItemTransfer() != null;
    }

    @Nullable
    protected IItemTransfer getOwnItemTransfer() {
        return this.coverHolder.getItemTransferCap(this.attachedSide, false);
    }

    @Nullable
    protected IItemTransfer getAdjacentItemTransfer() {
        return ItemTransferHelper.getItemTransfer((class_1937)this.coverHolder.getLevel(), (class_2338)this.coverHolder.getPos().method_10093(this.attachedSide), (class_2350)this.attachedSide.method_10153());
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public boolean canAttach() {
        return this.getOwnItemTransfer() != null;
    }

    public void setTransferRate(int transferRate) {
        if (transferRate <= this.maxItemTransferRate) {
            this.transferRate = transferRate;
        }
    }

    public void setIo(IO io) {
        if (io == IO.IN || io == IO.OUT) {
            this.io = io;
        }
        this.coverHolder.markDirty();
    }

    public void setDistributionMode(DistributionMode distributionMode) {
        this.distributionMode = distributionMode;
        this.coverHolder.markDirty();
    }

    protected void setManualIOMode(ManualIOMode manualIOMode) {
        this.manualIOMode = manualIOMode;
        this.coverHolder.markDirty();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.subscriptionHandler.initialize(this.coverHolder.getLevel());
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        this.subscriptionHandler.unsubscribe();
    }

    @Override
    public List<class_1799> getAdditionalDrops() {
        List<class_1799> list = super.getAdditionalDrops();
        if (!this.filterHandler.getFilterItem().method_7960()) {
            list.add(this.filterHandler.getFilterItem());
        }
        return list;
    }

    @Override
    public void onNeighborChanged(class_2248 block, class_2338 fromPos, boolean isMoving) {
        this.subscriptionHandler.updateSubscription();
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        if (this.isWorkingEnabled != isWorkingAllowed) {
            this.isWorkingEnabled = isWorkingAllowed;
            this.subscriptionHandler.updateSubscription();
        }
    }

    protected void update() {
        long timer = this.coverHolder.getOffsetTimer();
        if (timer % 5L == 0L) {
            if (this.itemsLeftToTransferLastSecond > 0) {
                IItemTransfer adjacentItemTransfer = this.getAdjacentItemTransfer();
                IItemTransfer myItemHandler = this.getOwnItemTransfer();
                if (adjacentItemTransfer != null && myItemHandler != null) {
                    int totalTransferred = switch (this.io) {
                        case IO.IN -> this.doTransferItems(adjacentItemTransfer, myItemHandler, this.itemsLeftToTransferLastSecond);
                        case IO.OUT -> this.doTransferItems(myItemHandler, adjacentItemTransfer, this.itemsLeftToTransferLastSecond);
                        default -> 0;
                    };
                    this.itemsLeftToTransferLastSecond -= totalTransferred;
                }
            }
            if (timer % 20L == 0L) {
                this.itemsLeftToTransferLastSecond = this.transferRate;
            }
            this.subscriptionHandler.updateSubscription();
        }
    }

    protected int doTransferItems(IItemTransfer sourceInventory, IItemTransfer targetInventory, int maxTransferAmount) {
        return this.moveInventoryItems(sourceInventory, targetInventory, maxTransferAmount);
    }

    protected int moveInventoryItems(IItemTransfer sourceInventory, IItemTransfer targetInventory, int maxTransferAmount) {
        ItemFilter filter = this.filterHandler.getFilter();
        int itemsLeftToTransfer = maxTransferAmount;
        for (int srcIndex = 0; srcIndex < sourceInventory.getSlots(); ++srcIndex) {
            class_1799 sourceStack = sourceInventory.extractItem(srcIndex, itemsLeftToTransfer, true);
            if (sourceStack.method_7960() || !filter.test(sourceStack)) continue;
            class_1799 remainder = ItemTransferHelper.insertItem((IItemTransfer)targetInventory, (class_1799)sourceStack, (boolean)true);
            int amountToInsert = sourceStack.method_7947() - remainder.method_7947();
            if (amountToInsert <= 0 || (sourceStack = sourceInventory.extractItem(srcIndex, amountToInsert, false)).method_7960()) continue;
            ItemTransferHelper.insertItem((IItemTransfer)targetInventory, (class_1799)sourceStack, (boolean)false);
            if ((itemsLeftToTransfer -= sourceStack.method_7947()) == 0) break;
        }
        return maxTransferAmount - itemsLeftToTransfer;
    }

    protected static boolean moveInventoryItemsExact(IItemTransfer sourceInventory, IItemTransfer targetInventory, TypeItemInfo itemInfo) {
        class_1799 resultStack = itemInfo.itemStack.method_7972();
        int totalExtractedCount = 0;
        int itemsLeftToExtract = itemInfo.totalCount;
        for (int i = 0; i < itemInfo.slots.size(); ++i) {
            int slotIndex = itemInfo.slots.getInt(i);
            class_1799 extractedStack = sourceInventory.extractItem(slotIndex, itemsLeftToExtract, true);
            if (!extractedStack.method_7960() && class_1799.method_31577((class_1799)resultStack, (class_1799)extractedStack)) {
                totalExtractedCount += extractedStack.method_7947();
                itemsLeftToExtract -= extractedStack.method_7947();
            }
            if (itemsLeftToExtract == 0) break;
        }
        if (totalExtractedCount != itemInfo.totalCount) {
            return false;
        }
        resultStack.method_7939(totalExtractedCount);
        class_1799 remainder = ItemTransferHelper.insertItem((IItemTransfer)targetInventory, (class_1799)resultStack, (boolean)true);
        if (!remainder.method_7960()) {
            return false;
        }
        ItemTransferHelper.insertItem((IItemTransfer)targetInventory, (class_1799)resultStack, (boolean)false);
        itemsLeftToExtract = itemInfo.totalCount;
        for (int i = 0; i < itemInfo.slots.size(); ++i) {
            int slotIndex = itemInfo.slots.getInt(i);
            class_1799 extractedStack = sourceInventory.extractItem(slotIndex, itemsLeftToExtract, false);
            if (!extractedStack.method_7960() && class_1799.method_31577((class_1799)resultStack, (class_1799)extractedStack)) {
                itemsLeftToExtract -= extractedStack.method_7947();
            }
            if (itemsLeftToExtract == 0) break;
        }
        return true;
    }

    protected int moveInventoryItems(IItemTransfer sourceInventory, IItemTransfer targetInventory, Map<class_1799, GroupItemInfo> itemInfos, int maxTransferAmount) {
        ItemFilter filter = this.filterHandler.getFilter();
        int itemsLeftToTransfer = maxTransferAmount;
        for (int i = 0; i < sourceInventory.getSlots(); ++i) {
            class_1799 itemStack = sourceInventory.getStackInSlot(i);
            if (itemStack.method_7960() || !filter.test(itemStack) || !itemInfos.containsKey(itemStack)) continue;
            GroupItemInfo itemInfo = itemInfos.get(itemStack);
            class_1799 extractedStack = sourceInventory.extractItem(i, Math.min(itemInfo.totalCount, itemsLeftToTransfer), true);
            class_1799 remainderStack = ItemTransferHelper.insertItem((IItemTransfer)targetInventory, (class_1799)extractedStack, (boolean)true);
            int amountToInsert = extractedStack.method_7947() - remainderStack.method_7947();
            if (amountToInsert <= 0 || (extractedStack = sourceInventory.extractItem(i, amountToInsert, false)).method_7960()) continue;
            ItemTransferHelper.insertItem((IItemTransfer)targetInventory, (class_1799)extractedStack, (boolean)false);
            itemsLeftToTransfer -= extractedStack.method_7947();
            itemInfo.totalCount -= extractedStack.method_7947();
            if (itemInfo.totalCount == 0) {
                itemInfos.remove(itemStack);
                if (itemInfos.isEmpty()) break;
            }
            if (itemsLeftToTransfer == 0) break;
        }
        return maxTransferAmount - itemsLeftToTransfer;
    }

    @Nonnull
    protected Map<class_1799, TypeItemInfo> countInventoryItemsByType(@Nonnull IItemTransfer inventory) {
        ItemFilter filter = this.filterHandler.getFilter();
        Object2ObjectOpenCustomHashMap result = new Object2ObjectOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());
        for (int srcIndex = 0; srcIndex < inventory.getSlots(); ++srcIndex) {
            class_1799 itemStack = inventory.getStackInSlot(srcIndex);
            if (itemStack.method_7960() || !filter.test(itemStack)) continue;
            TypeItemInfo itemInfo = result.computeIfAbsent(itemStack, s -> new TypeItemInfo((class_1799)s, (IntList)new IntArrayList(), 0));
            itemInfo.totalCount += itemStack.method_7947();
            itemInfo.slots.add(srcIndex);
        }
        return result;
    }

    @Nonnull
    protected Map<class_1799, GroupItemInfo> countInventoryItemsByMatchSlot(@Nonnull IItemTransfer inventory) {
        ItemFilter filter = this.filterHandler.getFilter();
        Object2ObjectOpenCustomHashMap result = new Object2ObjectOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());
        for (int srcIndex = 0; srcIndex < inventory.getSlots(); ++srcIndex) {
            class_1799 itemStack = inventory.getStackInSlot(srcIndex);
            if (itemStack.method_7960() || !filter.test(itemStack)) continue;
            GroupItemInfo itemInfo = result.computeIfAbsent(itemStack, s -> new GroupItemInfo((class_1799)s, 0));
            itemInfo.totalCount += itemStack.method_7947();
        }
        return result;
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 176, 137);
        group.addWidget((Widget)new LabelWidget(10, 5, LocalizationUtils.format((String)this.getUITitle(), (Object[])new Object[]{GTValues.VN[this.tier]})));
        group.addWidget(new IntInputWidget(10, 20, 156, 20, () -> this.transferRate, this::setTransferRate).setMin(1).setMax(this.maxItemTransferRate));
        this.ioModeSwitch = new SwitchWidget(10, 45, 20, 20, (clickData, value) -> {
            this.setIo(value != false ? IO.IN : IO.OUT);
            this.ioModeSwitch.setHoverTooltips(new String[]{LocalizationUtils.format((String)"cover.conveyor.mode", (Object[])new Object[]{LocalizationUtils.format((String)this.io.tooltip, (Object[])new Object[0])})});
        }).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.VANILLA_BUTTON, IO.OUT.icon}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.VANILLA_BUTTON, IO.IN.icon})).setPressed(this.io == IO.IN).setHoverTooltips(new String[]{LocalizationUtils.format((String)"cover.conveyor.mode", (Object[])new Object[]{LocalizationUtils.format((String)this.io.tooltip, (Object[])new Object[0])})});
        group.addWidget(this.ioModeSwitch);
        if (this.shouldDisplayDistributionMode()) {
            group.addWidget((Widget)new EnumSelectorWidget(146, 67, 20, 20, (Enum[])DistributionMode.VALUES, (Enum)this.distributionMode, this::setDistributionMode));
        }
        group.addWidget(new EnumSelectorWidget(146, 107, 20, 20, (Enum[])ManualIOMode.VALUES, (Enum)this.manualIOMode, this::setManualIOMode).setHoverTooltips(new String[]{"cover.universal.manual_import_export.mode.description"}));
        group.addWidget(this.filterHandler.createFilterSlotUI(125, 108));
        group.addWidget(this.filterHandler.createFilterConfigUI(10, 72, 156, 60));
        this.buildAdditionalUI(group);
        return group;
    }

    private boolean shouldDisplayDistributionMode() {
        return this.coverHolder.getLevel().method_8321(this.coverHolder.getPos()) instanceof ItemPipeBlockEntity || this.coverHolder.getLevel().method_8321(this.coverHolder.getPos().method_10093(this.attachedSide)) instanceof ItemPipeBlockEntity;
    }

    @NotNull
    protected String getUITitle() {
        return "cover.conveyor.title";
    }

    protected void buildAdditionalUI(WidgetGroup group) {
    }

    protected void configureFilter() {
    }

    @Override
    public IItemTransfer getItemTransferCap(class_2350 side, IItemTransfer defaultValue) {
        return this.itemTransferWrappers.computeIfAbsent(side, s -> new CoverableItemTransferWrapper(defaultValue));
    }

    public int getTransferRate() {
        return this.transferRate;
    }

    public IO getIo() {
        return this.io;
    }

    public DistributionMode getDistributionMode() {
        return this.distributionMode;
    }

    public ManualIOMode getManualIOMode() {
        return this.manualIOMode;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    public FilterHandler<class_1799, ItemFilter> getFilterHandler() {
        return this.filterHandler;
    }

    protected static class TypeItemInfo {
        public final class_1799 itemStack;
        public final IntList slots;
        public int totalCount;

        public TypeItemInfo(class_1799 itemStack, IntList slots, int totalCount) {
            this.itemStack = itemStack;
            this.slots = slots;
            this.totalCount = totalCount;
        }
    }

    protected static class GroupItemInfo {
        public final class_1799 itemStack;
        public int totalCount;

        public GroupItemInfo(class_1799 itemStack, int totalCount) {
            this.itemStack = itemStack;
            this.totalCount = totalCount;
        }
    }

    private class CoverableItemTransferWrapper
    extends ItemTransferDelegate {
        public CoverableItemTransferWrapper(IItemTransfer delegate) {
            super(delegate);
        }

        @Override
        @NotNull
        public class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate, boolean notifyChanges) {
            if (ConveyorCover.this.io == IO.OUT && ConveyorCover.this.manualIOMode == ManualIOMode.DISABLED) {
                return stack;
            }
            if (ConveyorCover.this.manualIOMode == ManualIOMode.FILTERED && !ConveyorCover.this.filterHandler.test(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate, notifyChanges);
        }

        @Override
        @NotNull
        public class_1799 extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
            if (ConveyorCover.this.io == IO.IN && ConveyorCover.this.manualIOMode == ManualIOMode.DISABLED) {
                return class_1799.field_8037;
            }
            if (ConveyorCover.this.manualIOMode == ManualIOMode.FILTERED) {
                class_1799 result = super.extractItem(slot, amount, true, notifyChanges);
                if (result.method_7960() || !ConveyorCover.this.filterHandler.test(result)) {
                    return class_1799.field_8037;
                }
                return simulate ? result : super.extractItem(slot, amount, false, notifyChanges);
            }
            return super.extractItem(slot, amount, simulate, notifyChanges);
        }
    }
}

