/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.blockentity.fabric;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.fabric.GTCapability;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.common.blockentity.FluidPipeBlockEntity;
import com.gregtechceu.gtceu.common.cover.FluidFilterCover;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.FluidPipeData;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.FluidPipeNet;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.PipeNetRoutePath;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.fluid.fabric.FluidHelperImpl;
import com.lowdragmc.lowdraglib.side.fluid.fabric.FluidTransferHelperImpl;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_6328;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

@ParametersAreNonnullByDefault
@class_6328
public class FluidPipeBlockEntityImpl
extends FluidPipeBlockEntity {
    public FluidPipeBlockEntityImpl(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
    }

    public static FluidPipeBlockEntity create(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        return new FluidPipeBlockEntityImpl(type, pos, blockState);
    }

    public static void onBlockEntityRegister(class_2591<FluidPipeBlockEntity> type) {
        FluidStorage.SIDED.registerForBlockEntity(FluidPipeBlockEntityImpl::getFluidStorage, type);
        GTCapability.CAPABILITY_COVERABLE.registerForBlockEntity((blockEntity, direction) -> blockEntity.getCoverContainer(), type);
        GTCapability.CAPABILITY_TOOLABLE.registerForBlockEntity((blockEntity, direction) -> blockEntity, type);
    }

    @javax.annotation.Nullable
    private static Storage<FluidVariant> getFluidStorage(FluidPipeBlockEntity blockEntity, class_2350 direction) {
        return ((FluidPipeBlockEntityImpl)blockEntity).getFluidStorage(direction);
    }

    @javax.annotation.Nullable
    public Storage<FluidVariant> getFluidStorage(@javax.annotation.Nullable class_2350 side) {
        if (side != null && this.isBlocked(side)) {
            return null;
        }
        if (this.isRemote()) {
            return Storage.empty();
        }
        FluidPipeNet net = this.getFluidPipeNet();
        if (net != null) {
            return new FluidVariantStorage(net, this, side);
        }
        return null;
    }

    public static IFluidTransfer getNetHandler(FluidPipeBlockEntity pipe, @javax.annotation.Nullable class_2350 side) {
        Storage fluidStorage = ((FluidPipeBlockEntityImpl)pipe).getFluidStorage(side);
        if (fluidStorage == null) {
            fluidStorage = Storage.empty();
        }
        return FluidTransferHelperImpl.toFluidTransfer((Storage)fluidStorage);
    }

    class FluidVariantStorage
    extends SnapshotParticipant<FluidPipeNet.Snapshot>
    implements Storage<FluidVariant> {
        private final FluidPipeNet net;
        private final FluidPipeBlockEntity pipe;
        private final List<PipeNetRoutePath> paths;
        @Nullable
        private final class_2350 side;
        private Predicate<FluidStack> filter = fluid -> true;
        Map<class_2338, Set<class_3611>> simulateChannelUsed = new HashMap<class_2338, Set<class_3611>>();
        Object2LongMap<class_2338> simulateThroughputUsed = new Object2LongOpenHashMap();
        boolean isOuterCallbackAdded = false;

        public FluidVariantStorage(FluidPipeNet net, @javax.annotation.Nullable FluidPipeBlockEntity pipe, class_2350 side) {
            CoverBehavior coverBehavior;
            this.net = Objects.requireNonNull(net);
            this.pipe = Objects.requireNonNull(pipe);
            this.paths = net.getNetData(pipe.getPipePos());
            this.side = side;
            if (side != null && (coverBehavior = FluidPipeBlockEntityImpl.this.getCoverContainer().getCoverAtSide(side)) instanceof FluidFilterCover) {
                FluidFilterCover cover = (FluidFilterCover)coverBehavior;
                this.filter = cover.getFluidFilter();
            }
        }

        private long checkPathAvailable(FluidStack stack, PipeNetRoutePath routePath, Map<class_2338, Set<class_3611>> simulateChannelUsed, Object2LongMap<class_2338> simulateThroughputUsed) {
            if (stack.isEmpty()) {
                return 0L;
            }
            long amount = stack.getAmount();
            for (Pair<class_2338, FluidPipeData> node : routePath.getPath()) {
                FluidPipeProperties properties = ((FluidPipeData)node.getB()).properties();
                class_2338 pos = (class_2338)node.getA();
                if (!properties.test(stack)) {
                    return 0L;
                }
                int maxChannel = properties.getChannels() - 1;
                int channel = this.net.getChannel(pos, stack.getFluid());
                Set simulateChannels = simulateChannelUsed.getOrDefault(pos, Collections.emptySet());
                if (!(channel != -1 && channel <= maxChannel || simulateChannels.contains(stack.getFluid()) || (channel = this.net.useChannel(pos, stack.getFluid())) != -1 && channel <= maxChannel)) {
                    return 0L;
                }
                long platformThroughputPerSecond = 20L * properties.getPlatformThroughput();
                long left = platformThroughputPerSecond - this.net.getLastSecondTotalThroughput(pos, channel) - simulateThroughputUsed.getOrDefault((Object)pos, 0L);
                if ((amount = Math.min(amount, left)) != 0L) continue;
                return 0L;
            }
            return amount;
        }

        public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if (resource.isBlank() || !this.filter.test(FluidStack.create((class_3611)resource.getFluid(), (long)maxAmount, (class_2487)resource.getNbt()))) {
                return 0L;
            }
            FluidStack left = FluidStack.create((class_3611)resource.getFluid(), (long)maxAmount, (class_2487)resource.getNbt());
            if (!this.isOuterCallbackAdded) {
                transaction.addOuterCloseCallback((TransactionContext.OuterCloseCallback)this);
            }
            this.updateSnapshots(transaction);
            for (PipeNetRoutePath path : this.paths) {
                FluidFilterCover cover;
                CoverBehavior coverBehavior;
                Storage handler;
                if (Objects.equals(this.pipe.getPipePos(), path.getPipePos()) && (this.side == path.getFaceToHandler() || this.side == null) || (handler = (Storage)FluidStorage.SIDED.find(FluidPipeBlockEntityImpl.this.getPipeLevel(), path.getHandlerPos(), (Object)path.getFaceToHandler().method_10153())) == null) continue;
                ICoverable coverable = GTCapabilityHelper.getCoverable((class_1937)this.net.getLevel(), path.getPipePos(), null);
                if (coverable != null && (coverBehavior = coverable.getCoverAtSide(path.getFaceToHandler())) instanceof FluidFilterCover && !(cover = (FluidFilterCover)coverBehavior).getFluidFilter().test(FluidStack.create((class_3611)resource.getFluid(), (long)maxAmount, (class_2487)resource.getNbt()))) {
                    return 0L;
                }
                long accepted = this.checkPathAvailable(left, path, this.simulateChannelUsed, this.simulateThroughputUsed);
                if (accepted <= 0L) continue;
                FluidStack copied = left.copy();
                copied.setAmount(accepted);
                long filled = handler.insert((Object)FluidHelperImpl.toFluidVariant((FluidStack)copied), copied.getAmount(), transaction);
                if (filled > 0L) {
                    for (Pair<class_2338, FluidPipeData> node : path.getPath()) {
                        class_2338 pos = (class_2338)node.getA();
                        int channel = this.net.getChannel(pos, resource.getFluid());
                        if (channel == -1) continue;
                        this.net.useThroughput(pos, channel, filled);
                    }
                }
                left.shrink(filled);
                if (!left.isEmpty()) continue;
                break;
            }
            return maxAmount - left.getAmount();
        }

        public boolean supportsExtraction() {
            return false;
        }

        public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public Iterator<StorageView<FluidVariant>> iterator() {
            List<FluidPipeBlockStorageView> list = List.of(new FluidPipeBlockStorageView());
            return list.iterator();
        }

        protected FluidPipeNet.Snapshot createSnapshot() {
            return this.net.createSnapshot();
        }

        protected void readSnapshot(FluidPipeNet.Snapshot snapshot) {
            this.net.resetData(snapshot);
        }

        public void setFilter(Predicate<FluidStack> filter) {
            this.filter = filter;
        }

        private record FluidPipeBlockStorageView() implements StorageView<FluidVariant>
        {
            public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
                return 0L;
            }

            public boolean isResourceBlank() {
                return true;
            }

            public FluidVariant getResource() {
                return FluidVariant.blank();
            }

            public long getAmount() {
                return 0L;
            }

            public long getCapacity() {
                return 0L;
            }
        }
    }
}

