/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.blockentity;

import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ILaserContainer;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.common.blockentity.fabric.LaserPipeBlockEntityImpl;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserNetHandler;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeNet;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeType;
import com.gregtechceu.gtceu.common.pipelike.laser.LevelLaserPipeNet;
import com.gregtechceu.gtceu.utils.TaskHandler;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class LaserPipeBlockEntity
extends PipeBlockEntity<LaserPipeType, LaserPipeNet.LaserData> {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(LaserPipeBlockEntity.class, PipeBlockEntity.MANAGED_FIELD_HOLDER);
    protected final EnumMap<class_2350, LaserNetHandler> handlers = new EnumMap(class_2350.class);
    public final ILaserContainer clientCapability = new DefaultLaserContainer();
    private WeakReference<LaserPipeNet> currentPipeNet = new WeakReference<Object>(null);
    protected LaserNetHandler defaultHandler;
    private int ticksActive = 0;
    private int activeDuration = 0;
    @Persisted
    @DescSynced
    private boolean active = false;

    protected LaserPipeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static LaserPipeBlockEntity create(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        void var2_2;
        void var1_1;
        return LaserPipeBlockEntityImpl.create(type, (class_2338)var1_1, (class_2680)var2_2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void onBlockEntityRegister(class_2591<LaserPipeBlockEntity> cableBlockEntityBlockEntityType) {
        LaserPipeBlockEntityImpl.onBlockEntityRegister(cableBlockEntityBlockEntityType);
    }

    public void initHandlers() {
        LaserPipeNet net = this.getLaserPipeNet();
        if (net == null) {
            return;
        }
        for (class_2350 facing : class_2350.values()) {
            this.handlers.put(facing, new LaserNetHandler(net, this, facing));
        }
        this.defaultHandler = new LaserNetHandler(net, this, null);
    }

    public void checkNetwork() {
        if (this.defaultHandler != null) {
            LaserPipeNet current = this.getLaserPipeNet();
            if (this.defaultHandler.getNet() != current) {
                this.defaultHandler.updateNetwork(current);
                for (LaserNetHandler handler : this.handlers.values()) {
                    handler.updateNetwork(current);
                }
            }
        }
    }

    public LaserPipeNet getLaserPipeNet() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return null;
        }
        LaserPipeNet currentPipeNet = (LaserPipeNet)((Object)this.currentPipeNet.get());
        if (currentPipeNet != null && currentPipeNet.isValid() && currentPipeNet.containsNode(this.getPipePos())) {
            return currentPipeNet;
        }
        LevelLaserPipeNet worldNet = (LevelLaserPipeNet)((Object)this.getPipeBlock().getWorldPipeNet((class_3218)this.getPipeLevel()));
        currentPipeNet = (LaserPipeNet)worldNet.getNetFromPos(this.getPipePos());
        if (currentPipeNet != null) {
            this.currentPipeNet = new WeakReference<LaserPipeNet>(currentPipeNet);
        }
        return currentPipeNet;
    }

    public void setActive(boolean active, int duration) {
        boolean stateChanged = false;
        if (this.active && !active) {
            this.active = false;
            stateChanged = true;
        } else if (!this.active && active) {
            this.active = true;
            stateChanged = true;
            this.activeDuration = duration;
            TaskHandler.enqueueServerTask((class_3218)this.method_10997(), () -> {
                if (++this.ticksActive % this.activeDuration == 0) {
                    this.ticksActive = 0;
                    this.setActive(false, -1);
                }
            }, 0);
        } else if (this.active) {
            this.ticksActive = 0;
            this.activeDuration = duration;
        }
        if (stateChanged) {
            this.notifyBlockUpdate();
            this.method_5431();
        }
    }

    @Override
    public boolean canAttachTo(class_2350 side) {
        if (this.field_11863 != null) {
            if (this.field_11863.method_8321(this.method_11016().method_10093(side)) instanceof LaserPipeBlockEntity) {
                return false;
            }
            return GTCapabilityHelper.getLaser(this.field_11863, this.method_11016().method_10093(side), side.method_10153()) != null;
        }
        return false;
    }

    @Override
    protected GTToolType getPipeTuneTool() {
        return GTToolType.WIRE_CUTTER;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public EnumMap<class_2350, LaserNetHandler> getHandlers() {
        return this.handlers;
    }

    public LaserNetHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    public boolean isActive() {
        return this.active;
    }

    private static class DefaultLaserContainer
    implements ILaserContainer {
        private DefaultLaserContainer() {
        }

        @Override
        public long acceptEnergyFromNetwork(class_2350 side, long voltage, long amperage) {
            return 0L;
        }

        @Override
        public boolean inputsEnergy(class_2350 side) {
            return false;
        }

        @Override
        public long changeEnergy(long differenceAmount) {
            return 0L;
        }

        @Override
        public long getEnergyStored() {
            return 0L;
        }

        @Override
        public long getEnergyCapacity() {
            return 0L;
        }

        @Override
        public long getInputAmperage() {
            return 0L;
        }

        @Override
        public long getInputVoltage() {
            return 0L;
        }
    }
}

