/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.blockentity;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.common.blockentity.fabric.KineticMachineBlockEntityImpl;
import com.gregtechceu.gtceu.common.machine.KineticMachineDefinition;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.syncdata.managed.MultiManagedStorage;
import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticEffectHandler;
import com.simibubi.create.foundation.utility.Lang;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class KineticMachineBlockEntity
extends KineticBlockEntity
implements IMachineBlockEntity {
    public final MultiManagedStorage managedStorage = new MultiManagedStorage();
    public final MetaMachine metaMachine;
    private final long offset = GTValues.RNG.method_43048(20);
    public float workingSpeed;
    public boolean reActivateSource;

    protected KineticMachineBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
        this.metaMachine = this.getDefinition().createMetaMachine(this);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static KineticMachineBlockEntity create(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        void var2_2;
        void var1_1;
        return KineticMachineBlockEntityImpl.create(typeIn, (class_2338)var1_1, (class_2680)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void onBlockEntityRegister(class_2591 blockEntityType, NonNullSupplier<BiFunction<MaterialManager, KineticMachineBlockEntity, BlockEntityInstance<? super KineticMachineBlockEntity>>> instanceFactory, boolean renderNormally) {
        void var2_2;
        void var1_1;
        KineticMachineBlockEntityImpl.onBlockEntityRegister(blockEntityType, (NonNullSupplier<BiFunction<MaterialManager, KineticMachineBlockEntity, BlockEntityInstance<? super KineticMachineBlockEntity>>>)var1_1, (boolean)var2_2);
    }

    @Override
    public KineticMachineDefinition getDefinition() {
        return (KineticMachineDefinition)IMachineBlockEntity.super.getDefinition();
    }

    public KineticMachineBlockEntity self() {
        return this;
    }

    public boolean method_11004(int id, int para) {
        if (id == 1) {
            if (this.field_11863 != null && this.field_11863.field_9236) {
                this.scheduleRenderUpdate();
            }
            return true;
        }
        return false;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public MultiManagedStorage getRootStorage() {
        return this.managedStorage;
    }

    public void invalidate() {
        super.invalidate();
        this.metaMachine.onUnload();
    }

    public void method_10996() {
        super.method_10996();
        this.metaMachine.onLoad();
    }

    @Override
    public boolean shouldRenderGrid(class_1657 player, class_1799 held, Set<GTToolType> toolTypes) {
        return this.metaMachine.shouldRenderGrid(player, held, toolTypes);
    }

    @Override
    public ResourceTexture sideTips(class_1657 player, Set<GTToolType> toolTypes, class_2350 side) {
        return this.metaMachine.sideTips(player, toolTypes, side);
    }

    public KineticEffectHandler getEffects() {
        return this.effects;
    }

    public float scheduleWorking(float su, boolean simulate) {
        if (this.getDefinition().isSource()) {
            float speed = Math.min(256.0f, su / this.getDefinition().getTorque());
            if (!simulate) {
                this.workingSpeed = speed;
                this.updateGeneratedRotation();
            }
            return speed * this.getDefinition().getTorque();
        }
        return 0.0f;
    }

    public void scheduleWorking(float su) {
        this.scheduleWorking(su, false);
    }

    public void stopWorking() {
        if (this.getDefinition().isSource() && this.getGeneratedSpeed() != 0.0f) {
            this.workingSpeed = 0.0f;
            this.updateGeneratedRotation();
        }
    }

    public float getGeneratedSpeed() {
        return this.workingSpeed;
    }

    protected void notifyStressCapacityChange(float capacity) {
        this.getOrCreateNetwork().updateCapacityFor((KineticBlockEntity)this, capacity);
    }

    public void removeSource() {
        if (this.getDefinition().isSource() && this.hasSource() && this.isSource()) {
            this.reActivateSource = true;
        }
        super.removeSource();
    }

    public void setSource(class_2338 source) {
        super.setSource(source);
        if (!this.getDefinition().isSource()) {
            return;
        }
        class_2586 tileEntity = this.field_11863.method_8321(source);
        if (tileEntity instanceof KineticBlockEntity) {
            KineticBlockEntity sourceTe = (KineticBlockEntity)tileEntity;
            if (this.reActivateSource && Math.abs(sourceTe.getSpeed()) >= Math.abs(this.getGeneratedSpeed())) {
                this.reActivateSource = false;
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.getDefinition().isSource() && this.reActivateSource) {
            this.updateGeneratedRotation();
            this.reActivateSource = false;
        }
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        float stressBase = this.calculateAddedStressCapacity();
        if (stressBase != 0.0f && IRotate.StressImpact.isEnabled()) {
            Lang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip);
            Lang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
            float speed = this.getTheoreticalSpeed();
            if (speed != this.getGeneratedSpeed() && speed != 0.0f) {
                stressBase *= this.getGeneratedSpeed() / speed;
            }
            speed = Math.abs(speed);
            float stressTotal = stressBase * speed;
            Lang.number((double)stressTotal).translate("generic.unit.stress", new Object[0]).style(class_124.field_1075).space().add(Lang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(class_124.field_1063)).forGoggles(tooltip, 1);
            added = true;
        }
        return added;
    }

    public void updateGeneratedRotation() {
        if (!this.getDefinition().isSource()) {
            return;
        }
        float speed = this.getGeneratedSpeed();
        float prevSpeed = this.speed;
        if (!this.field_11863.field_9236) {
            if (prevSpeed != speed) {
                IRotate.SpeedLevel levelafter;
                IRotate.SpeedLevel levelBefore;
                if (!this.hasSource() && (levelBefore = IRotate.SpeedLevel.of((float)this.speed)) != (levelafter = IRotate.SpeedLevel.of((float)speed))) {
                    this.effects.queueRotationIndicators();
                }
                this.applyNewSpeed(prevSpeed, speed);
            }
            if (this.hasNetwork() && speed != 0.0f) {
                KineticNetwork network = this.getOrCreateNetwork();
                this.notifyStressCapacityChange(this.calculateAddedStressCapacity());
                this.getOrCreateNetwork().updateStressFor((KineticBlockEntity)this, this.calculateStressApplied());
                network.updateStress();
            }
            this.onSpeedChanged(prevSpeed);
            this.sendData();
        }
    }

    public void applyNewSpeed(float prevSpeed, float speed) {
        if (speed == 0.0f) {
            if (this.hasSource()) {
                this.notifyStressCapacityChange(0.0f);
                this.getOrCreateNetwork().updateStressFor((KineticBlockEntity)this, this.calculateStressApplied());
            } else {
                this.detachKinetics();
                this.setSpeed(0.0f);
                this.setNetwork(null);
            }
        } else if (prevSpeed == 0.0f) {
            this.setSpeed(speed);
            this.setNetwork(this.createNetworkId());
            this.attachKinetics();
        } else if (this.hasSource()) {
            if (Math.abs(prevSpeed) >= Math.abs(speed)) {
                if (Math.signum(prevSpeed) != Math.signum(speed)) {
                    this.field_11863.method_22352(this.field_11867, true);
                }
            } else {
                this.detachKinetics();
                this.setSpeed(speed);
                this.source = null;
                this.setNetwork(this.createNetworkId());
                this.attachKinetics();
            }
        } else {
            this.detachKinetics();
            this.setSpeed(speed);
            this.attachKinetics();
        }
    }

    public Long createNetworkId() {
        return this.field_11867.method_10063();
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10548("workingSpeed", this.workingSpeed);
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.workingSpeed = compound.method_10545("workingSpeed") ? compound.method_10583("workingSpeed") : 0.0f;
    }

    @Override
    public MetaMachine getMetaMachine() {
        return this.metaMachine;
    }
}

