/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.client.model.ItemBakedModel;
import com.gregtechceu.gtceu.client.renderer.block.TextureOverrideRenderer;
import com.gregtechceu.gtceu.client.renderer.cover.ICoverableRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.IPartRenderer;
import com.lowdragmc.lowdraglib.client.bakedpipeline.FaceQuad;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.model.custommodel.ICTMPredicate;
import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import com.lowdragmc.lowdraglib.utils.FacadeBlockAndTintGetter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;

public class MachineRenderer
extends TextureOverrideRenderer
implements ICoverableRenderer,
IPartRenderer,
ICTMPredicate {
    public static final class_2960 PIPE_OVERLAY = GTCEu.id("block/overlay/machine/overlay_pipe");
    public static final class_2960 FLUID_OUTPUT_OVERLAY = GTCEu.id("block/overlay/machine/overlay_fluid_output");
    public static final class_2960 ITEM_OUTPUT_OVERLAY = GTCEu.id("block/overlay/machine/overlay_item_output");

    public MachineRenderer(class_2960 modelLocation) {
        super(modelLocation);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean useBlockLight(class_1799 stack) {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean useAO() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderItem(class_1799 stack, class_811 transformType, boolean leftHand, class_4587 matrixStack, class_4597 buffer, int combinedLight, int combinedOverlay, class_1087 model) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof MetaMachineItem) {
            final MetaMachineItem machineItem = (MetaMachineItem)class_17922;
            IItemRendererProvider.disabled.set(true);
            class_310.method_1551().method_1480().method_23179(stack, transformType, leftHand, matrixStack, buffer, combinedLight, combinedOverlay, (class_1087)new ItemBakedModel(){

                @Environment(value=EnvType.CLIENT)
                public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 direction, class_5819 random) {
                    LinkedList<class_777> quads = new LinkedList<class_777>();
                    MachineRenderer.this.renderMachine(quads, machineItem.getDefinition(), null, class_2350.field_11043, direction, random, direction, (class_3665)class_1086.field_5350);
                    return quads;
                }
            });
            IItemRendererProvider.disabled.set(false);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public final List<class_777> renderModel(@javax.annotation.Nullable class_1920 level, @javax.annotation.Nullable class_2338 pos, @javax.annotation.Nullable class_2680 state, @javax.annotation.Nullable class_2350 side, class_5819 rand) {
        class_2248 class_22482;
        if (state != null && (class_22482 = state.method_26204()) instanceof MetaMachineBlock) {
            MetaMachine machine;
            MetaMachineBlock machineBlock = (MetaMachineBlock)class_22482;
            class_2350 frontFacing = machineBlock.getFrontFacing(state);
            MetaMachine metaMachine = machine = level == null || pos == null ? null : machineBlock.getMachine((class_1922)level, pos);
            if (machine != null) {
                IAutoOutputFluid autoOutputFluid;
                class_2350 fluidFace;
                IAutoOutputItem autoOutputItem;
                class_2350 itemFace;
                MachineDefinition definition = machine.getDefinition();
                class_3665 modelState = ModelFactory.getRotation((class_2350)frontFacing);
                class_2350 modelFacing = side == null ? null : ModelFactory.modelFacing((class_2350)side, (class_2350)frontFacing);
                LinkedList<class_777> quads = new LinkedList<class_777>();
                this.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
                if (machine instanceof IAutoOutputItem && (itemFace = (autoOutputItem = (IAutoOutputItem)((Object)machine)).getOutputFacingItems()) != null && side == itemFace) {
                    quads.add(FaceQuad.bakeFace((class_2350)modelFacing, (class_1058)ModelFactory.getBlockSprite((class_2960)PIPE_OVERLAY), (class_3665)modelState));
                }
                if (machine instanceof IAutoOutputFluid && (fluidFace = (autoOutputFluid = (IAutoOutputFluid)((Object)machine)).getOutputFacingFluids()) != null && side == fluidFace) {
                    quads.add(FaceQuad.bakeFace((class_2350)modelFacing, (class_1058)ModelFactory.getBlockSprite((class_2960)PIPE_OVERLAY), (class_3665)modelState));
                }
                if (machine instanceof IAutoOutputItem && (itemFace = (autoOutputItem = (IAutoOutputItem)((Object)machine)).getOutputFacingItems()) != null && side == itemFace && autoOutputItem.isAutoOutputItems()) {
                    quads.add(FaceQuad.bakeFace((class_2350)modelFacing, (class_1058)ModelFactory.getBlockSprite((class_2960)ITEM_OUTPUT_OVERLAY), (class_3665)modelState, (int)-101, (int)15));
                }
                if (machine instanceof IAutoOutputFluid && (fluidFace = (autoOutputFluid = (IAutoOutputFluid)((Object)machine)).getOutputFacingFluids()) != null && side == fluidFace && autoOutputFluid.isAutoOutputFluids()) {
                    quads.add(FaceQuad.bakeFace((class_2350)modelFacing, (class_1058)ModelFactory.getBlockSprite((class_2960)FLUID_OUTPUT_OVERLAY), (class_3665)modelState, (int)-101, (int)15));
                }
                ICoverableRenderer.super.renderCovers(quads, side, rand, machine.getCoverContainer(), modelFacing, modelState);
                return quads;
            }
        }
        return Collections.emptyList();
    }

    @Environment(value=EnvType.CLIENT)
    public void renderBaseModel(List<class_777> quads, MachineDefinition definition, @javax.annotation.Nullable MetaMachine machine, class_2350 frontFacing, @javax.annotation.Nullable class_2350 side, class_5819 rand) {
        quads.addAll(this.getRotatedModel(frontFacing).method_4707(definition.defaultBlockState(), side, rand));
    }

    @Environment(value=EnvType.CLIENT)
    public void renderMachine(List<class_777> quads, MachineDefinition definition, @javax.annotation.Nullable MetaMachine machine, class_2350 frontFacing, @javax.annotation.Nullable class_2350 side, class_5819 rand, @javax.annotation.Nullable class_2350 modelFacing, class_3665 modelState) {
        IMultiPart part;
        if (!(machine instanceof IMultiPart && (part = (IMultiPart)((Object)machine)).replacePartModelWhenFormed() && this.renderReplacedPartMachine(quads, part, frontFacing, side, rand, modelFacing, modelState))) {
            this.renderBaseModel(quads, definition, machine, frontFacing, side, rand);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onPrepareTextureAtlas(class_2960 atlasName, Consumer<class_2960> register) {
        super.onPrepareTextureAtlas(atlasName, register);
        if (atlasName.equals((Object)class_1059.field_5275)) {
            register.accept(PIPE_OVERLAY);
            register.accept(FLUID_OUTPUT_OVERLAY);
            register.accept(ITEM_OUTPUT_OVERLAY);
        }
    }

    public boolean isConnected(class_1920 level, class_2680 state, class_2338 pos, class_2680 sourceState, class_2338 sourcePos, class_2350 side) {
        class_2680 sourceStateAppearance;
        class_2680 stateAppearance = FacadeBlockAndTintGetter.getAppearance((class_2680)state, (class_1920)level, (class_2338)pos, (class_2350)side, (class_2680)sourceState, (class_2338)sourcePos);
        return stateAppearance == (sourceStateAppearance = FacadeBlockAndTintGetter.getAppearance((class_2680)sourceState, (class_1920)level, (class_2338)sourcePos, (class_2350)side, (class_2680)state, (class_2338)pos));
    }
}

