/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.block;

import com.gregtechceu.gtceu.client.model.SpriteOverrider;
import com.gregtechceu.gtceu.client.renderer.block.CTMModelRenderer;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1059;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_793;

public class TextureOverrideRenderer
extends CTMModelRenderer {
    @Nonnull
    protected Map<String, class_2960> override;
    @Nullable
    protected Supplier<Map<String, class_2960>> overrideSupplier;

    public TextureOverrideRenderer(class_2960 model, @Nonnull Map<String, class_2960> override) {
        super(model);
        this.override = override;
        if (LDLib.isClient()) {
            this.registerEvent();
        }
    }

    public TextureOverrideRenderer(class_2960 model, @Nonnull Supplier<Map<String, class_2960>> overrideSupplier) {
        super(model);
        this.override = Collections.emptyMap();
        this.overrideSupplier = overrideSupplier;
        if (LDLib.isClient()) {
            this.registerEvent();
        }
    }

    public TextureOverrideRenderer(class_2960 model) {
        super(model);
        this.override = Collections.emptyMap();
        if (LDLib.isClient()) {
            this.registerEvent();
        }
    }

    public void setTextureOverride(Map<String, class_2960> override) {
        this.override = override;
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    protected class_1087 getItemBakedModel() {
        if (this.itemModel == null) {
            class_793 blockModel;
            class_1100 model = this.getModel();
            if (model instanceof class_793 && (blockModel = (class_793)model).method_3431() == class_1088.field_5400) {
                model = ModelFactory.ITEM_MODEL_GENERATOR.method_3479((Function)new SpriteOverrider(this.override), blockModel);
            }
            this.itemModel = model.method_4753(ModelFactory.getModeBaker(), (Function)new SpriteOverrider(this.override), (class_3665)class_1086.field_5350, this.modelLocation);
        }
        return this.itemModel;
    }

    @Environment(value=EnvType.CLIENT)
    public class_1087 getRotatedModel(class_2350 frontFacing) {
        return this.blockModels.computeIfAbsent(frontFacing, facing -> this.getModel().method_4753(ModelFactory.getModeBaker(), (Function)new SpriteOverrider(this.override), ModelFactory.getRotation((class_2350)facing), this.modelLocation));
    }

    @Environment(value=EnvType.CLIENT)
    public void onPrepareTextureAtlas(class_2960 atlasName, Consumer<class_2960> register) {
        super.onPrepareTextureAtlas(atlasName, register);
        if (atlasName.equals((Object)class_1059.field_5275)) {
            if (this.overrideSupplier != null) {
                this.override = this.overrideSupplier.get();
            }
            for (class_2960 value : this.override.values()) {
                register.accept(new class_2960(value.toString()));
            }
        }
    }

    @Nonnull
    public Map<String, class_2960> getOverride() {
        return this.override;
    }

    @Nullable
    public Supplier<Map<String, class_2960>> getOverrideSupplier() {
        return this.overrideSupplier;
    }
}

