/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.block;

import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.client.model.PipeModel;
import com.gregtechceu.gtceu.client.renderer.cover.ICoverableRenderer;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_811;
import org.jetbrains.annotations.NotNull;

public class PipeBlockRenderer
implements IRenderer,
ICoverableRenderer {
    PipeModel pipeModel;

    public PipeBlockRenderer(PipeModel pipeModel) {
        this.pipeModel = pipeModel;
        if (LDLib.isClient()) {
            this.registerEvent();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void renderItem(class_1799 stack, class_811 transformType, boolean leftHand, class_4587 matrixStack, class_4597 buffer, int combinedLight, int combinedOverlay, class_1087 model) {
        this.pipeModel.renderItem(stack, transformType, leftHand, matrixStack, buffer, combinedLight, combinedOverlay, model);
    }

    public boolean useAO() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean useBlockLight(class_1799 stack) {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public List<class_777> renderModel(class_1920 level, class_2338 pos, class_2680 state, class_2350 side, class_5819 rand) {
        if (level == null) {
            return this.pipeModel.bakeQuads(side, 12);
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IPipeNode) {
            IPipeNode pipeNode = (IPipeNode)class_25862;
            LinkedList<class_777> quads = new LinkedList<class_777>(this.pipeModel.bakeQuads(side, pipeNode.getVisualConnections()));
            class_3665 modelState = ModelFactory.getRotation((class_2350)pipeNode.getCoverContainer().getFrontFacing());
            class_2350 modelFacing = side == null ? null : ModelFactory.modelFacing((class_2350)side, (class_2350)pipeNode.getCoverContainer().getFrontFacing());
            ICoverableRenderer.super.renderCovers(quads, side, rand, pipeNode.getCoverContainer(), modelFacing, modelState);
            return quads;
        }
        return Collections.emptyList();
    }

    @NotNull
    @Environment(value=EnvType.CLIENT)
    public class_1058 getParticleTexture() {
        return this.pipeModel.getParticleTexture();
    }

    @Environment(value=EnvType.CLIENT)
    public void onPrepareTextureAtlas(class_2960 atlasName, Consumer<class_2960> register) {
        if (atlasName.equals((Object)class_1059.field_5275)) {
            this.pipeModel.registerTextureAtlas(register);
        }
    }

    public PipeModel getPipeModel() {
        return this.pipeModel;
    }
}

