/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.bakedpipeline.FaceQuad;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import com.lowdragmc.lowdraglib.utils.ResourceHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_6328;
import net.minecraft.class_777;
import net.minecraft.class_811;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public class WorkableOverlayModel {
    protected final class_2960 location;
    @Environment(value=EnvType.CLIENT)
    public Map<OverlayFace, ActivePredicate> sprites;
    @Environment(value=EnvType.CLIENT)
    public Table<class_2350, class_2350, List<class_777>[][]> caches;

    public WorkableOverlayModel(class_2960 location) {
        this.location = location;
        if (LDLib.isClient()) {
            this.sprites = new EnumMap<OverlayFace, ActivePredicate>(OverlayFace.class);
            this.caches = Tables.newCustomTable(new EnumMap(class_2350.class), () -> new EnumMap(class_2350.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Environment(value=EnvType.CLIENT)
    public List<class_777> bakeQuads(@Nullable class_2350 side, class_2350 frontFacing, boolean isActive, boolean isWorkingEnabled) {
        Table<class_2350, class_2350, List<class_777>[][]> table = this.caches;
        synchronized (table) {
            if (side == null) {
                return Collections.emptyList();
            }
            if (!this.caches.contains((Object)side, (Object)frontFacing)) {
                this.caches.put((Object)side, (Object)frontFacing, (Object)new List[2][2]);
            }
            List[][] cache = (List[][])this.caches.get((Object)side, (Object)frontFacing);
            assert (cache != null);
            if (cache[isActive ? 0 : 1][isWorkingEnabled ? 0 : 1] == null) {
                ArrayList<class_777> quads = new ArrayList<class_777>();
                for (class_2350 renderSide : class_2350.values()) {
                    class_777 quad;
                    class_3665 rotation = ModelFactory.getRotation((class_2350)frontFacing);
                    ActivePredicate predicate = this.sprites.get((Object)OverlayFace.bySide(renderSide));
                    if (predicate == null) continue;
                    class_1058 texture = predicate.getSprite(isActive, isWorkingEnabled);
                    if (texture != null && (quad = FaceQuad.bakeFace((class_238)FaceQuad.BLOCK, (class_2350)renderSide, (class_1058)texture, (class_3665)rotation, (int)-1, (int)0, (boolean)true, (boolean)true)).method_3358() == side) {
                        quads.add(quad);
                    }
                    if ((texture = predicate.getEmissiveSprite(isActive, isWorkingEnabled)) == null) continue;
                    if (ConfigHolder.INSTANCE.client.machinesEmissiveTextures) {
                        quad = FaceQuad.bakeFace((class_238)FaceQuad.BLOCK, (class_2350)renderSide, (class_1058)texture, (class_3665)rotation, (int)-101, (int)15, (boolean)true, (boolean)false);
                        if (quad.method_3358() != side) continue;
                        quads.add(quad);
                        continue;
                    }
                    quad = FaceQuad.bakeFace((class_238)FaceQuad.BLOCK, (class_2350)renderSide, (class_1058)texture, (class_3665)rotation, (int)-1, (int)0, (boolean)true, (boolean)true);
                    if (quad.method_3358() != side) continue;
                    quads.add(quad);
                }
                cache[isActive ? 0 : 1][isWorkingEnabled ? 0 : 1] = quads;
            }
            return cache[isActive ? 0 : 1][isWorkingEnabled ? 0 : 1];
        }
    }

    @NotNull
    @Environment(value=EnvType.CLIENT)
    public class_1058 getParticleTexture() {
        for (ActivePredicate predicate : this.sprites.values()) {
            class_1058 sprite = predicate.getSprite(false, false);
            if (sprite == null) continue;
            return sprite;
        }
        return ModelFactory.getBlockSprite((class_2960)class_1047.method_4539());
    }

    @Environment(value=EnvType.CLIENT)
    public void renderItem(class_1799 stack, class_811 transformType, boolean leftHand, class_4587 matrixStack, class_4597 buffer, int combinedLight, int combinedOverlay, class_1087 model) {
        IItemRendererProvider.disabled.set(true);
        class_310.method_1551().method_1480().method_23179(stack, transformType, leftHand, matrixStack, buffer, combinedLight, combinedOverlay, (state, direction, random) -> this.bakeQuads(direction, class_2350.field_11043, false, false));
        IItemRendererProvider.disabled.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Environment(value=EnvType.CLIENT)
    public void registerTextureAtlas(Consumer<class_2960> register) {
        this.sprites.clear();
        OverlayFace[] overlayFaceArray = this.caches;
        synchronized (this.caches) {
            this.caches.clear();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (OverlayFace overlayFace : OverlayFace.VALUES) {
                String overlayPath = "/overlay_" + overlayFace.name().toLowerCase(Locale.ROOT);
                class_2960 normalSprite = new class_2960(this.location.method_12836(), this.location.method_12832() + overlayPath);
                if (!ResourceHelper.isTextureExist((class_2960)normalSprite)) continue;
                register.accept(normalSprite);
                String active = String.format("%s_active", overlayPath);
                class_2960 activeSprite = new class_2960(this.location.method_12836(), this.location.method_12832() + active);
                if (ResourceHelper.isTextureExist((class_2960)activeSprite)) {
                    register.accept(activeSprite);
                } else {
                    activeSprite = normalSprite;
                }
                String paused = String.format("%s_paused", overlayPath);
                class_2960 pausedSprite = new class_2960(this.location.method_12836(), this.location.method_12832() + paused);
                if (ResourceHelper.isTextureExist((class_2960)pausedSprite)) {
                    register.accept(pausedSprite);
                } else {
                    pausedSprite = normalSprite;
                }
                class_2960 normalSpriteEmissive = new class_2960(this.location.method_12836(), this.location.method_12832() + "_emissive");
                if (ResourceHelper.isTextureExist((class_2960)normalSpriteEmissive)) {
                    register.accept(normalSpriteEmissive);
                } else {
                    normalSpriteEmissive = null;
                }
                class_2960 activeSpriteEmissive = new class_2960(this.location.method_12836(), this.location.method_12832() + active + "_emissive");
                if (ResourceHelper.isTextureExist((class_2960)activeSpriteEmissive)) {
                    register.accept(activeSpriteEmissive);
                } else {
                    activeSpriteEmissive = null;
                }
                class_2960 pausedSpriteEmissive = new class_2960(this.location.method_12836(), this.location.method_12832() + paused + "_emissive");
                if (ResourceHelper.isTextureExist((class_2960)pausedSpriteEmissive)) {
                    register.accept(pausedSpriteEmissive);
                } else {
                    pausedSpriteEmissive = null;
                }
                this.sprites.put(overlayFace, new ActivePredicate(normalSprite, activeSprite, pausedSprite, normalSpriteEmissive, activeSpriteEmissive, pausedSpriteEmissive));
            }
            return;
        }
    }

    public static enum OverlayFace {
        FRONT,
        BACK,
        TOP,
        BOTTOM,
        SIDE;

        public static final OverlayFace[] VALUES;

        public static OverlayFace bySide(class_2350 side) {
            return switch (side) {
                default -> throw new IncompatibleClassChangeError();
                case class_2350.field_11033 -> BOTTOM;
                case class_2350.field_11036 -> TOP;
                case class_2350.field_11043 -> FRONT;
                case class_2350.field_11035 -> BACK;
                case class_2350.field_11039, class_2350.field_11034 -> SIDE;
            };
        }

        static {
            VALUES = OverlayFace.values();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ActivePredicate {
        private final class_2960 normalSprite;
        private final class_2960 activeSprite;
        private final class_2960 pausedSprite;
        private final class_2960 normalSpriteEmissive;
        private final class_2960 activeSpriteEmissive;
        private final class_2960 pausedSpriteEmissive;

        public ActivePredicate(@Nullable class_2960 normalSprite, @Nullable class_2960 activeSprite, @Nullable class_2960 pausedSprite, @Nullable class_2960 normalSpriteEmissive, @Nullable class_2960 activeSpriteEmissive, @Nullable class_2960 pausedSpriteEmissive) {
            this.normalSprite = normalSprite;
            this.activeSprite = activeSprite;
            this.pausedSprite = pausedSprite;
            this.normalSpriteEmissive = normalSpriteEmissive;
            this.activeSpriteEmissive = activeSpriteEmissive;
            this.pausedSpriteEmissive = pausedSpriteEmissive;
        }

        @Nullable
        public class_1058 getSprite(boolean active, boolean workingEnabled) {
            return this.getTextureAtlasSprite(active, workingEnabled, this.activeSprite, this.pausedSprite, this.normalSprite);
        }

        @Nullable
        public class_1058 getEmissiveSprite(boolean active, boolean workingEnabled) {
            return this.getTextureAtlasSprite(active, workingEnabled, this.activeSpriteEmissive, this.pausedSpriteEmissive, this.normalSpriteEmissive);
        }

        @Nullable
        private class_1058 getTextureAtlasSprite(boolean active, boolean workingEnabled, @Nullable class_2960 activeSprite, @Nullable class_2960 pausedSprite, @Nullable class_2960 normalSprite) {
            if (active) {
                if (workingEnabled) {
                    return activeSprite == null ? null : ModelFactory.getBlockSprite((class_2960)activeSprite);
                }
                if (pausedSprite != null) {
                    return ModelFactory.getBlockSprite((class_2960)pausedSprite);
                }
            }
            return normalSprite == null ? null : ModelFactory.getBlockSprite((class_2960)normalSprite);
        }
    }
}

