/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class TooltipsHandler {
    private static final String ITEM_PREFIX = "item.gtceu";
    private static final String BLOCK_PREFIX = "block.gtceu";

    public static void appendTooltips(class_1799 stack, class_1836 flag, List<class_2561> tooltips) {
        String translationKey;
        UnificationEntry unificationEntry;
        IElectricItem energyItem = GTCapabilityHelper.getElectricItem(stack);
        if (energyItem != null) {
            tooltips.add(1, (class_2561)class_2561.method_43469((String)"metaitem.generic.electric_item.stored", (Object[])new Object[]{energyItem.getCharge(), energyItem.getMaxCharge(), class_2561.method_43470((String)String.format("%.2f%%", Float.valueOf((float)energyItem.getCharge() * 100.0f / (float)energyItem.getMaxCharge()))).method_27692(class_124.field_1060)}));
        }
        if ((unificationEntry = ChemicalHelper.getUnificationEntry((class_1935)stack.method_7909())) != null && unificationEntry.material != null && unificationEntry.material.getChemicalFormula() != null && !unificationEntry.material.getChemicalFormula().isEmpty()) {
            tooltips.add(1, (class_2561)class_2561.method_43470((String)unificationEntry.material.getChemicalFormula()).method_27692(class_124.field_1054));
        }
        if ((translationKey = stack.method_7922()).startsWith(ITEM_PREFIX) || translationKey.startsWith(BLOCK_PREFIX)) {
            String tooltipKey = translationKey + ".tooltip";
            if (class_1074.method_4663((String)tooltipKey)) {
                tooltips.add(1, (class_2561)class_2561.method_43471((String)tooltipKey));
            } else {
                List<class_5250> multiLang = LangHandler.getMultiLang(tooltipKey);
                if (multiLang != null && multiLang.size() > 0) {
                    tooltips.addAll(1, multiLang);
                }
            }
        }
    }

    public static void appendFluidTooltips(class_3611 fluid, List<class_2561> tooltips, class_1836 flag) {
        Material material = ChemicalHelper.getMaterial(fluid);
        if (material != null && material.getChemicalFormula() != null && !material.getChemicalFormula().isEmpty()) {
            tooltips.add(1, (class_2561)class_2561.method_43470((String)material.getChemicalFormula()).method_27692(class_124.field_1054));
        }
    }
}

