/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.registry.registrate.fabric;

import com.google.common.base.Preconditions;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.fluids.FluidState;
import com.gregtechceu.gtceu.api.fluids.GTFluid;
import com.gregtechceu.gtceu.api.fluids.fabric.GTFluidImpl;
import com.gregtechceu.gtceu.api.item.fabric.GTBucketItem;
import com.gregtechceu.gtceu.api.registry.registrate.IGTFluidBuilder;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.AbstractBuilder;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.Builder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.fabric.EnvExecutor;
import com.tterrag.registrate.fabric.FluidHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelFile;
import io.github.fabricators_of_create.porting_lib.models.generators.block.BlockModelBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.client.render.fluid.v1.SimpleFluidRenderHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributeHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1074;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2404;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_4970;
import net.minecraft.class_6328;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

@class_6328
@ParametersAreNonnullByDefault
public class GTFluidBuilder<P>
extends AbstractBuilder<class_3611, GTFluidImpl.Flowing, P, GTFluidBuilder<P>>
implements IGTFluidBuilder {
    public int temperature = 300;
    public int density = 1000;
    public int luminance = 0;
    public int viscosity = 1000;
    public int color = -1;
    public int burnTime = -1;
    public FluidState state;
    private final String sourceName;
    private final String bucketName;
    private final Material material;
    private final String langKey;
    private final class_2960 stillTexture;
    private final class_2960 flowingTexture;
    @javax.annotation.Nullable
    private AttributeHandlerProvider attributeHandler;
    @javax.annotation.Nullable
    private Boolean defaultSource;
    @javax.annotation.Nullable
    private Boolean defaultBlock;
    @javax.annotation.Nullable
    private Boolean defaultBucket;
    @javax.annotation.Nullable
    private Supplier<Supplier<class_1921>> layer = null;
    @javax.annotation.Nullable
    private NonNullSupplier<? extends GTFluid> source;
    @javax.annotation.Nullable
    private NonNullSupplier<? extends class_2404> block;
    @javax.annotation.Nullable
    private NonNullSupplier<? extends class_1755> bucket;
    private final List<class_6862<class_3611>> tags = new ArrayList<class_6862<class_3611>>();

    public GTFluidBuilder(AbstractRegistrate<?> owner, P parent, final Material material, String name, final String langKey, BuilderCallback callback, class_2960 stillTexture, class_2960 flowingTexture) {
        super(owner, parent, "flowing_" + name, callback, class_7924.field_41270);
        this.sourceName = name;
        this.bucketName = name + "_bucket";
        this.material = material;
        this.langKey = langKey;
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
        this.attributeHandler = (temperature, density, luminance, viscosity) -> new FluidVariantAttributeHandler(){

            public class_2561 getName(FluidVariant fluidVariant) {
                String key = "fluid." + class_7923.field_41173.method_10221((Object)fluidVariant.getFluid()).method_42094();
                return class_1074.method_4663((String)key) ? class_2561.method_43471((String)key) : class_2561.method_43469((String)langKey, (Object[])new Object[]{material.getLocalizedName()});
            }

            public int getLuminance(FluidVariant variant) {
                return luminance;
            }

            public int getTemperature(FluidVariant variant) {
                return temperature;
            }

            public int getViscosity(FluidVariant variant, @Nullable class_1937 world) {
                return viscosity;
            }

            public boolean isLighterThanAir(FluidVariant variant) {
                return density < 1000;
            }
        };
        this.defaultBucket();
    }

    public GTFluidBuilder<P> defaultLang() {
        return this.lang(this.langKey != null ? this.langKey : this.material.getUnlocalizedName());
    }

    public GTFluidBuilder<P> lang(String name) {
        return (GTFluidBuilder)this.lang(flowing -> FluidHelper.getDescriptionId((class_3611)flowing.method_15751()), name);
    }

    public GTFluidBuilder<P> renderType(Supplier<Supplier<class_1921>> layer) {
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> GTFluidBuilder.lambda$renderType$2((Supplier)layer));
        if (this.layer == null) {
            this.onRegister(this::registerRenderType);
        }
        this.layer = layer;
        return this;
    }

    protected void registerRenderType(GTFluidImpl.Flowing entry) {
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            if (this.layer != null) {
                class_1921 layer = this.layer.get().get();
                BlockRenderLayerMap.INSTANCE.putFluids(layer, new class_3611[]{entry, this.getSource()});
            }
        });
    }

    public GTFluidBuilder<P> defaultSource() {
        if (this.defaultSource != null) {
            throw new IllegalStateException("Cannot set a default source after a custom source has been created");
        }
        this.defaultSource = true;
        return this;
    }

    public GTFluidBuilder<P> source(NonNullSupplier<? extends GTFluid> factory) {
        this.defaultSource = false;
        this.source = NonNullSupplier.lazy(() -> factory.get());
        return this;
    }

    public GTFluidBuilder<P> defaultBlock() {
        if (this.defaultBlock != null) {
            throw new IllegalStateException("Cannot set a default block after a custom block has been created");
        }
        this.defaultBlock = true;
        return this;
    }

    public BlockBuilder<class_2404, GTFluidBuilder<P>> block() {
        return this.block1(class_2404::new);
    }

    public <B extends class_2404> BlockBuilder<B, GTFluidBuilder<P>> block(NonNullBiFunction<NonNullSupplier<GTFluidImpl.Flowing>, class_4970.class_2251, ? extends B> factory) {
        if (this.defaultBlock == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to block/noBlock per builder allowed");
        }
        this.defaultBlock = false;
        NonNullSupplier supplier = this.asSupplier();
        return (BlockBuilder)((BlockBuilder)this.getOwner().block((Object)this, this.sourceName, p -> (class_2404)factory.apply((Object)supplier, p)).properties(p -> class_4970.class_2251.method_9630((class_4970)class_2246.field_10382).method_42327()).setData(ProviderType.LANG, NonNullBiConsumer.noop())).blockstate((ctx, prov) -> prov.simpleBlock((class_2248)ctx.getEntry(), (ModelFile)((BlockModelBuilder)prov.models().getBuilder(this.sourceName)).texture("particle", this.stillTexture))).onRegister(block -> {
            this.block = () -> block;
        });
    }

    public <B extends class_2404> BlockBuilder<B, GTFluidBuilder<P>> block1(NonNullBiFunction<? extends GTFluidImpl.Flowing, class_4970.class_2251, ? extends B> factory) {
        return this.block((supplier, settings) -> (class_2404)factory.apply((Object)((GTFluidImpl.Flowing)supplier.get()), settings));
    }

    public GTFluidBuilder<P> noBlock() {
        if (this.defaultBlock == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to block/noBlock per builder allowed");
        }
        this.defaultBlock = false;
        return this;
    }

    public GTFluidBuilder<P> defaultBucket() {
        if (this.defaultBucket != null) {
            throw new IllegalStateException("Cannot set a default bucket after a custom bucket has been created");
        }
        this.defaultBucket = true;
        return this;
    }

    public GTFluidBuilder<P> noBucket() {
        if (this.defaultBucket == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to bucket/noBucket per builder allowed");
        }
        this.defaultBucket = false;
        return this;
    }

    public ItemBuilder<GTBucketItem, GTFluidBuilder<P>> bucket() {
        if (this.defaultBucket == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to bucket/noBucket per builder allowed");
        }
        this.defaultBucket = false;
        return (ItemBuilder)((ItemBuilder)((ItemBuilder)this.getOwner().item((Object)this, this.bucketName, p -> new GTBucketItem((Supplier<? extends class_3611>)this.source, (class_1792.class_1793)p, this.material, this.langKey)).onRegister(GTBucketItem::onRegister)).properties(p -> p.method_7896(class_1802.field_8550).method_7889(1)).color(() -> () -> GTBucketItem::color).setData(ProviderType.LANG, NonNullBiConsumer.noop())).model(NonNullBiConsumer.noop()).onRegister(bucket -> {
            this.bucket = () -> bucket;
        });
    }

    @SafeVarargs
    public final GTFluidBuilder<P> tag(class_6862<class_3611> ... tags) {
        GTFluidBuilder ret = (GTFluidBuilder)this.tag(ProviderType.FLUID_TAGS, tags);
        if (this.tags.isEmpty()) {
            ret.getOwner().setDataGenerator(ret.sourceName, this.getRegistryKey(), ProviderType.FLUID_TAGS, prov -> this.tags.stream().map(arg_0 -> ((RegistrateTagsProvider)prov).addTag(arg_0)).forEach(p -> p.add(this.getSource().method_40178().method_40237())));
        }
        this.tags.addAll(Arrays.asList(tags));
        return ret;
    }

    private GTFluid getSource() {
        NonNullSupplier<? extends GTFluid> source = this.source;
        Preconditions.checkNotNull(source, (Object)("Fluid has no source block: " + this.sourceName));
        return (GTFluid)source.get();
    }

    protected GTFluidImpl.Flowing createEntry() {
        return new GTFluidImpl.Flowing(this.state, () -> (class_3611)this.source.get(), () -> (class_3611)this.get().get(), () -> this.block != null ? (class_2404)this.block.get() : null, () -> this.bucket != null ? (class_1792)this.bucket.get() : null, this.burnTime);
    }

    @Environment(value=EnvType.CLIENT)
    protected void registerDefaultRenderer(GTFluidImpl.Flowing flowing) {
        FluidRenderHandlerRegistry.INSTANCE.register((class_3611)this.getSource(), (class_3611)flowing, (FluidRenderHandler)new SimpleFluidRenderHandler(this.stillTexture, this.flowingTexture, this.color));
    }

    @Override
    public GTFluidBuilder<P> hasBlock(boolean hasBlock) {
        if (hasBlock && this.defaultBlock == null) {
            this.defaultBlock();
        }
        if (!hasBlock && this.defaultBlock != null) {
            this.noBlock();
        }
        return this;
    }

    @Override
    public IGTFluidBuilder hasBucket(boolean hasBucket) {
        if (hasBucket && this.defaultBucket == null) {
            this.defaultBucket();
        }
        if (!hasBucket && this.defaultBucket != null) {
            this.noBucket();
        }
        return this;
    }

    @Override
    public IGTFluidBuilder onFluidRegister(Consumer<class_3611> fluidConsumer) {
        return (IGTFluidBuilder)this.onRegister(fluidConsumer::accept);
    }

    public RegistryEntry<GTFluidImpl.Flowing> register() {
        NonNullSupplier<? extends GTFluid> source;
        if (this.attributeHandler != null) {
            this.onRegister(entry -> {
                FluidVariantAttributeHandler handler = this.attributeHandler.create(this.temperature, this.density, this.luminance, this.viscosity);
                FluidVariantAttributes.register((class_3611)entry, (FluidVariantAttributeHandler)handler);
                FluidVariantAttributes.register((class_3611)this.getSource(), (FluidVariantAttributeHandler)handler);
            });
        }
        if (this.defaultSource == Boolean.TRUE) {
            this.source((NonNullSupplier<GTFluid>)((NonNullSupplier)() -> new GTFluidImpl.Source(this.state, () -> (class_3611)this.source.get(), () -> (class_3611)this.get().get(), () -> this.block != null ? (class_2404)this.block.get() : null, () -> this.bucket != null ? (class_1792)this.bucket.get() : null, this.burnTime)));
        }
        if (this.defaultBlock == Boolean.TRUE) {
            this.block().register();
        }
        if (this.defaultBucket == Boolean.TRUE) {
            this.bucket().register();
        }
        if ((source = this.source) == null) {
            throw new IllegalStateException("Fluid must have a source version: " + this.getName());
        }
        this.getCallback().accept(this.sourceName, class_7924.field_41270, (Builder)this, () -> source.get());
        return super.register();
    }

    @Override
    public Supplier<? extends class_3611> registerFluid() {
        this.register();
        return this.source;
    }

    @Override
    public GTFluidBuilder<P> temperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    @Override
    public GTFluidBuilder<P> density(int density) {
        this.density = density;
        return this;
    }

    @Override
    public GTFluidBuilder<P> luminance(int luminance) {
        this.luminance = luminance;
        return this;
    }

    @Override
    public GTFluidBuilder<P> viscosity(int viscosity) {
        this.viscosity = viscosity;
        return this;
    }

    @Override
    public GTFluidBuilder<P> color(int color) {
        this.color = color;
        return this;
    }

    @Override
    public GTFluidBuilder<P> burnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    @Override
    public GTFluidBuilder<P> state(FluidState state) {
        this.state = state;
        return this;
    }

    private static /* synthetic */ void lambda$renderType$2(Supplier layer) {
        Preconditions.checkArgument((boolean)class_1921.method_22720().contains(((Supplier)layer.get()).get()), (Object)("Invalid render type: " + layer));
    }

    @FunctionalInterface
    static interface AttributeHandlerProvider {
        public FluidVariantAttributeHandler create(int var1, int var2, int var3, int var4);
    }
}

