/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.registry.registrate;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.sound.ConfiguredSoundEvent;
import com.gregtechceu.gtceu.api.sound.CustomSoundEntry;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import com.gregtechceu.gtceu.api.sound.WrappedSoundEntry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_6328;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

@ParametersAreNonnullByDefault
@class_6328
public class SoundEntryBuilder {
    protected class_2960 id;
    protected String subtitle = "unregistered";
    protected class_3419 category = class_3419.field_15245;
    protected List<ConfiguredSoundEvent> wrappedEvents = new ArrayList<ConfiguredSoundEvent>();
    protected List<class_2960> variants = new ArrayList<class_2960>();
    protected int attenuationDistance;

    public SoundEntryBuilder(class_2960 id) {
        this.id = id;
    }

    public SoundEntryBuilder subtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    public SoundEntryBuilder attenuationDistance(int distance) {
        this.attenuationDistance = distance;
        return this;
    }

    public SoundEntryBuilder noSubtitle() {
        this.subtitle = null;
        return this;
    }

    public SoundEntryBuilder category(class_3419 category) {
        this.category = category;
        return this;
    }

    public SoundEntryBuilder addVariant(String name) {
        return this.addVariant(GTCEu.id(name));
    }

    public SoundEntryBuilder addVariant(class_2960 id) {
        this.variants.add(id);
        return this;
    }

    public SoundEntryBuilder playExisting(Supplier<class_3414> event, float volume, float pitch) {
        this.wrappedEvents.add(new ConfiguredSoundEvent(event, volume, pitch));
        return this;
    }

    public SoundEntryBuilder playExisting(class_3414 event, float volume, float pitch) {
        return this.playExisting(() -> event, volume, pitch);
    }

    public SoundEntryBuilder playExisting(class_3414 event) {
        return this.playExisting(event, 1.0f, 1.0f);
    }

    public SoundEntry build() {
        SoundEntry entry = this.wrappedEvents.isEmpty() ? new CustomSoundEntry(this.id, this.variants, this.subtitle, this.category, this.attenuationDistance) : new WrappedSoundEntry(this.id, this.subtitle, this.wrappedEvents, this.category, this.attenuationDistance);
        GTRegistries.SOUNDS.register(entry.getId(), entry);
        return entry;
    }

    public static class SoundEntryProvider
    implements class_2405 {
        private final class_7784 output;
        private final String modId;

        public SoundEntryProvider(class_7784 output, String modId) {
            this.output = output;
            this.modId = modId;
        }

        public CompletableFuture<?> method_10319(class_7403 cache) {
            return this.generate(this.output.method_45972(class_7784.class_7490.field_39368).resolve(this.modId), cache);
        }

        public String method_10321() {
            return this.modId + "'s Custom Sounds";
        }

        public CompletableFuture<?> generate(Path path, class_7403 cache) {
            JsonObject json = new JsonObject();
            try {
                for (SoundEntry sound : GTRegistries.SOUNDS) {
                    if (!sound.getId().method_12836().equals(this.modId)) continue;
                    sound.write(json);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return class_2405.method_10320((class_7403)cache, (JsonElement)json, (Path)path.resolve("sounds.json"));
        }
    }
}

