/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.registry.registrate;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.json.SimpleIGuiTextureJsonUtils;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_6328;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

@ParametersAreNonnullByDefault
@class_6328
public class CompassSection {
    private final class_2960 sectionID;
    private Supplier<IGuiTexture> icon = () -> IGuiTexture.EMPTY;
    @Nullable
    private Supplier<IGuiTexture> background = null;
    private int priority = 99;
    private String lang;

    private CompassSection(String section) {
        this.sectionID = GTCEu.id(section);
        this.lang = FormattingUtil.toEnglishName(section);
    }

    public static CompassSection create(String section) {
        return new CompassSection(section);
    }

    public CompassSection register() {
        GTRegistries.COMPASS_SECTIONS.register(this.sectionID, this);
        return this;
    }

    public String getUnlocalizedKey() {
        return this.sectionID.method_42093("compass.section");
    }

    public class_2960 sectionID() {
        return this.sectionID;
    }

    public CompassSection icon(Supplier<IGuiTexture> icon) {
        this.icon = icon;
        return this;
    }

    public CompassSection background(@Nullable Supplier<IGuiTexture> background) {
        this.background = background;
        return this;
    }

    public CompassSection priority(int priority) {
        this.priority = priority;
        return this;
    }

    public CompassSection lang(String lang) {
        this.lang = lang;
        return this;
    }

    public String lang() {
        return this.lang;
    }

    public static class CompassSectionProvider
    implements class_2405 {
        private final class_7784 output;
        private final Predicate<class_2960> existingHelper;

        public CompassSectionProvider(class_7784 output, Predicate<class_2960> existingHelper) {
            this.output = output;
            this.existingHelper = existingHelper;
        }

        public CompletableFuture<?> method_10319(class_7403 cache) {
            return this.generate(this.output.method_45972(class_7784.class_7490.field_39368).resolve("gtceu"), cache);
        }

        public String method_10321() {
            return "GTCEU's Compass Sections";
        }

        public CompletableFuture<?> generate(Path path, class_7403 cache) {
            return CompletableFuture.allOf((CompletableFuture[])GTRegistries.COMPASS_SECTIONS.values().stream().map(section -> {
                String resourcePath = "compass/sections/" + section.sectionID.method_12832() + ".json";
                if (this.existingHelper.test(GTCEu.id(resourcePath))) {
                    return null;
                }
                JsonObject json = new JsonObject();
                json.add("button_texture", (JsonElement)SimpleIGuiTextureJsonUtils.toJson((IGuiTexture)section.icon.get()));
                if (section.background != null) {
                    json.add("background_texture", (JsonElement)SimpleIGuiTextureJsonUtils.toJson((IGuiTexture)section.background.get()));
                }
                json.addProperty("priority", (Number)section.priority);
                return class_2405.method_10320((class_7403)cache, (JsonElement)json, (Path)path.resolve(resourcePath));
            }).filter(Objects::nonNull).toArray(CompletableFuture[]::new));
        }
    }
}

