/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public abstract class GTRegistry<K, V>
implements Iterable<V> {
    protected final BiMap<K, V> registry = this.initRegistry();
    protected final class_2960 registryName;
    protected boolean isFrozen = false;

    public GTRegistry(class_2960 registryName) {
        this.registryName = registryName;
        if (!registryName.method_12832().equals("root")) {
            GTRegistries.REGISTRIES.register(registryName, this);
        }
    }

    protected BiMap<K, V> initRegistry() {
        return HashBiMap.create();
    }

    public boolean containKey(K key) {
        return this.registry.containsKey(key);
    }

    public boolean containValue(V value) {
        return this.registry.containsValue(value);
    }

    public void freeze() {
        this.isFrozen = true;
    }

    public void register(K key, V value) {
        if (this.isFrozen) {
            throw new IllegalStateException("[register] registry %s has been frozen");
        }
        if (this.containKey(key)) {
            throw new IllegalStateException("[register] registry %s contains key %s already".formatted(this.registryName, key));
        }
        this.registry.put(key, value);
    }

    @Nullable
    public V replace(K key, V value) {
        if (this.isFrozen) {
            throw new IllegalStateException("[replace] registry %s has been frozen");
        }
        if (!this.containKey(key)) {
            GTCEu.LOGGER.warn("[replace] couldn't find key %s in registry %s".formatted(this.registryName, key));
        }
        return (V)this.registry.put(key, value);
    }

    public V registerOrOverride(K key, V value) {
        if (this.isFrozen) {
            throw new IllegalStateException("[register] registry %s has been frozen");
        }
        return (V)this.registry.put(key, value);
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        return this.registry.values().iterator();
    }

    public Set<V> values() {
        return this.registry.values();
    }

    public Set<K> keys() {
        return this.registry.keySet();
    }

    public Set<Map.Entry<K, V>> entries() {
        return this.registry.entrySet();
    }

    public Map<K, V> registry() {
        return this.registry;
    }

    @Nullable
    public V get(K key) {
        return (V)this.registry.get(key);
    }

    public V getOrDefault(K key, V defaultValue) {
        return (V)this.registry.getOrDefault(key, defaultValue);
    }

    public K getKey(V value) {
        return (K)this.registry.inverse().get(value);
    }

    public K getOrDefaultKey(V key, K defaultKey) {
        return (K)this.registry.inverse().getOrDefault(key, defaultKey);
    }

    public abstract void writeBuf(V var1, class_2540 var2);

    @Nullable
    public abstract V readBuf(class_2540 var1);

    public abstract class_2520 saveToNBT(V var1);

    @Nullable
    public abstract V loadFromNBT(class_2520 var1);

    public boolean remove(K name) {
        return this.registry.remove(name) != null;
    }

    public abstract Codec<V> codec();

    public class_2960 getRegistryName() {
        return this.registryName;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public static class RL<V>
    extends GTRegistry<class_2960, V> {
        public RL(class_2960 registryName) {
            super(registryName);
        }

        @Override
        public void writeBuf(V value, class_2540 buf) {
            buf.writeBoolean(this.containValue(value));
            if (this.containValue(value)) {
                buf.method_10814(((class_2960)this.getKey(value)).toString());
            }
        }

        @Override
        public V readBuf(class_2540 buf) {
            if (buf.readBoolean()) {
                return this.get(new class_2960(buf.method_19772()));
            }
            return null;
        }

        @Override
        public class_2520 saveToNBT(V value) {
            if (this.containValue(value)) {
                return class_2519.method_23256((java.lang.String)((class_2960)this.getKey(value)).toString());
            }
            return new class_2487();
        }

        @Override
        public V loadFromNBT(class_2520 tag) {
            return this.get(new class_2960(tag.method_10714()));
        }

        @Override
        public Codec<V> codec() {
            return class_2960.field_25139.flatXmap(rl -> Optional.ofNullable(this.get(rl)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + this.registryName + ": " + rl)), obj -> Optional.ofNullable((class_2960)this.getKey(obj)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry element in " + this.registryName + ": " + obj)));
        }
    }

    public static class String<V>
    extends GTRegistry<java.lang.String, V> {
        public String(class_2960 registryName) {
            super(registryName);
        }

        @Override
        public void writeBuf(V value, class_2540 buf) {
            buf.writeBoolean(this.containValue(value));
            if (this.containValue(value)) {
                buf.method_10814((java.lang.String)this.getKey(value));
            }
        }

        @Override
        public V readBuf(class_2540 buf) {
            if (buf.readBoolean()) {
                return this.get(buf.method_19772());
            }
            return null;
        }

        @Override
        public class_2520 saveToNBT(V value) {
            if (this.containValue(value)) {
                return class_2519.method_23256((java.lang.String)((java.lang.String)this.getKey(value)));
            }
            return new class_2487();
        }

        @Override
        public V loadFromNBT(class_2520 tag) {
            return this.get(tag.method_10714());
        }

        @Override
        public Codec<V> codec() {
            return Codec.STRING.flatXmap(str -> Optional.ofNullable(this.get(str)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + this.registryName + ": " + str)), obj -> Optional.ofNullable((java.lang.String)this.getKey(obj)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry element in " + this.registryName + ": " + obj)));
        }
    }
}

