/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.utils.GTUtil;
import it.unimi.dsi.fastutil.longs.LongIntMutablePair;
import it.unimi.dsi.fastutil.longs.LongIntPair;
import javax.annotation.Nonnull;

public class RecipeHelper {
    public static long getInputEUt(GTRecipe recipe) {
        return recipe.getTickInputContents(EURecipeCapability.CAP).stream().map(Content::getContent).mapToLong(EURecipeCapability.CAP::of).sum();
    }

    public static long getOutputEUt(GTRecipe recipe) {
        return recipe.getTickOutputContents(EURecipeCapability.CAP).stream().map(Content::getContent).mapToLong(EURecipeCapability.CAP::of).sum();
    }

    public static void setInputEUt(GTRecipe recipe, long eut) {
        recipe.getTickInputContents(EURecipeCapability.CAP).forEach(c -> {
            c.content = eut;
        });
    }

    public static void setOutputEUt(GTRecipe recipe, long eut) {
        recipe.getTickOutputContents(EURecipeCapability.CAP).forEach(c -> {
            c.content = eut;
        });
    }

    public static int getRecipeEUtTier(GTRecipe recipe) {
        long EUt = RecipeHelper.getInputEUt(recipe);
        if (EUt == 0L) {
            EUt = RecipeHelper.getOutputEUt(recipe);
        }
        return GTUtil.getTierByVoltage(EUt);
    }

    public static GTRecipe applyOverclock(OverclockingLogic logic, @Nonnull GTRecipe recipe, long maxOverclockVoltage) {
        LongIntPair overclockResult;
        long EUt = RecipeHelper.getInputEUt(recipe);
        if (EUt > 0L && ((overclockResult = RecipeHelper.performOverclocking(logic, recipe, EUt, maxOverclockVoltage)).leftLong() != EUt || recipe.duration != overclockResult.rightInt())) {
            recipe = recipe.copy();
            recipe.duration = overclockResult.rightInt();
            for (Content content : recipe.getTickInputContents(EURecipeCapability.CAP)) {
                content.content = overclockResult.leftLong();
            }
        }
        if ((EUt = RecipeHelper.getOutputEUt(recipe)) > 0L && ((overclockResult = RecipeHelper.performOverclocking(logic, recipe, EUt, maxOverclockVoltage)).leftLong() != EUt || recipe.duration != overclockResult.rightInt())) {
            recipe = recipe.copy();
            recipe.duration = overclockResult.rightInt();
            for (Content content : recipe.getTickOutputContents(EURecipeCapability.CAP)) {
                content.content = overclockResult.leftLong();
            }
        }
        return recipe;
    }

    private static LongIntPair performOverclocking(OverclockingLogic logic, @Nonnull GTRecipe recipe, long EUt, long maxOverclockVoltage) {
        byte recipeTier = GTUtil.getTierByVoltage(EUt);
        int maximumTier = logic.getOverclockForTier(maxOverclockVoltage);
        int numberOfOCs = maximumTier - recipeTier;
        if (recipeTier == 0) {
            --numberOfOCs;
        }
        if (numberOfOCs <= 0) {
            return LongIntMutablePair.of((long)EUt, (int)recipe.duration);
        }
        return logic.getLogic().runOverclockingLogic(recipe, EUt, maxOverclockVoltage, recipe.duration, numberOfOCs);
    }
}

