/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.SteamTexture;
import com.gregtechceu.gtceu.api.gui.WidgetUtils;
import com.gregtechceu.gtceu.api.gui.editor.IEditableUI;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeSerializer;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import com.gregtechceu.gtceu.core.mixins.RecipeManagerInvoker;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.integration.emi.recipe.GTRecipeTypeEmiCategory;
import com.gregtechceu.gtceu.integration.jei.recipe.GTRecipeTypeCategory;
import com.gregtechceu.gtceu.integration.rei.recipe.GTRecipeTypeDisplayCategory;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.OverlayingFluidStorage;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.jei.JEIPlugin;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Rect;
import com.lowdragmc.lowdraglib.utils.Size;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2444;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class GTRecipeType
implements class_3956<GTRecipe> {
    public final class_2960 registryName;
    public final String group;
    public final Object2IntMap<RecipeCapability<?>> maxInputs = new Object2IntOpenHashMap();
    public final Object2IntMap<RecipeCapability<?>> maxOutputs = new Object2IntOpenHashMap();
    private GTRecipeBuilder recipeBuilder;
    private ProgressTexture progressBarTexture = new ProgressTexture();
    private SteamTexture steamProgressBarTexture = null;
    private ProgressTexture.FillDirection steamMoveType = ProgressTexture.FillDirection.LEFT_TO_RIGHT;
    private IGuiTexture specialTexture;
    private Rect specialTexturePosition;
    private final Byte2ObjectMap<IGuiTexture> slotOverlays = new Byte2ObjectArrayMap();
    private GTRecipeType smallRecipeMap;
    @Nullable
    private Supplier<class_1799> iconSupplier;
    @Nullable
    protected SoundEntry sound;
    protected List<Function<class_2487, String>> dataInfos = new ArrayList<Function<class_2487, String>>();
    protected int maxTooltips = 3;
    @Nullable
    protected BiConsumer<GTRecipe, WidgetGroup> uiBuilder;
    protected boolean isFuelRecipeType;
    protected final Map<class_3956<?>, List<GTRecipe>> proxyRecipes;
    private class_2487 customUICache;

    public GTRecipeType(class_2960 registryName, String group, class_3956<?> ... proxyRecipes) {
        this.registryName = registryName;
        this.group = group;
        this.recipeBuilder = new GTRecipeBuilder(registryName, this);
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        for (class_3956<?> proxyRecipe : proxyRecipes) {
            map.put(proxyRecipe, new ArrayList());
        }
        this.proxyRecipes = map;
    }

    public GTRecipeType setMaxIOSize(int maxInputs, int maxOutputs, int maxFluidInputs, int maxFluidOutputs) {
        return this.setMaxSize(IO.IN, ItemRecipeCapability.CAP, maxInputs).setMaxSize(IO.IN, FluidRecipeCapability.CAP, maxFluidInputs).setMaxSize(IO.OUT, ItemRecipeCapability.CAP, maxOutputs).setMaxSize(IO.OUT, FluidRecipeCapability.CAP, maxFluidOutputs);
    }

    public GTRecipeType setEUIO(IO io) {
        if (io.support(IO.IN)) {
            this.setMaxSize(IO.IN, EURecipeCapability.CAP, 1);
        }
        if (io.support(IO.OUT)) {
            this.setMaxSize(IO.OUT, EURecipeCapability.CAP, 1);
        }
        return this;
    }

    public GTRecipeType setMaxSize(IO io, RecipeCapability<?> cap, int max) {
        if (io == IO.IN || io == IO.BOTH) {
            this.maxInputs.put(cap, max);
        }
        if (io == IO.OUT || io == IO.BOTH) {
            this.maxOutputs.put(cap, max);
        }
        return this;
    }

    @Deprecated
    public GTRecipeType setSpecialTexture(int x, int y, int width, int height, IGuiTexture area) {
        this.specialTexturePosition = Rect.of((Position)new Position(x, y), (Size)new Size(width, height));
        this.specialTexture = area;
        return this;
    }

    @Deprecated
    public GTRecipeType setSpecialTexture(Rect specialTexturePosition, IGuiTexture area) {
        this.specialTexturePosition = specialTexturePosition;
        this.specialTexture = area;
        return this;
    }

    public GTRecipeType setSlotOverlay(boolean isOutput, boolean isFluid, IGuiTexture slotOverlay) {
        return this.setSlotOverlay(isOutput, isFluid, false, slotOverlay).setSlotOverlay(isOutput, isFluid, true, slotOverlay);
    }

    public GTRecipeType setSlotOverlay(boolean isOutput, boolean isFluid, boolean isLast, IGuiTexture slotOverlay) {
        this.slotOverlays.put((byte)((isOutput ? 2 : 0) + (isFluid ? 1 : 0) + (isLast ? 4 : 0)), (Object)slotOverlay);
        return this;
    }

    public GTRecipeType setProgressBar(ResourceTexture progressBar, ProgressTexture.FillDirection moveType) {
        this.progressBarTexture = new ProgressTexture((IGuiTexture)progressBar.getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)progressBar.getSubTexture(0.0, 0.5, 1.0, 0.5)).setFillDirection(moveType);
        return this;
    }

    public GTRecipeType setSteamProgressBar(SteamTexture progressBar, ProgressTexture.FillDirection moveType) {
        this.steamProgressBarTexture = progressBar;
        this.steamMoveType = moveType;
        return this;
    }

    public GTRecipeType addDataInfo(Function<class_2487, String> dataInfo) {
        this.dataInfos.add(dataInfo);
        return this;
    }

    public String toString() {
        return this.registryName.toString();
    }

    @Nullable
    public GTRecipe getRecipe(class_1863 recipeManager, class_2960 id) {
        Map recipes = ((RecipeManagerInvoker)recipeManager).getRecipeFromType(this);
        class_1860 class_18602 = recipes.get(id);
        if (class_18602 instanceof GTRecipe) {
            GTRecipe recipe = (GTRecipe)class_18602;
            return recipe;
        }
        return null;
    }

    public List<GTRecipe> searchFuelRecipe(class_1863 recipeManager, IRecipeCapabilityHolder holder) {
        if (!holder.hasProxies() || !this.isFuelRecipeType()) {
            return Collections.emptyList();
        }
        ArrayList<GTRecipe> matches = new ArrayList<GTRecipe>();
        for (GTRecipe recipe : recipeManager.method_30027((class_3956)this)) {
            if (!recipe.isFuel || !recipe.matchRecipe(holder).isSuccess() || !recipe.matchTickRecipe(holder).isSuccess()) continue;
            matches.add(recipe);
        }
        return matches;
    }

    public List<GTRecipe> searchRecipe(class_1863 recipeManager, IRecipeCapabilityHolder holder) {
        if (!holder.hasProxies()) {
            return Collections.emptyList();
        }
        List<GTRecipe> matches = recipeManager.method_30027((class_3956)this).parallelStream().filter(recipe -> !recipe.isFuel && recipe.matchRecipe(holder).isSuccess() && recipe.matchTickRecipe(holder).isSuccess()).collect(Collectors.toList());
        for (List<GTRecipe> recipes : this.proxyRecipes.values()) {
            List<GTRecipe> found = recipes.parallelStream().filter(recipe -> !recipe.isFuel && recipe.matchRecipe(holder).isSuccess() && recipe.matchTickRecipe(holder).isSuccess()).toList();
            matches.addAll(found);
        }
        return matches;
    }

    public int getMaxInputs(RecipeCapability<?> cap) {
        return this.maxInputs.getOrDefault(cap, 0);
    }

    public int getMaxOutputs(RecipeCapability<?> cap) {
        return this.maxOutputs.getOrDefault(cap, 0);
    }

    public GTRecipeType prepareBuilder(Consumer<GTRecipeBuilder> onPrepare) {
        onPrepare.accept(this.recipeBuilder);
        return this;
    }

    public GTRecipeBuilder recipeBuilder(class_2960 id, Object ... append) {
        if (append.length > 0) {
            return this.recipeBuilder.copy(new class_2960(id.method_12836(), id.method_12832() + Arrays.stream(append).map(Object::toString).map(FormattingUtil::toLowerCaseUnder).reduce("", (a, b) -> a + "_" + b)));
        }
        return this.recipeBuilder.copy(id);
    }

    public GTRecipeBuilder recipeBuilder(String id, Object ... append) {
        return this.recipeBuilder(GTCEu.id(id), append);
    }

    public GTRecipeBuilder recipeBuilder(UnificationEntry entry, Object ... append) {
        return this.recipeBuilder(GTCEu.id(entry.tagPrefix + (String)(entry.material == null ? "" : "_" + entry.material)), append);
    }

    public GTRecipeBuilder recipeBuilder(Supplier<? extends class_1935> item, Object ... append) {
        return this.recipeBuilder(item.get(), append);
    }

    public GTRecipeBuilder recipeBuilder(class_1935 itemLike, Object ... append) {
        return this.recipeBuilder(new class_2960(itemLike.method_8389().method_7876()), append);
    }

    public GTRecipeBuilder copyFrom(GTRecipeBuilder builder) {
        return this.recipeBuilder.copyFrom(builder);
    }

    public GTRecipeType onRecipeBuild(BiConsumer<GTRecipeBuilder, Consumer<class_2444>> onBuild) {
        this.recipeBuilder.onSave(onBuild);
        return this;
    }

    public class_2487 getCustomUI() {
        if (this.customUICache == null) {
            class_3300 resourceManager = null;
            if (LDLib.isClient()) {
                resourceManager = class_310.method_1551().method_1478();
            } else if (Platform.getMinecraftServer() != null) {
                resourceManager = Platform.getMinecraftServer().method_34864();
            }
            if (resourceManager == null) {
                this.customUICache = new class_2487();
            } else {
                try {
                    class_3298 resource = resourceManager.getResourceOrThrow(new class_2960(this.registryName.method_12836(), "ui/recipe_type/%s.rtui".formatted(this.registryName.method_12832())));
                    try (InputStream inputStream = resource.method_14482();
                         DataInputStream dataInputStream = new DataInputStream(inputStream);){
                        this.customUICache = class_2507.method_10625((DataInput)dataInputStream, (class_2505)class_2505.field_11556);
                    }
                }
                catch (Exception e) {
                    this.customUICache = new class_2487();
                }
                if (this.customUICache == null) {
                    this.customUICache = new class_2487();
                }
            }
        }
        return this.customUICache;
    }

    public boolean hasCustomUI() {
        return !this.getCustomUI().method_33133();
    }

    public void reloadCustomUI() {
        this.customUICache = null;
    }

    public Size getJEISize() {
        return new Size(176, (this.dataInfos.size() + this.maxTooltips) * 10 + 5 + this.createEditableUITemplate((boolean)false, (boolean)false).createDefault().getSize().height);
    }

    public WidgetGroup createUITemplate(DoubleSupplier progressSupplier, IItemTransfer importItems, IItemTransfer exportItems, IFluidTransfer importFluids, IFluidTransfer exportFluids, boolean isSteam, boolean isHighPressure) {
        IEditableUI<WidgetGroup, RecipeHolder> template = this.createEditableUITemplate(isSteam, isHighPressure);
        WidgetGroup group = template.createDefault();
        template.setupUI(group, new RecipeHolder(progressSupplier, importItems, exportItems, importFluids, exportFluids, isSteam, isHighPressure));
        return group;
    }

    public WidgetGroup createUITemplate(DoubleSupplier progressSupplier, IItemTransfer importItems, IItemTransfer exportItems, IFluidTransfer importFluids, IFluidTransfer exportFluids) {
        return this.createUITemplate(progressSupplier, importItems, exportItems, importFluids, exportFluids, false, false);
    }

    public IEditableUI<WidgetGroup, RecipeHolder> createEditableUITemplate(boolean isSteam, boolean isHighPressure) {
        return new IEditableUI.Normal<WidgetGroup, RecipeHolder>(() -> {
            boolean isCustomUI;
            boolean bl = isCustomUI = !isSteam && this.hasCustomUI();
            if (isCustomUI) {
                class_2487 nbt = this.getCustomUI();
                WidgetGroup group = new WidgetGroup();
                IConfigurableWidget.deserializeNBT((IConfigurableWidget)group, (class_2487)nbt.method_10562("root"), (Resources)Resources.fromNBT((class_2487)nbt.method_10562("resources")), (boolean)false);
                group.setSelfPosition(new Position(0, 0));
                return group;
            }
            WidgetGroup inputs = this.addInventorySlotGroup(false, isSteam, isHighPressure);
            WidgetGroup outputs = this.addInventorySlotGroup(true, isSteam, isHighPressure);
            WidgetGroup group = new WidgetGroup(0, 0, inputs.getSize().width + outputs.getSize().width + 40, Math.max(inputs.getSize().height, outputs.getSize().height));
            Size size = group.getSize();
            inputs.addSelfPosition(0, (size.height - inputs.getSize().height) / 2);
            outputs.addSelfPosition(inputs.getSize().width + 40, (size.height - outputs.getSize().height) / 2);
            group.addWidget((Widget)inputs);
            group.addWidget((Widget)outputs);
            ProgressWidget progressWidget = new ProgressWidget(ProgressWidget.JEIProgress, inputs.getSize().width + 10, size.height / 2 - 10, 20, 20, this.progressBarTexture);
            progressWidget.setId("progress");
            group.addWidget((Widget)progressWidget);
            progressWidget.setProgressTexture((IGuiTexture)(isSteam && this.steamProgressBarTexture != null ? new ProgressTexture((IGuiTexture)this.steamProgressBarTexture.get(isHighPressure).getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)this.steamProgressBarTexture.get(isHighPressure).getSubTexture(0.0, 0.5, 1.0, 0.5)).setFillDirection(this.steamMoveType) : this.progressBarTexture));
            if (this.specialTexture != null && this.specialTexturePosition != null) {
                this.addSpecialTexture(group);
            }
            return group;
        }, (template, recipeHolder) -> {
            boolean isJEI = recipeHolder.progressSupplier == ProgressWidget.JEIProgress;
            ArrayList progress = new ArrayList();
            WidgetUtils.widgetByIdForEach(template, "^progress$", ProgressWidget.class, progressWidget -> {
                progressWidget.setProgressSupplier(recipeHolder.progressSupplier);
                progress.add(progressWidget);
            });
            if (!isJEI && (LDLib.isReiLoaded() || LDLib.isJeiLoaded() || LDLib.isEmiLoaded())) {
                for (Widget widget : progress) {
                    template.addWidget(new ButtonWidget(widget.getPosition().x, widget.getPosition().y, widget.getSize().width, widget.getSize().height, IGuiTexture.EMPTY, cd -> {
                        if (cd.isRemote) {
                            if (LDLib.isReiLoaded()) {
                                ViewSearchBuilder.builder().addCategory(GTRecipeTypeDisplayCategory.CATEGORIES.apply(this)).open();
                            } else if (LDLib.isJeiLoaded()) {
                                JEIPlugin.jeiRuntime.getRecipesGui().showTypes(List.of(GTRecipeTypeCategory.TYPES.apply(this)));
                            } else if (LDLib.isEmiLoaded()) {
                                EmiApi.displayRecipeCategory((EmiRecipeCategory)((EmiRecipeCategory)GTRecipeTypeEmiCategory.CATEGORIES.apply(this)));
                            }
                        }
                    }).setHoverTooltips(new String[]{"gtceu.recipe_type.show_recipes"}));
                }
            }
            WidgetUtils.widgetByIdForEach(template, "^%s_[0-9]+$".formatted(ItemRecipeCapability.CAP.slotName(IO.IN)), SlotWidget.class, slot -> {
                int index = WidgetUtils.widgetIdIndex((Widget)slot);
                if (index >= 0 && index < recipeHolder.importItems.getSlots()) {
                    slot.setHandlerSlot(recipeHolder.importItems, index);
                    slot.setIngredientIO(IngredientIO.INPUT);
                    slot.setCanTakeItems(!isJEI);
                    slot.setCanPutItems(!isJEI);
                }
            });
            WidgetUtils.widgetByIdForEach(template, "^%s_[0-9]+$".formatted(ItemRecipeCapability.CAP.slotName(IO.OUT)), SlotWidget.class, slot -> {
                int index = WidgetUtils.widgetIdIndex((Widget)slot);
                if (index >= 0 && index < recipeHolder.exportItems.getSlots()) {
                    slot.setHandlerSlot(recipeHolder.exportItems, index);
                    slot.setIngredientIO(IngredientIO.OUTPUT);
                    slot.setCanTakeItems(!isJEI);
                    slot.setCanPutItems(false);
                }
            });
            WidgetUtils.widgetByIdForEach(template, "^%s_[0-9]+$".formatted(FluidRecipeCapability.CAP.slotName(IO.IN)), TankWidget.class, tank -> {
                int index = WidgetUtils.widgetIdIndex((Widget)tank);
                if (index >= 0 && index < recipeHolder.importFluids.getTanks()) {
                    tank.setFluidTank((IFluidStorage)new OverlayingFluidStorage(recipeHolder.importFluids, index));
                    tank.setIngredientIO(IngredientIO.INPUT);
                    tank.setAllowClickFilled(!isJEI);
                    tank.setAllowClickDrained(!isJEI);
                }
            });
            WidgetUtils.widgetByIdForEach(template, "^%s_[0-9]+$".formatted(FluidRecipeCapability.CAP.slotName(IO.OUT)), TankWidget.class, tank -> {
                int index = WidgetUtils.widgetIdIndex((Widget)tank);
                if (index >= 0 && index < recipeHolder.exportFluids.getTanks()) {
                    tank.setFluidTank((IFluidStorage)new OverlayingFluidStorage(recipeHolder.exportFluids, index));
                    tank.setIngredientIO(IngredientIO.OUTPUT);
                    tank.setAllowClickFilled(!isJEI);
                    tank.setAllowClickDrained(false);
                }
            });
        });
    }

    protected void addSpecialTexture(WidgetGroup group) {
        group.addWidget((Widget)new ImageWidget(this.specialTexturePosition.left, this.specialTexturePosition.up, this.specialTexturePosition.getWidth(), this.specialTexturePosition.getHeight(), this.specialTexture));
    }

    protected WidgetGroup addInventorySlotGroup(boolean isOutputs, boolean isSteam, boolean isHighPressure) {
        int itemCount = isOutputs ? this.getMaxOutputs(ItemRecipeCapability.CAP) : this.getMaxInputs(ItemRecipeCapability.CAP);
        int fluidCount = isOutputs ? this.getMaxOutputs(FluidRecipeCapability.CAP) : this.getMaxInputs(FluidRecipeCapability.CAP);
        int sum = itemCount + fluidCount;
        WidgetGroup group = new WidgetGroup(0, 0, Math.min(sum, 3) * 18 + 8, (sum + 2) / 3 * 18 + 8);
        int index = 0;
        for (int slotIndex = 0; slotIndex < itemCount; ++slotIndex) {
            SlotWidget slot = new SlotWidget();
            slot.initTemplate();
            slot.setSelfPosition(new Position(index % 3 * 18 + 4, index / 3 * 18 + 4));
            slot.setBackground(new IGuiTexture[]{this.getOverlaysForSlot(isOutputs, false, slotIndex == itemCount - 1, isSteam, isHighPressure)});
            slot.setId(ItemRecipeCapability.CAP.slotName(isOutputs ? IO.OUT : IO.IN, slotIndex));
            group.addWidget((Widget)slot);
            ++index;
        }
        for (int i = 0; i < fluidCount; ++i) {
            TankWidget tank = new TankWidget();
            tank.initTemplate();
            tank.setFillDirection(ProgressTexture.FillDirection.ALWAYS_FULL);
            tank.setSelfPosition(new Position(index % 3 * 18 + 4, index / 3 * 18 + 4));
            tank.setBackground(this.getOverlaysForSlot(isOutputs, true, i == fluidCount - 1, isSteam, isHighPressure));
            tank.setId(FluidRecipeCapability.CAP.slotName(isOutputs ? IO.OUT : IO.IN, i));
            group.addWidget((Widget)tank);
            ++index;
        }
        return group;
    }

    protected static int[] determineSlotsGrid(int itemInputsCount) {
        int itemSlotsToLeft;
        int itemSlotsToDown;
        double sqrt = Math.sqrt(itemInputsCount);
        if (sqrt % 1.0 == 0.0) {
            itemSlotsToLeft = itemSlotsToDown = (int)sqrt;
        } else if (itemInputsCount == 3) {
            itemSlotsToLeft = 3;
            itemSlotsToDown = 1;
        } else {
            itemSlotsToLeft = (int)Math.ceil(sqrt);
            if (itemInputsCount > itemSlotsToLeft * (itemSlotsToDown = itemSlotsToLeft - 1)) {
                itemSlotsToDown = itemSlotsToLeft;
            }
        }
        return new int[]{itemSlotsToLeft, itemSlotsToDown};
    }

    protected IGuiTexture getOverlaysForSlot(boolean isOutput, boolean isFluid, boolean isLast, boolean isSteam, boolean isHighPressure) {
        ResourceBorderTexture base = isFluid ? GuiTextures.FLUID_SLOT : (isSteam ? GuiTextures.SLOT_STEAM.get(isHighPressure) : GuiTextures.SLOT);
        byte overlayKey = (byte)((isOutput ? 2 : 0) + (isFluid ? 1 : 0) + (isLast ? 4 : 0));
        if (this.slotOverlays.containsKey(overlayKey)) {
            return new GuiTextureGroup(new IGuiTexture[]{base, (IGuiTexture)this.slotOverlays.get(overlayKey)});
        }
        return base;
    }

    public void appendJEIUI(GTRecipe recipe, WidgetGroup widgetGroup) {
        if (this.uiBuilder != null) {
            this.uiBuilder.accept(recipe, widgetGroup);
        }
    }

    public GTRecipe toGTrecipe(class_2960 id, class_1860<?> recipe) {
        GTRecipeBuilder builder = this.recipeBuilder(id, new Object[0]);
        for (class_1856 ingredient : recipe.method_8117()) {
            builder.inputItems(ingredient);
        }
        builder.outputItems(recipe.method_8110((class_5455)class_5455.method_40302((class_2378)class_7923.field_41167)));
        if (recipe instanceof class_3861) {
            class_3861 smeltingRecipe = (class_3861)recipe;
            builder.duration(smeltingRecipe.method_8167());
        }
        return GTRecipeSerializer.SERIALIZER.fromJson(id, builder.build().method_17799());
    }

    public GTRecipeType setRecipeBuilder(GTRecipeBuilder recipeBuilder) {
        this.recipeBuilder = recipeBuilder;
        return this;
    }

    public GTRecipeType setProgressBarTexture(ProgressTexture progressBarTexture) {
        this.progressBarTexture = progressBarTexture;
        return this;
    }

    public GTRecipeType setSteamProgressBarTexture(SteamTexture steamProgressBarTexture) {
        this.steamProgressBarTexture = steamProgressBarTexture;
        return this;
    }

    public GTRecipeType setSteamMoveType(ProgressTexture.FillDirection steamMoveType) {
        this.steamMoveType = steamMoveType;
        return this;
    }

    public Byte2ObjectMap<IGuiTexture> getSlotOverlays() {
        return this.slotOverlays;
    }

    public GTRecipeType setSmallRecipeMap(GTRecipeType smallRecipeMap) {
        this.smallRecipeMap = smallRecipeMap;
        return this;
    }

    public GTRecipeType getSmallRecipeMap() {
        return this.smallRecipeMap;
    }

    public GTRecipeType setIconSupplier(@Nullable Supplier<class_1799> iconSupplier) {
        this.iconSupplier = iconSupplier;
        return this;
    }

    @Nullable
    public Supplier<class_1799> getIconSupplier() {
        return this.iconSupplier;
    }

    public GTRecipeType setSound(@Nullable SoundEntry sound) {
        this.sound = sound;
        return this;
    }

    @Nullable
    public SoundEntry getSound() {
        return this.sound;
    }

    public List<Function<class_2487, String>> getDataInfos() {
        return this.dataInfos;
    }

    public GTRecipeType setMaxTooltips(int maxTooltips) {
        this.maxTooltips = maxTooltips;
        return this;
    }

    public int getMaxTooltips() {
        return this.maxTooltips;
    }

    public GTRecipeType setUiBuilder(@Nullable BiConsumer<GTRecipe, WidgetGroup> uiBuilder) {
        this.uiBuilder = uiBuilder;
        return this;
    }

    public GTRecipeType setFuelRecipeType(boolean isFuelRecipeType) {
        this.isFuelRecipeType = isFuelRecipeType;
        return this;
    }

    public boolean isFuelRecipeType() {
        return this.isFuelRecipeType;
    }

    public Map<class_3956<?>, List<GTRecipe>> getProxyRecipes() {
        return this.proxyRecipes;
    }

    public record RecipeHolder(DoubleSupplier progressSupplier, IItemTransfer importItems, IItemTransfer exportItems, IFluidTransfer importFluids, IFluidTransfer exportFluids, boolean isSteam, boolean isHighPressure) {
    }
}

