/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pipenet;

import com.gregtechceu.gtceu.api.pipenet.ITickablePipeNet;
import com.lowdragmc.lowdraglib.pipelike.LevelPipeNet;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import org.apache.commons.lang3.tuple.Pair;

public abstract class TickableLevelPipeNet<NodeDataType, T extends PipeNet<NodeDataType>>
extends LevelPipeNet<NodeDataType, T> {
    private final Map<T, List<class_1923>> loadedChunksByPipeNet = new HashMap<T, List<class_1923>>();
    private final Set<T> tickingPipeNets = new HashSet<T>();
    private final Set<T> removeLater = new HashSet<T>();

    public TickableLevelPipeNet(class_3218 serverLevel) {
        super(serverLevel);
    }

    public TickableLevelPipeNet(class_3218 serverLevel, class_2487 tag) {
        super(serverLevel, tag);
    }

    private boolean isChunkLoaded(class_1923 chunkPos) {
        class_3218 worldServer = this.getWorld();
        if (worldServer == null) {
            return false;
        }
        return worldServer.method_14178().method_12123(chunkPos.field_9181, chunkPos.field_9180);
    }

    protected abstract int getUpdateRate();

    public void update() {
        if (this.getWorld().method_8510() % (long)this.getUpdateRate() == 0L) {
            this.tickingPipeNets.forEach(rec$ -> ((ITickablePipeNet)rec$).update());
        }
        if (this.removeLater.size() > 0) {
            this.removeLater.forEach(x$0 -> this.tickingPipeNets.remove(x$0));
            this.removeLater.clear();
        }
    }

    public void onChunkLoaded(class_2791 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        List pipeNetsInThisChunk = (List)this.pipeNetsByChunk.get(chunkPos);
        if (pipeNetsInThisChunk == null) {
            return;
        }
        for (PipeNet pipeNet : pipeNetsInThisChunk) {
            List<class_1923> loadedChunks = this.getOrCreateChunkListForPipeNet(pipeNet);
            if (loadedChunks.isEmpty()) {
                this.tickingPipeNets.add(pipeNet);
            }
            loadedChunks.add(chunkPos);
        }
    }

    public void onChunkUnloaded(class_2791 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        List pipeNetsInThisChunk = (List)this.pipeNetsByChunk.get(chunkPos);
        if (pipeNetsInThisChunk == null) {
            return;
        }
        for (PipeNet pipeNet : pipeNetsInThisChunk) {
            List<class_1923> loadedChunks = this.loadedChunksByPipeNet.get(pipeNet);
            if (loadedChunks == null || !loadedChunks.contains(chunkPos)) continue;
            loadedChunks.remove(chunkPos);
            if (!loadedChunks.isEmpty()) continue;
            this.removeFromTicking(pipeNet);
        }
    }

    protected void init() {
        super.init();
        Map<PipeNet, List> pipeNetByLoadedChunks = this.pipeNets.stream().map(pipeNet -> Pair.of((Object)pipeNet, this.getPipeNetLoadedChunks(pipeNet))).filter(pair -> !((List)pair.getRight()).isEmpty()).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        if (!pipeNetByLoadedChunks.isEmpty()) {
            this.tickingPipeNets.addAll(pipeNetByLoadedChunks.keySet());
            this.loadedChunksByPipeNet.putAll(pipeNetByLoadedChunks);
        }
    }

    protected void addPipeNet(T pipeNet) {
        super.addPipeNet(pipeNet);
        List<class_1923> loadedChunks = this.getPipeNetLoadedChunks(pipeNet);
        if (!loadedChunks.isEmpty()) {
            this.loadedChunksByPipeNet.put(pipeNet, loadedChunks);
            this.tickingPipeNets.add(pipeNet);
        }
    }

    private List<class_1923> getPipeNetLoadedChunks(T pipeNet) {
        return pipeNet.getContainedChunks().stream().filter(this::isChunkLoaded).collect(Collectors.toList());
    }

    protected void removePipeNet(T pipeNet) {
        super.removePipeNet(pipeNet);
        if (this.loadedChunksByPipeNet.containsKey(pipeNet)) {
            this.removeFromTicking(pipeNet);
        }
    }

    private void removeFromTicking(T pipeNet) {
        this.loadedChunksByPipeNet.remove(pipeNet);
        this.removeLater.add(pipeNet);
    }

    private List<class_1923> getOrCreateChunkListForPipeNet(T pipeNet) {
        return this.loadedChunksByPipeNet.computeIfAbsent(pipeNet, k -> new ArrayList());
    }

    protected void addPipeNetToChunk(class_1923 chunkPos, T pipeNet) {
        super.addPipeNetToChunk(chunkPos, pipeNet);
        if (this.isChunkLoaded(chunkPos)) {
            List<class_1923> loadedChunks = this.getOrCreateChunkListForPipeNet(pipeNet);
            if (loadedChunks.isEmpty()) {
                this.tickingPipeNets.add(pipeNet);
            }
            loadedChunks.add(chunkPos);
        }
    }

    protected void removePipeNetFromChunk(class_1923 chunkPos, T pipeNet) {
        super.removePipeNetFromChunk(chunkPos, pipeNet);
        List<class_1923> loadedChunks = this.loadedChunksByPipeNet.get(pipeNet);
        if (loadedChunks != null && loadedChunks.contains(chunkPos)) {
            loadedChunks.remove(chunkPos);
            if (loadedChunks.isEmpty()) {
                this.removeFromTicking(pipeNet);
            }
        }
    }
}

