/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pipenet;

import com.gregtechceu.gtceu.api.block.PipeBlock;
import com.gregtechceu.gtceu.api.blockentity.IPaintable;
import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.pipenet.IAttachData;
import com.gregtechceu.gtceu.api.pipenet.IPipeType;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public interface IPipeNode<PipeType extends Enum<PipeType>, NodeDataType extends IAttachData>
extends ITickSubscription,
IPaintable {
    public long getOffsetTimer();

    public ICoverable getCoverContainer();

    public boolean isBlocked(class_2350 var1);

    public void setConnections(int var1);

    public int getConnections();

    public int getNumConnections();

    public void setBlocked(class_2350 var1, boolean var2);

    public boolean canAttachTo(class_2350 var1);

    public int getVisualConnections();

    default public boolean isConnected(class_2350 side) {
        return !this.isBlocked(side);
    }

    default public void updateConnections() {
        PipeNet<NodeDataType> net = this.getPipeNet();
        if (net != null) {
            class_2338 pos = this.getPipePos();
            net.onNeighbourUpdate(pos);
            NodeDataType data = this.getNodeData();
            boolean dataDirty = false;
            if (data == null) {
                LDLib.LOGGER.warn("data shouldn't be null here, did you add pipe without placement?");
                net.getWorldData().addNode(pos, ((IPipeType)this.getPipeType()).modifyProperties(this.getPipeBlock().getFallbackType()), 0, 0, true);
                data = this.getNodeData();
                if (data == null) {
                    throw new IllegalStateException("data shouldn't be null here!");
                }
            }
            for (class_2350 side : class_2350.values()) {
                boolean canAttach;
                if (this.isBlocked(side) || net.containsNode(pos.method_10093(side)) || !data.setAttached(side, canAttach = this.canAttachTo(side))) continue;
                dataDirty = true;
            }
            if (dataDirty) {
                net.updateNodeData(pos, data);
            }
        }
    }

    default public class_2586 self() {
        return (class_2586)this;
    }

    default public class_1937 getPipeLevel() {
        return this.self().method_10997();
    }

    default public class_2338 getPipePos() {
        return this.self().method_11016();
    }

    default public void markAsDirty() {
        this.self().method_5431();
    }

    default public boolean isInValid() {
        return this.self().method_11015();
    }

    default public boolean isRemote() {
        class_1937 level = this.getPipeLevel();
        if (level == null) {
            return LDLib.isRemote();
        }
        return level.field_9236;
    }

    default public PipeBlock<PipeType, NodeDataType, ?> getPipeBlock() {
        return (PipeBlock)this.self().method_11010().method_26204();
    }

    @Nullable
    default public PipeNet<NodeDataType> getPipeNet() {
        class_1937 class_19372 = this.getPipeLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            return this.getPipeBlock().getWorldPipeNet(serverLevel).getNetFromPos(this.getPipePos());
        }
        return null;
    }

    default public PipeType getPipeType() {
        return this.getPipeBlock().pipeType;
    }

    @Nullable
    default public NodeDataType getNodeData() {
        PipeNet<NodeDataType> net = this.getPipeNet();
        if (net != null) {
            return (NodeDataType)((IAttachData)net.getNodeAt((class_2338)this.getPipePos()).data);
        }
        return null;
    }

    default public void notifyBlockUpdate() {
        class_1937 level = this.getPipeLevel();
        if (level != null) {
            level.method_8452(this.getPipePos(), level.method_8320(this.getPipePos()).method_26204());
        }
    }

    default public void scheduleRenderUpdate() {
        class_2338 pos = this.getPipePos();
        class_1937 level = this.getPipeLevel();
        if (level != null) {
            class_2680 state = level.method_8320(pos);
            if (level.field_9236) {
                level.method_8413(pos, state, state, 8);
            } else {
                level.method_8427(pos, state.method_26204(), 1, 0);
            }
        }
    }

    default public void serverTick() {
    }

    default public void onNeighborChanged(class_2248 block, class_2338 fromPos, boolean isMoving) {
        if (!this.isRemote()) {
            this.updateConnections();
        }
        this.getCoverContainer().onNeighborChanged(block, fromPos, isMoving);
    }

    default public void scheduleNeighborShapeUpdate() {
        class_1937 level = this.getPipeLevel();
        class_2338 pos = this.getPipePos();
        if (level == null || pos == null) {
            return;
        }
        level.method_8320(pos).method_30101((class_1936)level, pos, 3);
    }

    @Override
    default public int getDefaultPaintingColor() {
        return 0xFFFFFF;
    }

    @Nullable
    public Material getFrameMaterial();
}

