/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pattern;

import com.gregtechceu.gtceu.api.block.ActiveBlock;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.error.PatternError;
import com.gregtechceu.gtceu.api.pattern.error.PatternStringError;
import com.gregtechceu.gtceu.api.pattern.error.SinglePredicateError;
import com.gregtechceu.gtceu.api.pattern.predicates.SimplePredicate;
import com.gregtechceu.gtceu.api.pattern.util.PatternMatchContext;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import org.apache.commons.lang3.ArrayUtils;

public class BlockPattern {
    static class_2350[] FACINGS = new class_2350[]{class_2350.field_11035, class_2350.field_11043, class_2350.field_11039, class_2350.field_11034, class_2350.field_11036, class_2350.field_11033};
    static class_2350[] FACINGS_H = new class_2350[]{class_2350.field_11035, class_2350.field_11043, class_2350.field_11039, class_2350.field_11034};
    public final int[][] aisleRepetitions;
    public final RelativeDirection[] structureDir;
    protected final TraceabilityPredicate[][][] blockMatches;
    protected final int fingerLength;
    protected final int thumbLength;
    protected final int palmLength;
    protected final int[] centerOffset;

    public BlockPattern(TraceabilityPredicate[][][] predicatesIn, RelativeDirection[] structureDir, int[][] aisleRepetitions, int[] centerOffset) {
        this.blockMatches = predicatesIn;
        this.fingerLength = predicatesIn.length;
        this.structureDir = structureDir;
        this.aisleRepetitions = aisleRepetitions;
        if (this.fingerLength > 0) {
            this.thumbLength = predicatesIn[0].length;
            this.palmLength = this.thumbLength > 0 ? predicatesIn[0][0].length : 0;
        } else {
            this.thumbLength = 0;
            this.palmLength = 0;
        }
        this.centerOffset = centerOffset;
    }

    public boolean checkPatternAt(MultiblockState worldState, boolean savePredicate) {
        class_2350[] facings;
        class_2350[] class_2350Array;
        IMultiController controller = worldState.getController();
        if (controller == null) {
            worldState.setError(new PatternStringError("no controller found"));
            return false;
        }
        class_2338 centerPos = controller.self().getPos();
        class_2350 frontFacing = controller.self().getFrontFacing();
        if (controller.hasFrontFacing()) {
            class_2350[] class_2350Array2 = new class_2350[1];
            class_2350Array = class_2350Array2;
            class_2350Array2[0] = frontFacing;
        } else {
            class_2350[] class_2350Array3 = new class_2350[4];
            class_2350Array3[0] = class_2350.field_11035;
            class_2350Array3[1] = class_2350.field_11043;
            class_2350Array3[2] = class_2350.field_11034;
            class_2350Array = class_2350Array3;
            class_2350Array3[3] = class_2350.field_11039;
        }
        for (class_2350 facing : facings = class_2350Array) {
            if (!this.checkPatternAt(worldState, centerPos, facing, savePredicate)) continue;
            return true;
        }
        return false;
    }

    public boolean checkPatternAt(MultiblockState worldState, class_2338 centerPos, class_2350 facing, boolean savePredicate) {
        boolean findFirstAisle = false;
        int minZ = -this.centerOffset[4];
        worldState.clean();
        PatternMatchContext matchContext = worldState.getMatchContext();
        Map<SimplePredicate, Integer> globalCount = worldState.getGlobalCount();
        Map<SimplePredicate, Integer> layerCount = worldState.getLayerCount();
        int z = minZ++;
        for (int c = 0; c < this.fingerLength; ++c) {
            int r = 0;
            while (findFirstAisle ? r < this.aisleRepetitions[c][1] : z <= -this.centerOffset[3]) {
                block19: {
                    layerCount.clear();
                    int b = 0;
                    int y = -this.centerOffset[1];
                    while (b < this.thumbLength) {
                        int a = 0;
                        int x = -this.centerOffset[0];
                        while (a < this.palmLength) {
                            IMachineBlockEntity machineBlockEntity;
                            worldState.setError(null);
                            TraceabilityPredicate predicate = this.blockMatches[c][b][a];
                            class_2338 pos = this.setActualRelativeOffset(x, y, z, facing).method_10069(centerPos.method_10263(), centerPos.method_10264(), centerPos.method_10260());
                            if (!worldState.update(pos, predicate)) {
                                return false;
                            }
                            if (predicate.addCache()) {
                                worldState.addPosCache(pos);
                                if (savePredicate) {
                                    matchContext.getOrCreate("predicates", HashMap::new).put(pos, predicate);
                                }
                            }
                            boolean canPartShared = true;
                            Object object = worldState.getTileEntity();
                            if (object instanceof IMachineBlockEntity && (object = (machineBlockEntity = (IMachineBlockEntity)object).getMetaMachine()) instanceof IMultiPart) {
                                IMultiPart part = (IMultiPart)object;
                                if (!predicate.isAny()) {
                                    if (part.isFormed() && !part.canShared() && !part.hasController(worldState.controllerPos)) {
                                        canPartShared = false;
                                        worldState.setError(new PatternStringError("multiblocked.pattern.error.share"));
                                    } else {
                                        matchContext.getOrCreate("parts", HashSet::new).add(part);
                                    }
                                }
                            }
                            if (worldState.getBlockState().method_26204() instanceof ActiveBlock) {
                                matchContext.getOrCreate("vaBlocks", LongOpenHashSet::new).add(worldState.getPos().method_10063());
                            }
                            if (!predicate.test(worldState) || !canPartShared) {
                                if (findFirstAisle) {
                                    if (r < this.aisleRepetitions[c][0]) {
                                        c = 0;
                                        r = 0;
                                        z = minZ++;
                                        matchContext.reset();
                                        findFirstAisle = false;
                                    }
                                } else {
                                    ++z;
                                }
                                break block19;
                            }
                            matchContext.getOrCreate("ioMap", Long2ObjectOpenHashMap::new).put(worldState.getPos().method_10063(), (Object)worldState.io);
                            ++a;
                            ++x;
                        }
                        ++b;
                        ++y;
                    }
                    findFirstAisle = true;
                    ++z;
                    for (Map.Entry<SimplePredicate, Integer> entry : layerCount.entrySet()) {
                        if (entry.getValue() >= entry.getKey().minLayerCount) continue;
                        worldState.setError(new SinglePredicateError(entry.getKey(), 3));
                        return false;
                    }
                }
                ++r;
            }
            if (r >= this.aisleRepetitions[c][0] && !worldState.hasError() && findFirstAisle) continue;
            if (!worldState.hasError()) {
                worldState.setError(new PatternError());
            }
            return false;
        }
        for (Map.Entry<SimplePredicate, Integer> entry : globalCount.entrySet()) {
            if (entry.getValue() >= entry.getKey().minCount) continue;
            worldState.setError(new SinglePredicateError(entry.getKey(), 1));
            return false;
        }
        worldState.setError(null);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void autoBuild(class_1657 player, MultiblockState worldState) {
        class_1937 world = player.method_37908();
        int minZ = -this.centerOffset[4];
        worldState.clean();
        IMultiController controller = worldState.getController();
        class_2338 centerPos = controller.self().getPos();
        class_2350 facing = controller.self().getFrontFacing();
        Map<SimplePredicate, Integer> cacheGlobal = worldState.getGlobalCount();
        Map<SimplePredicate, Integer> cacheLayer = worldState.getLayerCount();
        HashMap<class_2338, Object> blocks = new HashMap<class_2338, Object>();
        blocks.put(centerPos, controller);
        int z = minZ++;
        for (int c = 0; c < this.fingerLength; ++c) {
            for (int r = 0; r < this.aisleRepetitions[c][0]; ++r) {
                cacheLayer.clear();
                int b = 0;
                int y = -this.centerOffset[1];
                while (b < this.thumbLength) {
                    int a = 0;
                    int x = -this.centerOffset[0];
                    while (a < this.palmLength) {
                        TraceabilityPredicate predicate = this.blockMatches[c][b][a];
                        class_2338 pos2 = this.setActualRelativeOffset(x, y, z, facing).method_10069(centerPos.method_10263(), centerPos.method_10264(), centerPos.method_10260());
                        worldState.update(pos2, predicate);
                        if (!world.method_22347(pos2)) {
                            blocks.put(pos2, world.method_8320(pos2));
                            for (SimplePredicate limit : predicate.limited) {
                                limit.testLimited(worldState);
                            }
                        } else {
                            void var23_25;
                            boolean find = false;
                            Object[] infos = new BlockInfo[]{};
                            for (SimplePredicate simplePredicate : predicate.limited) {
                                if (simplePredicate.minLayerCount <= 0) continue;
                                if (!cacheLayer.containsKey(simplePredicate)) {
                                    cacheLayer.put(simplePredicate, 1);
                                } else {
                                    if (cacheLayer.get(simplePredicate) >= simplePredicate.minLayerCount || simplePredicate.maxLayerCount != -1 && cacheLayer.get(simplePredicate) >= simplePredicate.maxLayerCount) continue;
                                    cacheLayer.put(simplePredicate, cacheLayer.get(simplePredicate) + 1);
                                }
                                infos = simplePredicate.candidates == null ? null : simplePredicate.candidates.get();
                                find = true;
                                break;
                            }
                            if (!find) {
                                for (SimplePredicate simplePredicate : predicate.limited) {
                                    if (simplePredicate.minCount <= 0) continue;
                                    if (!cacheGlobal.containsKey(simplePredicate)) {
                                        cacheGlobal.put(simplePredicate, 1);
                                    } else {
                                        if (cacheGlobal.get(simplePredicate) >= simplePredicate.minCount || simplePredicate.maxCount != -1 && cacheGlobal.get(simplePredicate) >= simplePredicate.maxCount) continue;
                                        cacheGlobal.put(simplePredicate, cacheGlobal.get(simplePredicate) + 1);
                                    }
                                    infos = simplePredicate.candidates == null ? null : simplePredicate.candidates.get();
                                    find = true;
                                    break;
                                }
                            }
                            if (!find) {
                                for (SimplePredicate simplePredicate : predicate.limited) {
                                    if (simplePredicate.maxLayerCount != -1 && cacheLayer.getOrDefault(simplePredicate, Integer.MAX_VALUE) == simplePredicate.maxLayerCount || simplePredicate.maxCount != -1 && cacheGlobal.getOrDefault(simplePredicate, Integer.MAX_VALUE) == simplePredicate.maxCount) continue;
                                    if (cacheLayer.containsKey(simplePredicate)) {
                                        cacheLayer.put(simplePredicate, cacheLayer.get(simplePredicate) + 1);
                                    } else {
                                        cacheLayer.put(simplePredicate, 1);
                                    }
                                    if (cacheGlobal.containsKey(simplePredicate)) {
                                        cacheGlobal.put(simplePredicate, cacheGlobal.get(simplePredicate) + 1);
                                    } else {
                                        cacheGlobal.put(simplePredicate, 1);
                                    }
                                    infos = (BlockInfo[])ArrayUtils.addAll((Object[])infos, simplePredicate.candidates == null ? null : simplePredicate.candidates.get());
                                }
                                for (SimplePredicate simplePredicate : predicate.common) {
                                    infos = (BlockInfo[])ArrayUtils.addAll((Object[])infos, simplePredicate.candidates == null ? null : simplePredicate.candidates.get());
                                }
                            }
                            ArrayList<class_1799> candidates = new ArrayList<class_1799>();
                            if (infos != null) {
                                for (BlockInfo blockInfo : infos) {
                                    if (blockInfo.getBlockState().method_26204() == class_2246.field_10124) continue;
                                    candidates.add(blockInfo.getItemStackForm());
                                }
                            }
                            Object var23_36 = null;
                            if (!player.method_7337()) {
                                for (class_1799 itemStack : player.method_31548().field_7547) {
                                    if (!candidates.stream().anyMatch(candidate -> class_1799.method_31577((class_1799)candidate, (class_1799)itemStack)) || itemStack.method_7960() || !(itemStack.method_7909() instanceof class_1747)) continue;
                                    class_1799 class_17992 = itemStack.method_7972();
                                    itemStack.method_7939(itemStack.method_7947() - 1);
                                    break;
                                }
                            } else {
                                class_1799 candidate2;
                                class_1799 class_17993;
                                Iterator iterator = candidates.iterator();
                                while (iterator.hasNext() && ((class_17993 = (candidate2 = (class_1799)iterator.next()).method_7972()).method_7960() || !(class_17993.method_7909() instanceof class_1747))) {
                                    Object var23_41 = null;
                                }
                            }
                            if (var23_25 != null) {
                                class_1747 itemBlock = (class_1747)var23_25.method_7909();
                                class_1750 context = new class_1750(world, player, class_1268.field_5808, (class_1799)var23_25, class_3965.method_17778((class_243)player.method_5836(0.0f), (class_2350)class_2350.field_11036, (class_2338)pos2));
                                itemBlock.method_7712(context);
                                class_2586 class_25862 = world.method_8321(pos2);
                                if (class_25862 instanceof IMachineBlockEntity) {
                                    IMachineBlockEntity iMachineBlockEntity = (IMachineBlockEntity)class_25862;
                                    blocks.put(pos2, iMachineBlockEntity.getMetaMachine());
                                } else {
                                    blocks.put(pos2, world.method_8320(pos2));
                                }
                            }
                        }
                        ++a;
                        ++x;
                    }
                    ++b;
                    ++y;
                }
                ++z;
            }
        }
        class_2350 frontFacing = controller.self().getFrontFacing();
        blocks.forEach((pos, block) -> {
            if (!(block instanceof IMultiController)) {
                if (block instanceof class_2680) {
                    this.resetFacing((class_2338)pos, (class_2680)block, frontFacing, (p, f) -> {
                        Object object = blocks.get(p.method_10093(f));
                        return object == null || object instanceof class_2680 && ((class_2680)object).method_26204() == class_2246.field_10124;
                    }, state -> world.method_8652(pos, state, 3));
                } else if (block instanceof MetaMachine) {
                    MetaMachine machine = (MetaMachine)block;
                    this.resetFacing((class_2338)pos, machine.getBlockState(), frontFacing, (p, f) -> {
                        class_2680 blockState;
                        Object object = blocks.get(p.method_10093(f));
                        if (object == null || object instanceof class_2680 && (blockState = (class_2680)object).method_26215()) {
                            return machine.isFacingValid((class_2350)f);
                        }
                        return false;
                    }, state -> world.method_8652(pos, state, 3));
                }
            }
        });
    }

    public BlockInfo[][][] getPreview(int[] repetition) {
        HashMap<SimplePredicate, Integer> cacheGlobal = new HashMap<SimplePredicate, Integer>();
        HashMap<class_2338, BlockInfo> blocks = new HashMap<class_2338, BlockInfo>();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int x = 0;
        for (int l = 0; l < this.fingerLength; ++l) {
            for (int r = 0; r < repetition[l]; ++r) {
                HashMap<SimplePredicate, Integer> cacheLayer = new HashMap<SimplePredicate, Integer>();
                for (int y = 0; y < this.thumbLength; ++y) {
                    for (int z = 0; z < this.palmLength; ++z) {
                        TraceabilityPredicate predicate = this.blockMatches[l][y][z];
                        boolean find = false;
                        BlockInfo[] infos = null;
                        for (SimplePredicate limit : predicate.limited) {
                            if (limit.minLayerCount <= 0) continue;
                            if (!cacheLayer.containsKey(limit)) {
                                cacheLayer.put(limit, 1);
                            } else {
                                if ((Integer)cacheLayer.get(limit) >= limit.minLayerCount) continue;
                                cacheLayer.put(limit, (Integer)cacheLayer.get(limit) + 1);
                            }
                            if (cacheGlobal.getOrDefault(limit, 0) < limit.previewCount) {
                                if (!cacheGlobal.containsKey(limit)) {
                                    cacheGlobal.put(limit, 1);
                                } else {
                                    if ((Integer)cacheGlobal.get(limit) >= limit.previewCount) continue;
                                    cacheGlobal.put(limit, (Integer)cacheGlobal.get(limit) + 1);
                                }
                            }
                            infos = limit.candidates == null ? null : limit.candidates.get();
                            find = true;
                            break;
                        }
                        if (!find) {
                            for (SimplePredicate limit : predicate.limited) {
                                if (limit.minCount == -1 && limit.previewCount == -1) continue;
                                if (cacheGlobal.getOrDefault(limit, 0) < limit.previewCount) {
                                    if (!cacheGlobal.containsKey(limit)) {
                                        cacheGlobal.put(limit, 1);
                                    } else {
                                        if ((Integer)cacheGlobal.get(limit) >= limit.previewCount) continue;
                                        cacheGlobal.put(limit, (Integer)cacheGlobal.get(limit) + 1);
                                    }
                                } else {
                                    if (limit.minCount <= 0) continue;
                                    if (!cacheGlobal.containsKey(limit)) {
                                        cacheGlobal.put(limit, 1);
                                    } else {
                                        if ((Integer)cacheGlobal.get(limit) >= limit.minCount) continue;
                                        cacheGlobal.put(limit, (Integer)cacheGlobal.get(limit) + 1);
                                    }
                                }
                                infos = limit.candidates == null ? null : limit.candidates.get();
                                find = true;
                                break;
                            }
                        }
                        if (!find) {
                            for (SimplePredicate common : predicate.common) {
                                if (common.previewCount <= 0) continue;
                                if (!cacheGlobal.containsKey(common)) {
                                    cacheGlobal.put(common, 1);
                                } else {
                                    if ((Integer)cacheGlobal.get(common) >= common.previewCount) continue;
                                    cacheGlobal.put(common, (Integer)cacheGlobal.get(common) + 1);
                                }
                                infos = common.candidates == null ? null : common.candidates.get();
                                find = true;
                                break;
                            }
                        }
                        if (!find) {
                            for (SimplePredicate common : predicate.common) {
                                if (common.previewCount != -1) continue;
                                infos = common.candidates == null ? null : common.candidates.get();
                                find = true;
                                break;
                            }
                        }
                        if (!find) {
                            for (SimplePredicate limit : predicate.limited) {
                                if (limit.previewCount != -1) continue;
                                if (limit.maxCount != -1 || limit.maxLayerCount != -1) {
                                    if (cacheGlobal.getOrDefault(limit, 0) < limit.maxCount) {
                                        if (!cacheGlobal.containsKey(limit)) {
                                            cacheGlobal.put(limit, 1);
                                        } else {
                                            cacheGlobal.put(limit, (Integer)cacheGlobal.get(limit) + 1);
                                        }
                                    } else {
                                        if (cacheLayer.getOrDefault(limit, 0) >= limit.maxLayerCount) continue;
                                        if (!cacheLayer.containsKey(limit)) {
                                            cacheLayer.put(limit, 1);
                                        } else {
                                            cacheLayer.put(limit, (Integer)cacheLayer.get(limit) + 1);
                                        }
                                    }
                                }
                                infos = limit.candidates == null ? null : limit.candidates.get();
                                break;
                            }
                        }
                        BlockInfo info2 = infos == null || infos.length == 0 ? BlockInfo.EMPTY : infos[0];
                        class_2338 pos2 = this.setActualRelativeOffset(z, y, x, class_2350.field_11043);
                        blocks.put(pos2, info2);
                        minX = Math.min(pos2.method_10263(), minX);
                        minY = Math.min(pos2.method_10264(), minY);
                        minZ = Math.min(pos2.method_10260(), minZ);
                        maxX = Math.max(pos2.method_10263(), maxX);
                        maxY = Math.max(pos2.method_10264(), maxY);
                        maxZ = Math.max(pos2.method_10260(), maxZ);
                    }
                }
                ++x;
            }
        }
        BlockInfo[][][] result = (BlockInfo[][][])Array.newInstance(BlockInfo.class, maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
        int finalMinX = minX;
        int finalMinY = minY;
        int finalMinZ = minZ;
        blocks.forEach((pos, info) -> {
            this.resetFacing((class_2338)pos, info.getBlockState(), null, (p, f) -> {
                BlockInfo blockInfo = (BlockInfo)blocks.get(p.method_10093(f));
                if (blockInfo == null || blockInfo.getBlockState().method_26204() == class_2246.field_10124) {
                    MetaMachineBlock machineBlock;
                    class_2586 patt26516$temp;
                    class_2248 patt26367$temp = ((BlockInfo)blocks.get(pos)).getBlockState().method_26204();
                    if (patt26367$temp instanceof MetaMachineBlock && (patt26516$temp = (machineBlock = (MetaMachineBlock)patt26367$temp).method_10123(class_2338.field_10980, machineBlock.method_9564())) instanceof IMachineBlockEntity) {
                        IMachineBlockEntity machineBlockEntity = (IMachineBlockEntity)patt26516$temp;
                        MetaMachine machine = machineBlockEntity.getMetaMachine();
                        if (machine instanceof IMultiController) {
                            return false;
                        }
                        return machine.isFacingValid((class_2350)f);
                    }
                    return true;
                }
                return false;
            }, arg_0 -> ((BlockInfo)info).setBlockState(arg_0));
            result[pos.method_10263() - finalMinX][pos.method_10264() - finalMinY][pos.method_10260() - finalMinZ] = info;
        });
        return result;
    }

    private void resetFacing(class_2338 pos, class_2680 blockState, class_2350 facing, BiFunction<class_2338, class_2350, Boolean> checker, Consumer<class_2680> consumer) {
        if (blockState.method_28498((class_2769)class_2741.field_12525)) {
            this.tryFacings(blockState, pos, checker, consumer, (class_2769<class_2350>)class_2741.field_12525, facing == null ? FACINGS : (class_2350[])ArrayUtils.addAll((Object[])new class_2350[]{facing}, (Object[])FACINGS));
        } else if (blockState.method_28498((class_2769)class_2741.field_12481)) {
            this.tryFacings(blockState, pos, checker, consumer, (class_2769<class_2350>)class_2741.field_12481, facing == null || facing.method_10166() == class_2350.class_2351.field_11052 ? FACINGS_H : (class_2350[])ArrayUtils.addAll((Object[])new class_2350[]{facing}, (Object[])FACINGS_H));
        }
    }

    private void tryFacings(class_2680 blockState, class_2338 pos, BiFunction<class_2338, class_2350, Boolean> checker, Consumer<class_2680> consumer, class_2769<class_2350> property, class_2350[] facings) {
        class_2350 found = null;
        for (class_2350 facing : facings) {
            if (!checker.apply(pos, facing).booleanValue()) continue;
            found = facing;
            break;
        }
        if (found == null) {
            found = class_2350.field_11043;
        }
        consumer.accept((class_2680)blockState.method_11657(property, (Comparable)found));
    }

    private class_2338 setActualRelativeOffset(int x, int y, int z, class_2350 facing) {
        int[] c0 = new int[]{x, y, z};
        int[] c1 = new int[3];
        block8: for (int i = 0; i < 3; ++i) {
            switch (this.structureDir[i].getActualFacing(facing)) {
                case field_11036: {
                    c1[1] = c0[i];
                    continue block8;
                }
                case field_11033: {
                    c1[1] = -c0[i];
                    continue block8;
                }
                case field_11039: {
                    c1[0] = -c0[i];
                    continue block8;
                }
                case field_11034: {
                    c1[0] = c0[i];
                    continue block8;
                }
                case field_11043: {
                    c1[2] = -c0[i];
                    continue block8;
                }
                case field_11035: {
                    c1[2] = c0[i];
                }
            }
        }
        return new class_2338(c1[0], c1[1], c1[2]);
    }
}

