/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc.fabric;

import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;

public class FluidHandlerItemStack
implements SingleSlotStorage<FluidVariant> {
    public static final String FLUID_NBT_KEY = "Fluid";
    @NotNull
    protected ContainerItemContext container;
    protected long capacity;

    public FluidHandlerItemStack(@NotNull ContainerItemContext container, long capacity) {
        this.container = container;
        this.capacity = capacity;
    }

    @NotNull
    public FluidStack getFluid() {
        class_2487 tagCompound = this.container.getItemVariant().getNbt();
        return tagCompound != null && tagCompound.method_10545(FLUID_NBT_KEY) ? FluidStack.loadFromTag((class_2487)tagCompound.method_10562(FLUID_NBT_KEY)) : FluidStack.empty();
    }

    protected boolean setFluid(FluidStack fluid, TransactionContext tx) {
        class_1799 newStack = this.container.getItemVariant().toStack();
        class_2487 fluidTag = new class_2487();
        fluid.saveToTag(fluidTag);
        newStack.method_7948().method_10566(FLUID_NBT_KEY, (class_2520)fluidTag);
        return this.container.exchange(ItemVariant.of((class_1799)newStack), 1L, tx) == 1L;
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.container.getAmount() == 1L && !FluidStack.create((class_3611)resource.getFluid(), (long)maxAmount, (class_2487)resource.getNbt()).isEmpty() && this.canFillFluidType(resource, maxAmount)) {
            long fillAmount;
            FluidStack contained = this.getFluid();
            if (contained.isEmpty()) {
                long fillAmount2 = Math.min(this.capacity, maxAmount);
                FluidStack filled = FluidStack.create((class_3611)resource.getFluid(), (long)maxAmount, (class_2487)resource.getNbt());
                filled.setAmount(fillAmount2);
                if (this.setFluid(filled, transaction)) {
                    return fillAmount2;
                }
            } else if (contained.isFluidEqual(FluidStack.create((class_3611)resource.getFluid(), (long)maxAmount, (class_2487)resource.getNbt())) && (fillAmount = Math.min(this.capacity - contained.getAmount(), maxAmount)) > 0L) {
                contained.grow(fillAmount);
                if (this.setFluid(contained, transaction)) {
                    return fillAmount;
                }
            }
            return 0L;
        }
        return 0L;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.container.getAmount() == 1L && !FluidStack.create((class_3611)resource.getFluid(), (long)maxAmount, (class_2487)resource.getNbt()).isEmpty() && this.getFluid().isFluidEqual(FluidStack.create((class_3611)resource.getFluid(), (long)maxAmount, (class_2487)resource.getNbt())) && maxAmount > 0L) {
            FluidStack contained = this.getFluid();
            if (!contained.isEmpty() && this.canDrainFluidType(FluidVariant.of((class_3611)contained.getFluid(), (class_2487)contained.getTag()), contained.getAmount())) {
                long drainAmount = Math.min(contained.getAmount(), maxAmount);
                contained.shrink(drainAmount);
                if (contained.isEmpty() ? this.setContainerToEmpty(transaction) : this.setFluid(contained, transaction)) {
                    return drainAmount;
                }
                return 0L;
            }
            return 0L;
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    public FluidVariant getResource() {
        return FluidVariant.of((class_3611)this.getFluid().getFluid(), (class_2487)this.getFluid().getTag());
    }

    public long getAmount() {
        return this.getFluid().getAmount();
    }

    public long getCapacity() {
        return this.capacity;
    }

    public boolean canFillFluidType(FluidVariant variant, long amount) {
        return true;
    }

    public boolean canDrainFluidType(FluidVariant variant, long amount) {
        return true;
    }

    protected boolean setContainerToEmpty(TransactionContext tx) {
        class_1799 newStack = this.container.getItemVariant().toStack();
        newStack.method_7983(FLUID_NBT_KEY);
        return this.container.exchange(ItemVariant.of((class_1799)newStack), 1L, tx) == 1L;
    }

    public static class Consumable
    extends FluidHandlerItemStack {
        public Consumable(ContainerItemContext container, int capacity) {
            super(container, capacity);
        }

        @Override
        protected boolean setContainerToEmpty(TransactionContext tx) {
            boolean var4;
            block7: {
                boolean result;
                block6: {
                    result = super.setContainerToEmpty(tx);
                    try (Transaction nested = tx.openNested();){
                        if (this.container.extract(this.container.getItemVariant(), 1L, (TransactionContext)nested) != 1L) break block6;
                        nested.commit();
                        var4 = true;
                        break block7;
                    }
                }
                return result;
            }
            return var4;
        }
    }

    public static class SwapEmpty
    extends FluidHandlerItemStack {
        protected final class_1799 emptyContainer;

        public SwapEmpty(ContainerItemContext container, class_1799 emptyContainer, int capacity) {
            super(container, capacity);
            this.emptyContainer = emptyContainer;
        }

        @Override
        protected boolean setContainerToEmpty(TransactionContext tx) {
            boolean var4;
            block7: {
                boolean result;
                block6: {
                    result = super.setContainerToEmpty(tx);
                    try (Transaction nested = tx.openNested();){
                        if (this.container.exchange(ItemVariant.of((class_1799)this.emptyContainer), (long)this.emptyContainer.method_7947(), (TransactionContext)nested) != (long)this.emptyContainer.method_7947()) break block6;
                        nested.commit();
                        var4 = true;
                        break block7;
                    }
                }
                return result;
            }
            return var4;
        }
    }
}

