/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc;

import java.util.Arrays;
import java.util.function.LongSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_6328;

@class_6328
@ParametersAreNonnullByDefault
public class RateCounter {
    private final LongSupplier timeSupplier;
    private final long[] usedAmounts;
    private final long[] updateTimes;
    private final int countingTimeframe;

    public RateCounter(LongSupplier timeSupplier, int countingTimeframe) {
        this.timeSupplier = timeSupplier;
        this.countingTimeframe = countingTimeframe;
        this.usedAmounts = new long[countingTimeframe];
        this.updateTimes = new long[countingTimeframe];
    }

    public long getUsedSum() {
        long excludeUntilTime = this.timeSupplier.getAsLong() - (long)this.countingTimeframe;
        long sum = 0L;
        for (int i = 0; i < this.countingTimeframe; ++i) {
            if (this.updateTimes[i] <= excludeUntilTime) continue;
            sum += this.usedAmounts[i];
        }
        return sum;
    }

    public void addUsed(long amount) {
        long currentTime = this.timeSupplier.getAsLong();
        int idx = (int)(currentTime % (long)this.countingTimeframe);
        if (this.updateTimes[idx] != currentTime) {
            this.usedAmounts[idx] = 0L;
        }
        int n = idx;
        this.usedAmounts[n] = this.usedAmounts[n] + amount;
        this.updateTimes[idx] = currentTime;
    }

    public void clear() {
        Arrays.fill(this.usedAmounts, 0L);
    }

    public RateCounter copy() {
        RateCounter copied = new RateCounter(this.timeSupplier, this.countingTimeframe);
        System.arraycopy(this.usedAmounts, 0, copied.usedAmounts, 0, this.usedAmounts.length);
        System.arraycopy(this.updateTimes, 0, copied.updateTimes, 0, this.updateTimes.length);
        return copied;
    }
}

