/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.ICapabilityTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotifiableItemStackHandler
extends NotifiableRecipeHandlerTrait<class_1856>
implements ICapabilityTrait,
IItemTransfer {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(NotifiableItemStackHandler.class, NotifiableRecipeHandlerTrait.MANAGED_FIELD_HOLDER);
    public final IO handlerIO;
    public final IO capabilityIO;
    @Persisted
    @DescSynced
    public final ItemStackTransfer storage;
    private Boolean isEmpty;

    public NotifiableItemStackHandler(MetaMachine machine, int slots, IO handlerIO, IO capabilityIO, Function<Integer, ItemStackTransfer> transferFactory) {
        super(machine);
        this.handlerIO = handlerIO;
        this.storage = transferFactory.apply(slots);
        this.capabilityIO = capabilityIO;
        this.storage.setOnContentsChanged(this::onContentsChanged);
    }

    public NotifiableItemStackHandler(MetaMachine machine, int slots, IO handlerIO, IO capabilityIO) {
        this(machine, slots, handlerIO, capabilityIO, ItemStackTransfer::new);
    }

    public NotifiableItemStackHandler(MetaMachine machine, int slots, IO handlerIO) {
        this(machine, slots, handlerIO, handlerIO);
    }

    public NotifiableItemStackHandler setFilter(Function<class_1799, Boolean> filter) {
        this.storage.setFilter(filter);
        return this;
    }

    public void onContentsChanged() {
        this.isEmpty = null;
        this.notifyListeners();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public List<class_1856> handleRecipeInner(IO io, GTRecipe recipe, List<class_1856> left, @Nullable String slotName, boolean simulate) {
        return NotifiableItemStackHandler.handleIngredient(io, left, simulate, this.handlerIO, this.storage);
    }

    @Nullable
    public static List<class_1856> handleIngredient(IO io, List<class_1856> left, boolean simulate, IO handlerIO, ItemStackTransfer storage) {
        block9: {
            Iterator<class_1856> iterator;
            ItemStackTransfer capability;
            block8: {
                if (io != handlerIO) {
                    return left;
                }
                capability = simulate ? storage.copy() : storage;
                iterator = left.iterator();
                if (io != IO.IN) break block8;
                block0: while (iterator.hasNext()) {
                    class_1856 ingredient = iterator.next();
                    for (int i = 0; i < capability.getSlots(); ++i) {
                        class_1799[] ingredientStacks;
                        class_1799 itemStack = capability.getStackInSlot(i);
                        if (!ingredient.method_8093(itemStack)) continue;
                        for (class_1799 ingredientStack : ingredientStacks = ingredient.method_8105()) {
                            if (!ingredientStack.method_31574(itemStack.method_7909())) continue;
                            class_1799 extracted = capability.extractItem(i, ingredientStack.method_7947(), false);
                            ingredientStack.method_7939(ingredientStack.method_7947() - extracted.method_7947());
                            if (!ingredientStack.method_7960()) continue;
                            iterator.remove();
                            continue block0;
                        }
                    }
                }
                break block9;
            }
            if (io != IO.OUT) break block9;
            while (iterator.hasNext()) {
                class_1856 ingredient = iterator.next();
                class_1799[] items = ingredient.method_8105();
                if (items.length == 0) {
                    iterator.remove();
                    continue;
                }
                class_1799 output = items[0];
                if (!output.method_7960()) {
                    for (int i = 0; i < capability.getSlots(); ++i) {
                        class_1799 leftStack = capability.insertItem(i, output.method_7972(), false);
                        output.method_7939(leftStack.method_7947());
                        if (output.method_7960()) break;
                    }
                }
                if (!output.method_7960()) continue;
                iterator.remove();
            }
        }
        return left.isEmpty() ? null : left;
    }

    @Override
    public RecipeCapability<class_1856> getCapability() {
        return ItemRecipeCapability.CAP;
    }

    public int getSlots() {
        return this.storage.getSlots();
    }

    public boolean isEmpty() {
        if (this.isEmpty == null) {
            this.isEmpty = true;
            for (int i = 0; i < this.storage.getSlots(); ++i) {
                if (this.storage.getStackInSlot(i).method_7960()) continue;
                this.isEmpty = false;
                break;
            }
        }
        return this.isEmpty;
    }

    public void exportToNearby(class_2350 ... facings) {
        if (this.isEmpty()) {
            return;
        }
        class_1937 level = this.getMachine().getLevel();
        class_2338 pos = this.getMachine().getPos();
        for (class_2350 facing : facings) {
            ItemTransferHelper.exportToTarget((IItemTransfer)this, (int)Integer.MAX_VALUE, f -> true, (class_1937)level, (class_2338)pos.method_10093(facing), (class_2350)facing.method_10153());
        }
    }

    public void importFromNearby(class_2350 ... facings) {
        class_1937 level = this.getMachine().getLevel();
        class_2338 pos = this.getMachine().getPos();
        for (class_2350 facing : facings) {
            ItemTransferHelper.importToTarget((IItemTransfer)this, (int)Integer.MAX_VALUE, f -> true, (class_1937)level, (class_2338)pos.method_10093(facing), (class_2350)facing.method_10153());
        }
    }

    @NotNull
    public class_1799 getStackInSlot(int slot) {
        return this.storage.getStackInSlot(slot);
    }

    public void setStackInSlot(int index, class_1799 stack) {
        this.storage.setStackInSlot(index, stack);
    }

    @NotNull
    public class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate, boolean notifyChange) {
        if (this.canCapInput()) {
            return this.storage.insertItem(slot, stack, simulate, notifyChange);
        }
        return stack;
    }

    public class_1799 insertItemInternal(int slot, @NotNull class_1799 stack, boolean simulate) {
        return this.storage.insertItem(slot, stack, simulate);
    }

    @NotNull
    public class_1799 extractItem(int slot, int amount, boolean simulate, boolean notifyChange) {
        if (this.canCapOutput()) {
            return this.storage.extractItem(slot, amount, simulate, notifyChange);
        }
        return class_1799.field_8037;
    }

    public class_1799 extractItemInternal(int slot, int amount, boolean simulate) {
        return this.storage.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.storage.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        return this.storage.isItemValid(slot, stack);
    }

    @NotNull
    public Object createSnapshot() {
        return this.storage.createSnapshot();
    }

    public void restoreFromSnapshot(Object snapshot) {
        this.storage.restoreFromSnapshot(snapshot);
    }

    @Override
    public IO getHandlerIO() {
        return this.handlerIO;
    }

    @Override
    public IO getCapabilityIO() {
        return this.capabilityIO;
    }
}

