/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.multiblock.part;

import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.syncdata.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class MultiblockPartMachine
extends MetaMachine
implements IMultiPart {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MultiblockPartMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    @DescSynced
    @RequireRerender
    protected final Set<class_2338> controllerPositions = new HashSet<class_2338>();

    public MultiblockPartMachine(IMachineBlockEntity holder) {
        super(holder);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public boolean hasController(class_2338 controllerPos) {
        return this.controllerPositions.contains(controllerPos);
    }

    @Override
    public boolean isFormed() {
        return !this.controllerPositions.isEmpty();
    }

    @Override
    public List<IMultiController> getControllers() {
        ArrayList<IMultiController> result = new ArrayList<IMultiController>();
        for (class_2338 blockPos : this.controllerPositions) {
            MetaMachine metaMachine = MetaMachine.getMachine((class_1922)this.getLevel(), blockPos);
            if (!(metaMachine instanceof IMultiController)) continue;
            IMultiController controller = (IMultiController)((Object)metaMachine);
            result.add(controller);
        }
        return result;
    }

    @Override
    public List<IRecipeHandlerTrait> getRecipeHandlers() {
        return this.traits.stream().filter(IRecipeHandlerTrait.class::isInstance).map(IRecipeHandlerTrait.class::cast).toList();
    }

    @Override
    public void onUnload() {
        super.onUnload();
        class_1937 level = this.getLevel();
        for (class_2338 pos : this.controllerPositions) {
            MetaMachine metaMachine;
            if (!(level instanceof class_3218) || !level.method_8477(pos) || !((metaMachine = MetaMachine.getMachine((class_1922)level, pos)) instanceof IMultiController)) continue;
            IMultiController controller = (IMultiController)((Object)metaMachine);
            controller.onPartUnload();
        }
        this.controllerPositions.clear();
    }

    @Override
    public void removedFromController(IMultiController controller) {
        this.controllerPositions.remove(controller.self().getPos());
    }

    @Override
    public void addedToController(IMultiController controller) {
        this.controllerPositions.add(controller.self().getPos());
    }
}

