/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.feature;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.feature.IMachineFeature;
import com.gregtechceu.gtceu.common.data.GTDamageTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;

public interface IExhaustVentMachine
extends IMachineFeature {
    @NotNull
    public class_2350 getVentingDirection();

    public boolean needsVenting();

    public void setNeedsVenting(boolean var1);

    public void markVentingComplete();

    public float getVentingDamage();

    default public boolean checkVenting() {
        if (this.needsVenting()) {
            this.tryDoVenting(this.self().getLevel(), this.self().getPos());
        }
        return !this.needsVenting();
    }

    default public boolean isVentingBlocked() {
        class_1937 level = this.self().getLevel();
        class_2350 ventingSide = this.getVentingDirection();
        class_2338 ventingBlockPos = this.self().getPos().method_10093(ventingSide);
        class_2680 state = level.method_8320(ventingBlockPos);
        return state.method_26225() || class_259.method_1083((class_265)state.method_26220((class_1922)level, ventingBlockPos), (class_265)class_259.method_1077(), (class_2350)ventingSide.method_10153());
    }

    default public void tryDoVenting(@NotNull class_1937 level, @NotNull class_2338 pos) {
        if (this.needsVenting() && !this.isVentingBlocked()) {
            this.doVentingDamage(level, pos);
            class_2350 ventingDirection = this.getVentingDirection();
            double posX = (double)pos.method_10263() + 0.5 + (double)ventingDirection.method_10148() * 0.6;
            double posY = (double)pos.method_10264() + 0.5 + (double)ventingDirection.method_10164() * 0.6;
            double posZ = (double)pos.method_10260() + 0.5 + (double)ventingDirection.method_10165() * 0.6;
            this.createVentingParticles(level, posX, posY, posZ);
            if (ConfigHolder.INSTANCE.machines.machineSounds) {
                this.playVentingSound(level, posX, posY, posZ);
            }
            this.markVentingComplete();
        }
    }

    default public void doVentingDamage(@NotNull class_1937 level, @NotNull class_2338 pos) {
        for (class_1309 entity2 : level.method_8390(class_1309.class, new class_238(pos.method_10093(this.getVentingDirection())), entity -> {
            class_1657 player;
            return !(entity instanceof class_1657) || !(player = (class_1657)entity).method_7325() && !player.method_7337();
        })) {
            entity2.method_5643(GTDamageTypes.HEAT.source((class_1936)level), this.getVentingDamage());
        }
    }

    default public void createVentingParticles(@NotNull class_1937 level, double posX, double posY, double posZ) {
        class_2350 ventingDirection = this.getVentingDirection();
        int count = 7 + level.field_9229.method_43048(3);
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            serverLevel.method_14199((class_2394)class_2398.field_11204, posX, posY, posZ, count, (double)ventingDirection.method_10148() / 2.0, (double)ventingDirection.method_10164() / 2.0, (double)ventingDirection.method_10165() / 2.0, 0.1);
        } else {
            for (int i = 0; i < count; ++i) {
                double d1 = level.field_9229.method_43059() * (double)ventingDirection.method_10148() / 2.0;
                double d3 = level.field_9229.method_43059() * (double)ventingDirection.method_10164() / 2.0;
                double d5 = level.field_9229.method_43059() * (double)ventingDirection.method_10165() / 2.0;
                double d6 = level.field_9229.method_43059() * 0.1;
                double d7 = level.field_9229.method_43059() * 0.1;
                double d8 = level.field_9229.method_43059() * 0.1;
                try {
                    level.method_8406((class_2394)class_2398.field_11204, posX + d1, posY + d3, posZ + d5, d6, d7, d8);
                    continue;
                }
                catch (Throwable throwable) {
                    GTCEu.LOGGER.warn("Could not spawn particle effect {}", (Object)class_2398.field_11204);
                    return;
                }
            }
        }
    }

    default public void playVentingSound(@NotNull class_1937 level, double posX, double posY, double posZ) {
        level.method_43128(null, posX, posY, posZ, class_3417.field_19198, class_3419.field_15245, 1.0f, 1.0f);
    }
}

