/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.fancyconfigurator;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.widget.PredicatedButtonWidget;
import com.gregtechceu.gtceu.api.machine.feature.IOverclockMachine;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2540;
import net.minecraft.class_2561;

public class OverclockFancyConfigurator
implements IFancyConfigurator {
    protected IOverclockMachine overclockMachine;
    protected int currentTier;

    public OverclockFancyConfigurator(IOverclockMachine overclockMachine) {
        this.overclockMachine = overclockMachine;
    }

    @Override
    public String getTitle() {
        return "gtceu.gui.overclock.title";
    }

    @Override
    public IGuiTexture getIcon() {
        return this.currentTier <= 8 ? GuiTextures.TIER[this.currentTier].copy().scale(1.2f) : new TextTexture(GTValues.VNF[this.currentTier]).setDropShadow(false);
    }

    @Override
    public void writeInitialData(class_2540 buffer) {
        this.currentTier = this.overclockMachine.getOverclockTier();
        buffer.method_10804(this.currentTier);
    }

    @Override
    public void readInitialData(class_2540 buffer) {
        this.currentTier = buffer.method_10816();
    }

    @Override
    public void detectAndSendChange(BiConsumer<Integer, Consumer<class_2540>> sender) {
        int newTier = this.overclockMachine.getOverclockTier();
        if (newTier != this.currentTier) {
            this.currentTier = newTier;
            sender.accept(0, buf -> buf.method_10804(newTier));
        }
    }

    @Override
    public void readUpdateInfo(int id, class_2540 buf) {
        if (id == 0) {
            this.currentTier = buf.method_10816();
        }
    }

    @Override
    public Widget createConfigurator() {
        return new WidgetGroup(0, 0, 120, 40){
            final Map<Integer, WidgetGroup> lightGroups;
            {
                this.lightGroups = new HashMap<Integer, WidgetGroup>();
            }

            public void initWidget() {
                super.initWidget();
                this.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
                this.addWidget((Widget)new PredicatedButtonWidget(5, 5, 10, 20, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, Icons.LEFT.copy().scale(0.7f)}), cd -> {
                    if (!cd.isRemote) {
                        OverclockFancyConfigurator.this.overclockMachine.setOverclockTier(OverclockFancyConfigurator.this.currentTier - 1);
                    }
                }).setPredicate(() -> OverclockFancyConfigurator.this.currentTier > OverclockFancyConfigurator.this.overclockMachine.getMinOverclockTier()));
                this.addWidget((Widget)new ImageWidget(20, 5, 80, 20, () -> new GuiTextureGroup(new IGuiTexture[]{GuiTextures.DISPLAY_FRAME, new TextTexture(GTValues.VNF[OverclockFancyConfigurator.this.currentTier])})));
                this.addWidget((Widget)new PredicatedButtonWidget(105, 5, 10, 20, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, Icons.RIGHT.copy().scale(0.7f)}), cd -> {
                    if (!cd.isRemote) {
                        OverclockFancyConfigurator.this.overclockMachine.setOverclockTier(OverclockFancyConfigurator.this.currentTier + 1);
                    }
                }).setPredicate(() -> OverclockFancyConfigurator.this.currentTier < OverclockFancyConfigurator.this.overclockMachine.getMaxOverclockTier()));
            }

            public void writeInitialData(class_2540 buffer) {
                int min = OverclockFancyConfigurator.this.overclockMachine.getMinOverclockTier();
                int max = OverclockFancyConfigurator.this.overclockMachine.getMaxOverclockTier();
                buffer.method_10804(min);
                buffer.method_10804(max);
                buffer.method_10804(OverclockFancyConfigurator.this.currentTier);
                this.updateLightButton(min, max);
                super.writeInitialData(buffer);
            }

            public void readInitialData(class_2540 buffer) {
                int min = buffer.method_10816();
                int max = buffer.method_10816();
                OverclockFancyConfigurator.this.currentTier = buffer.method_10816();
                this.updateLightButton(min, max);
                super.readInitialData(buffer);
            }

            private void updateLightButton(int min, int max) {
                for (WidgetGroup light : this.lightGroups.values()) {
                    this.removeWidget((Widget)light);
                }
                this.lightGroups.clear();
                int x = 5;
                for (int tier = min; tier <= max; ++tier) {
                    int finalTier = tier;
                    WidgetGroup lightGroup = new WidgetGroup(x, 27, 8, 8);
                    lightGroup.addWidget((Widget)new ButtonWidget(0, 0, 8, 8, null, cd -> {
                        if (!cd.isRemote) {
                            OverclockFancyConfigurator.this.overclockMachine.setOverclockTier(finalTier);
                        }
                    }));
                    lightGroup.addWidget((Widget)new ImageWidget(0, 0, 8, 8, () -> OverclockFancyConfigurator.this.currentTier >= finalTier ? GuiTextures.LIGHT_ON : GuiTextures.LIGHT_OFF));
                    this.lightGroups.put(tier, lightGroup);
                    this.addWidget((Widget)lightGroup);
                    x += 10;
                }
            }

            public void detectAndSendChanges() {
                super.detectAndSendChanges();
                int min = OverclockFancyConfigurator.this.overclockMachine.getMinOverclockTier();
                int max = OverclockFancyConfigurator.this.overclockMachine.getMaxOverclockTier();
                if (this.lightGroups.size() != max - min + 1) {
                    this.updateLightButton(min, max);
                    this.writeUpdateInfo(0, buf -> {
                        buf.method_10804(min);
                        buf.method_10804(max);
                    });
                } else {
                    for (int i = min; i <= max; ++i) {
                        if (this.lightGroups.containsKey(i)) continue;
                        this.updateLightButton(min, max);
                        this.writeUpdateInfo(0, buf -> {
                            buf.method_10804(min);
                            buf.method_10804(max);
                        });
                        return;
                    }
                }
            }

            public void readUpdateInfo(int id, class_2540 buffer) {
                if (id == 0) {
                    int min = buffer.method_10816();
                    int max = buffer.method_10816();
                    this.updateLightButton(min, max);
                } else {
                    super.readUpdateInfo(id, buffer);
                }
            }
        };
    }

    @Override
    public List<class_2561> getTooltips() {
        return List.of(class_2561.method_43471((String)this.getTitle()), class_2561.method_43469((String)"gtceu.gui.overclock.range", (Object[])new Object[]{GTValues.VNF[this.overclockMachine.getMinOverclockTier()], GTValues.VNF[this.overclockMachine.getMaxOverclockTier()]}));
    }
}

