/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine;

import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.apache.commons.lang3.function.TriFunction;

public class MultiblockMachineDefinition
extends MachineDefinition {
    @NonNull
    private Supplier<BlockPattern> patternFactory;
    private Supplier<List<MultiblockShapeInfo>> shapes;
    @Nullable
    private Supplier<class_1799[]> recoveryItems;
    private Comparator<IMultiPart> partSorter;
    private TriFunction<IMultiController, IMultiPart, class_2350, class_2680> partAppearance;
    private BiConsumer<IMultiController, List<class_2561>> additionalDisplay;

    protected MultiblockMachineDefinition(class_2960 id) {
        super(id);
    }

    public static MultiblockMachineDefinition createDefinition(class_2960 id) {
        return new MultiblockMachineDefinition(id);
    }

    public List<MultiblockShapeInfo> getMatchingShapes() {
        List<MultiblockShapeInfo> designs = this.shapes.get();
        if (!designs.isEmpty()) {
            return designs;
        }
        BlockPattern structurePattern = this.patternFactory.get();
        int[][] aisleRepetitions = structurePattern.aisleRepetitions;
        return this.repetitionDFS(structurePattern, new ArrayList<MultiblockShapeInfo>(), aisleRepetitions, new Stack<Integer>());
    }

    private List<MultiblockShapeInfo> repetitionDFS(BlockPattern pattern, List<MultiblockShapeInfo> pages, int[][] aisleRepetitions, Stack<Integer> repetitionStack) {
        if (repetitionStack.size() == aisleRepetitions.length) {
            int[] repetition = new int[repetitionStack.size()];
            for (int i = 0; i < repetitionStack.size(); ++i) {
                repetition[i] = (Integer)repetitionStack.get(i);
            }
            pages.add(new MultiblockShapeInfo(pattern.getPreview(repetition)));
        } else {
            for (int i = aisleRepetitions[repetitionStack.size()][0]; i <= aisleRepetitions[repetitionStack.size()][1]; ++i) {
                repetitionStack.push(i);
                this.repetitionDFS(pattern, pages, aisleRepetitions, repetitionStack);
                repetitionStack.pop();
            }
        }
        return pages;
    }

    public void setPatternFactory(@NonNull Supplier<BlockPattern> patternFactory) {
        if (patternFactory == null) {
            throw new NullPointerException("patternFactory is marked non-null but is null");
        }
        this.patternFactory = patternFactory;
    }

    @NonNull
    public Supplier<BlockPattern> getPatternFactory() {
        return this.patternFactory;
    }

    public void setShapes(Supplier<List<MultiblockShapeInfo>> shapes) {
        this.shapes = shapes;
    }

    public Supplier<List<MultiblockShapeInfo>> getShapes() {
        return this.shapes;
    }

    public void setRecoveryItems(@Nullable Supplier<class_1799[]> recoveryItems) {
        this.recoveryItems = recoveryItems;
    }

    @Nullable
    public Supplier<class_1799[]> getRecoveryItems() {
        return this.recoveryItems;
    }

    public void setPartSorter(Comparator<IMultiPart> partSorter) {
        this.partSorter = partSorter;
    }

    public Comparator<IMultiPart> getPartSorter() {
        return this.partSorter;
    }

    public TriFunction<IMultiController, IMultiPart, class_2350, class_2680> getPartAppearance() {
        return this.partAppearance;
    }

    public void setPartAppearance(TriFunction<IMultiController, IMultiPart, class_2350, class_2680> partAppearance) {
        this.partAppearance = partAppearance;
    }

    public BiConsumer<IMultiController, List<class_2561>> getAdditionalDisplay() {
        return this.additionalDisplay;
    }

    public void setAdditionalDisplay(BiConsumer<IMultiController, List<class_2561>> additionalDisplay) {
        this.additionalDisplay = additionalDisplay;
    }
}

