/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine;

import com.gregtechceu.gtceu.api.block.BlockProperties;
import com.gregtechceu.gtceu.api.block.IAppearance;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.IPaintable;
import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.IToolable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.IToolGridHighLight;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineCoverContainer;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.gregtechceu.gtceu.api.machine.feature.IMufflableMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRedstoneSignalMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.misc.IOFluidTransferList;
import com.gregtechceu.gtceu.api.misc.IOItemTransferList;
import com.gregtechceu.gtceu.api.syncdata.EnhancedFieldManagedStorage;
import com.gregtechceu.gtceu.api.syncdata.IEnhancedManaged;
import com.gregtechceu.gtceu.api.syncdata.RequireRerender;
import com.gregtechceu.gtceu.common.cover.FluidFilterCover;
import com.gregtechceu.gtceu.common.cover.ItemFilterCover;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.IManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.DummyWorld;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3738;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import net.minecraft.class_6328;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@class_6328
public class MetaMachine
implements IEnhancedManaged,
IToolable,
ITickSubscription,
IAppearance,
IToolGridHighLight,
IFancyTooltip,
IPaintable,
IRedstoneSignalMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MetaMachine.class);
    private final EnhancedFieldManagedStorage syncStorage = new EnhancedFieldManagedStorage(this);
    public final IMachineBlockEntity holder;
    @DescSynced
    @Persisted(key="cover")
    protected final MachineCoverContainer coverContainer;
    @Persisted
    @DescSynced
    @RequireRerender
    private int paintingColor = -1;
    protected final List<MachineTrait> traits;
    private final List<TickableSubscription> serverTicks;
    private final List<TickableSubscription> waitingToAdd;
    public boolean isFirstDummyWorldTick = true;

    public MetaMachine(IMachineBlockEntity holder) {
        this.holder = holder;
        this.coverContainer = new MachineCoverContainer(this);
        this.traits = new ArrayList<MachineTrait>();
        this.serverTicks = new ArrayList<TickableSubscription>();
        this.waitingToAdd = new ArrayList<TickableSubscription>();
        if (holder.getRootStorage() != null) {
            this.holder.getRootStorage().attach((IManagedStorage)this.getSyncStorage());
        }
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onChanged() {
        class_1937 level = this.getLevel();
        if (level != null && !level.field_9236 && level.method_8503() != null) {
            level.method_8503().execute(this::markDirty);
        }
    }

    public class_1937 getLevel() {
        return this.holder.level();
    }

    public class_2338 getPos() {
        return this.holder.pos();
    }

    public class_2680 getBlockState() {
        return this.holder.getSelf().method_11010();
    }

    public boolean isRemote() {
        return this.getLevel() == null ? LDLib.isRemote() : this.getLevel().field_9236;
    }

    public void notifyBlockUpdate() {
        this.holder.notifyBlockUpdate();
    }

    @Override
    public void scheduleRenderUpdate() {
        this.holder.scheduleRenderUpdate();
    }

    public void scheduleNeighborShapeUpdate() {
        class_1937 level = this.getLevel();
        class_2338 pos = this.getPos();
        if (level == null || pos == null) {
            return;
        }
        level.method_8320(pos).method_30101((class_1936)level, pos, 3);
    }

    public long getOffsetTimer() {
        return this.holder.getOffsetTimer();
    }

    public void markDirty() {
        this.holder.getSelf().method_5431();
    }

    public boolean isInValid() {
        return this.holder.getSelf().method_11015();
    }

    public void onUnload() {
        this.traits.forEach(MachineTrait::onMachineUnLoad);
        this.coverContainer.onUnload();
        for (TickableSubscription serverTick : this.serverTicks) {
            serverTick.unsubscribe();
        }
        this.serverTicks.clear();
    }

    public void onLoad() {
        this.traits.forEach(MachineTrait::onMachineLoad);
        this.coverContainer.onLoad();
    }

    public void saveCustomPersistedData(class_2487 tag, boolean forDrop) {
    }

    public void loadCustomPersistedData(class_2487 tag) {
    }

    @Override
    @Nullable
    public TickableSubscription subscribeServerTick(Runnable runnable) {
        if (!this.isRemote()) {
            class_1937 class_19372;
            TickableSubscription subscription = new TickableSubscription(runnable);
            this.waitingToAdd.add(subscription);
            class_2680 blockState = this.getBlockState();
            if (!((Boolean)blockState.method_11654((class_2769)BlockProperties.SERVER_TICK)).booleanValue() && (class_19372 = this.getLevel()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                blockState = (class_2680)blockState.method_11657((class_2769)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(true));
                this.holder.getSelf().method_31664(blockState);
                serverLevel.method_8503().method_18858((Runnable)new class_3738(0, () -> {
                    if (!this.isInValid()) {
                        serverLevel.method_8501(this.getPos(), (class_2680)this.getBlockState().method_11657((class_2769)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(true)));
                    }
                }));
            }
            return subscription;
        }
        if (this.getLevel() instanceof DummyWorld) {
            TickableSubscription subscription = new TickableSubscription(runnable);
            this.waitingToAdd.add(subscription);
            return subscription;
        }
        return null;
    }

    @Override
    public void unsubscribe(@Nullable TickableSubscription current) {
        if (current != null) {
            current.unsubscribe();
        }
    }

    public final void serverTick() {
        this.executeTick();
        if (this.serverTicks.isEmpty() && this.waitingToAdd.isEmpty() && !this.isInValid()) {
            this.getLevel().method_8501(this.getPos(), (class_2680)this.getBlockState().method_11657((class_2769)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void clientTick() {
        if (this.getLevel() instanceof DummyWorld) {
            if (this.isFirstDummyWorldTick) {
                this.isFirstDummyWorldTick = false;
                this.onLoad();
            }
            this.executeTick();
        }
    }

    private void executeTick() {
        if (!this.waitingToAdd.isEmpty()) {
            this.serverTicks.addAll(this.waitingToAdd);
            this.waitingToAdd.clear();
        }
        Iterator<TickableSubscription> iter = this.serverTicks.iterator();
        while (iter.hasNext()) {
            TickableSubscription tickable = iter.next();
            if (tickable.isStillSubscribed()) {
                tickable.run();
            }
            if (this.isInValid()) break;
            if (tickable.isStillSubscribed()) continue;
            iter.remove();
        }
    }

    @Override
    public final Pair<GTToolType, class_1269> onToolClick(Set<@NotNull GTToolType> toolType, class_1799 itemStack, class_1838 context) {
        CoverBehavior coverBehavior;
        class_1657 playerIn = context.method_8036();
        if (playerIn == null) {
            return Pair.of(null, (Object)class_1269.field_5811);
        }
        class_1268 hand = context.method_20287();
        class_3965 hitResult = new class_3965(context.method_17698(), context.method_8038(), context.method_8037(), false);
        class_2350 gridSide = ICoverable.determineGridSideHit(hitResult);
        CoverBehavior coverBehavior2 = coverBehavior = gridSide == null ? null : this.coverContainer.getCoverAtSide(gridSide);
        if (gridSide == null) {
            gridSide = hitResult.method_17780();
        }
        if (toolType.contains(GTToolType.SCREWDRIVER)) {
            if (coverBehavior != null) {
                return Pair.of((Object)GTToolType.SCREWDRIVER, (Object)coverBehavior.onScrewdriverClick(playerIn, hand, hitResult));
            }
            return Pair.of((Object)GTToolType.SCREWDRIVER, (Object)this.onScrewdriverClick(playerIn, hand, gridSide, hitResult));
        }
        if (toolType.contains(GTToolType.SOFT_MALLET)) {
            if (coverBehavior != null) {
                return Pair.of((Object)GTToolType.SOFT_MALLET, (Object)coverBehavior.onSoftMalletClick(playerIn, hand, hitResult));
            }
            return Pair.of((Object)GTToolType.SOFT_MALLET, (Object)this.onSoftMalletClick(playerIn, hand, gridSide, hitResult));
        }
        if (toolType.contains(GTToolType.WRENCH)) {
            return Pair.of((Object)GTToolType.WRENCH, (Object)this.onWrenchClick(playerIn, hand, gridSide, hitResult));
        }
        if (toolType.contains(GTToolType.CROWBAR)) {
            if (coverBehavior != null) {
                if (!this.isRemote()) {
                    this.getCoverContainer().removeCover(gridSide, playerIn);
                }
                return Pair.of((Object)GTToolType.CROWBAR, (Object)class_1269.field_21466);
            }
            return Pair.of((Object)GTToolType.CROWBAR, (Object)this.onCrowbarClick(playerIn, hand, gridSide, hitResult));
        }
        if (toolType.contains(GTToolType.HARD_HAMMER)) {
            return Pair.of((Object)GTToolType.HARD_HAMMER, (Object)this.onHardHammerClick(playerIn, hand, gridSide, hitResult));
        }
        return Pair.of(null, (Object)class_1269.field_5811);
    }

    protected class_1269 onHardHammerClick(class_1657 playerIn, class_1268 hand, class_2350 gridSide, class_3965 hitResult) {
        MetaMachine metaMachine = this;
        if (metaMachine instanceof IMufflableMachine) {
            IMufflableMachine mufflableMachine = (IMufflableMachine)((Object)metaMachine);
            if (!this.isRemote()) {
                mufflableMachine.setMuffled(!mufflableMachine.isMuffled());
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    protected class_1269 onCrowbarClick(class_1657 playerIn, class_1268 hand, class_2350 gridSide, class_3965 hitResult) {
        return class_1269.field_5811;
    }

    protected class_1269 onWrenchClick(class_1657 playerIn, class_1268 hand, class_2350 gridSide, class_3965 hitResult) {
        if (playerIn.method_18276()) {
            if (gridSide == this.getFrontFacing() || !this.isFacingValid(gridSide)) {
                return class_1269.field_5814;
            }
            if (!this.isRemote()) {
                this.setFrontFacing(gridSide);
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    protected class_1269 onSoftMalletClick(class_1657 playerIn, class_1268 hand, class_2350 gridSide, class_3965 hitResult) {
        IControllable controllable = GTCapabilityHelper.getControllable(this.getLevel(), this.getPos(), gridSide);
        if (controllable != null) {
            if (!this.isRemote()) {
                controllable.setWorkingEnabled(!controllable.isWorkingEnabled());
                playerIn.method_43496((class_2561)class_2561.method_43471((String)(controllable.isWorkingEnabled() ? "behaviour.soft_hammer.enabled" : "behaviour.soft_hammer.disabled")));
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    protected class_1269 onScrewdriverClick(class_1657 playerIn, class_1268 hand, class_2350 gridSide, class_3965 hitResult) {
        return class_1269.field_5811;
    }

    @Nullable
    public static MetaMachine getMachine(class_1922 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IMachineBlockEntity) {
            IMachineBlockEntity machineBlockEntity = (IMachineBlockEntity)class_25862;
            return machineBlockEntity.getMetaMachine();
        }
        return null;
    }

    public void attachTraits(MachineTrait trait) {
        this.traits.add(trait);
    }

    public static void clearInventory(List<class_1799> itemBuffer, IItemTransfer inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            class_1799 stackInSlot = inventory.getStackInSlot(i);
            if (stackInSlot.method_7960()) continue;
            inventory.setStackInSlot(i, class_1799.field_8037);
            inventory.onContentsChanged();
            itemBuffer.add(stackInSlot);
        }
    }

    @Override
    public boolean shouldRenderGrid(class_1657 player, class_1799 held, Set<GTToolType> toolTypes) {
        if (toolTypes.contains(GTToolType.WRENCH) || toolTypes.contains(GTToolType.SCREWDRIVER)) {
            return true;
        }
        if (toolTypes.contains(GTToolType.HARD_HAMMER) && this instanceof IMufflableMachine) {
            return true;
        }
        for (CoverBehavior cover : this.coverContainer.getCovers()) {
            if (!cover.shouldRenderGrid(player, held, toolTypes)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ResourceTexture sideTips(class_1657 player, Set<GTToolType> toolTypes, class_2350 side) {
        CoverBehavior cover;
        MetaMachine metaMachine;
        if (toolTypes.contains(GTToolType.WRENCH)) {
            if (player.method_18276() && this.isFacingValid(side)) {
                return GuiTextures.TOOL_FRONT_FACING_ROTATION;
            }
        } else if (toolTypes.contains(GTToolType.SOFT_MALLET)) {
            MetaMachine metaMachine2 = this;
            if (metaMachine2 instanceof IControllable) {
                IControllable controllable = (IControllable)((Object)metaMachine2);
                return controllable.isWorkingEnabled() ? GuiTextures.TOOL_PAUSE : GuiTextures.TOOL_START;
            }
        } else if (toolTypes.contains(GTToolType.HARD_HAMMER) && (metaMachine = this) instanceof IMufflableMachine) {
            IMufflableMachine mufflableMachine = (IMufflableMachine)((Object)metaMachine);
            return mufflableMachine.isMuffled() ? GuiTextures.TOOL_SOUND : GuiTextures.TOOL_MUTE;
        }
        if ((cover = this.coverContainer.getCoverAtSide(side)) != null) {
            return cover.sideTips(player, toolTypes, side);
        }
        return null;
    }

    public MachineDefinition getDefinition() {
        return this.holder.getDefinition();
    }

    public void addCollisionBoundingBox(List<class_265> collisionList) {
        collisionList.add(class_259.method_1077());
    }

    public boolean canSetIoOnSide(@Nullable class_2350 direction) {
        return !this.hasFrontFacing() || this.getFrontFacing() != direction;
    }

    public class_2350 getFrontFacing() {
        class_2680 blockState = this.getBlockState();
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof MetaMachineBlock) {
            MetaMachineBlock machineBlock = (MetaMachineBlock)class_22482;
            return machineBlock.getFrontFacing(blockState);
        }
        return class_2350.field_11043;
    }

    public final boolean hasFrontFacing() {
        class_2680 blockState = this.getBlockState();
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof MetaMachineBlock) {
            MetaMachineBlock machineBlock = (MetaMachineBlock)class_22482;
            return machineBlock.getRotationState() != RotationState.NONE;
        }
        return false;
    }

    public boolean isFacingValid(class_2350 facing) {
        if (this.hasFrontFacing() && facing == this.getFrontFacing()) {
            return false;
        }
        class_2680 blockState = this.getBlockState();
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof MetaMachineBlock) {
            MetaMachineBlock metaMachineBlock = (MetaMachineBlock)class_22482;
            return metaMachineBlock.rotationState.test(facing);
        }
        return false;
    }

    public void setFrontFacing(class_2350 facing) {
        class_2680 blockState = this.getBlockState();
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof MetaMachineBlock) {
            MetaMachineBlock metaMachineBlock = (MetaMachineBlock)class_22482;
            if (this.isFacingValid(facing)) {
                this.getLevel().method_8501(this.getPos(), (class_2680)blockState.method_11657((class_2769)metaMachineBlock.rotationState.property, (Comparable)facing));
            }
        }
    }

    public void onRotated(class_2350 oldFacing, class_2350 newFacing) {
    }

    public int tintColor(int index) {
        if (index == 1 || index == -111) {
            return this.getRealColor();
        }
        return -1;
    }

    public void onNeighborChanged(class_2248 block, class_2338 fromPos, boolean isMoving) {
        this.coverContainer.onNeighborChanged(block, fromPos, isMoving);
    }

    public void animateTick(class_5819 random) {
    }

    @Override
    @Nonnull
    public class_2680 getBlockAppearance(class_2680 state, class_1920 level, class_2338 pos, class_2350 side, class_2680 sourceState, class_2338 sourcePos) {
        IMultiPart part;
        class_2680 appearance = this.getCoverContainer().getBlockAppearance(state, level, pos, side, sourceState, sourcePos);
        if (appearance != null) {
            return appearance;
        }
        MetaMachine metaMachine = this;
        if (metaMachine instanceof IMultiPart && (part = (IMultiPart)((Object)metaMachine)).isFormed() && (appearance = part.getFormedAppearance(sourceState, sourcePos, side)) != null) {
            return appearance;
        }
        return this.getDefinition().getAppearance().get();
    }

    @Override
    public int getOutputSignal(@Nullable class_2350 side) {
        if (side == null) {
            return 0;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side.method_10153());
        if (cover == null) {
            return 0;
        }
        return cover.getRedstoneSignalOutput();
    }

    @Override
    public boolean canConnectRedstone(class_2350 side) {
        if (side == null) {
            return false;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
        if (cover == null) {
            return false;
        }
        return cover.canConnectRedstone();
    }

    protected Predicate<class_1799> getItemCapFilter(@Nullable class_2350 side) {
        CoverBehavior cover;
        if (side != null && (cover = this.getCoverContainer().getCoverAtSide(side)) instanceof ItemFilterCover) {
            ItemFilterCover filterCover = (ItemFilterCover)cover;
            return filterCover.getItemFilter();
        }
        return item -> true;
    }

    protected Predicate<FluidStack> getFluidCapFilter(@Nullable class_2350 side) {
        CoverBehavior cover;
        if (side != null && (cover = this.getCoverContainer().getCoverAtSide(side)) instanceof FluidFilterCover) {
            FluidFilterCover filterCover = (FluidFilterCover)cover;
            return filterCover.getFluidFilter();
        }
        return fluid -> true;
    }

    @Nullable
    public IItemTransfer getItemTransferCap(@Nullable class_2350 side, boolean useCoverCapability) {
        IAutoOutputItem autoOutput;
        MetaMachine metaMachine;
        List<IItemTransfer> list = this.getTraits().stream().filter(IItemTransfer.class::isInstance).filter(t -> t.hasCapability(side)).map(IItemTransfer.class::cast).toList();
        if (list.isEmpty()) {
            return null;
        }
        IO io = IO.BOTH;
        if (side != null && (metaMachine = this) instanceof IAutoOutputItem && (autoOutput = (IAutoOutputItem)((Object)metaMachine)).getOutputFacingItems() == side && !autoOutput.isAllowInputFromOutputSideItems()) {
            io = IO.OUT;
        }
        IOItemTransferList transferList = new IOItemTransferList(list, io, this.getItemCapFilter(side));
        if (!useCoverCapability || side == null) {
            return transferList;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
        return cover != null ? cover.getItemTransferCap(side, (IItemTransfer)transferList) : transferList;
    }

    @Nullable
    public IFluidTransfer getFluidTransferCap(@Nullable class_2350 side, boolean useCoverCapability) {
        IAutoOutputFluid autoOutput;
        MetaMachine metaMachine;
        List<IFluidTransfer> list = this.getTraits().stream().filter(IFluidTransfer.class::isInstance).filter(t -> t.hasCapability(side)).map(IFluidTransfer.class::cast).toList();
        if (list.isEmpty()) {
            return null;
        }
        IO io = IO.BOTH;
        if (side != null && (metaMachine = this) instanceof IAutoOutputFluid && (autoOutput = (IAutoOutputFluid)((Object)metaMachine)).getOutputFacingFluids() == side && !autoOutput.isAllowInputFromOutputSideFluids()) {
            io = IO.OUT;
        }
        IOFluidTransferList transferList = new IOFluidTransferList(list, io, this.getFluidCapFilter(side));
        if (!useCoverCapability || side == null) {
            return transferList;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
        return cover != null ? cover.getFluidTransferCap(side, (IFluidTransfer)transferList) : transferList;
    }

    @Override
    public IGuiTexture getFancyTooltipIcon() {
        return GuiTextures.INFO_ICON;
    }

    @Override
    public final List<class_2561> getFancyTooltip() {
        ArrayList<class_2561> tooltips = new ArrayList<class_2561>();
        this.onAddFancyInformationTooltip(tooltips);
        return tooltips;
    }

    @Override
    public boolean showFancyTooltip() {
        return !this.getFancyTooltip().isEmpty();
    }

    public void onAddFancyInformationTooltip(List<class_2561> tooltips) {
        this.getDefinition().getTooltipBuilder().accept(this.getDefinition().asStack(), tooltips);
        String mainKey = String.format("%s.machine.%s.tooltip", this.getDefinition().getId().method_12836(), this.getDefinition().getId().method_12832());
        if (LocalizationUtils.exist((String)mainKey)) {
            tooltips.add(0, (class_2561)class_2561.method_43471((String)mainKey));
        }
    }

    @Override
    public int getDefaultPaintingColor() {
        return this.getDefinition().getDefaultPaintingColor();
    }

    public EnhancedFieldManagedStorage getSyncStorage() {
        return this.syncStorage;
    }

    public IMachineBlockEntity getHolder() {
        return this.holder;
    }

    public MachineCoverContainer getCoverContainer() {
        return this.coverContainer;
    }

    @Override
    public int getPaintingColor() {
        return this.paintingColor;
    }

    @Override
    public void setPaintingColor(int paintingColor) {
        this.paintingColor = paintingColor;
    }

    public List<MachineTrait> getTraits() {
        return this.traits;
    }
}

