/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool.aoe;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.class_2487;

public class AoESymmetrical {
    public final int column;
    public final int row;
    public final int layer;
    private static final AoESymmetrical NONE = new AoESymmetrical();

    private AoESymmetrical() {
        this.column = 0;
        this.row = 0;
        this.layer = 0;
    }

    private AoESymmetrical(int column, int row, int layer) {
        this.column = column;
        this.row = row;
        this.layer = layer;
    }

    public static AoESymmetrical none() {
        return NONE;
    }

    public static AoESymmetrical of(int column, int row, int layer) {
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0, (Object)"Height cannot be negative.");
        Preconditions.checkArgument((row >= 0 ? 1 : 0) != 0, (Object)"Width cannot be negative.");
        Preconditions.checkArgument((layer >= 0 ? 1 : 0) != 0, (Object)"Depth cannot be negative.");
        return column == 0 && row == 0 && layer == 0 ? NONE : new AoESymmetrical(column, row, layer);
    }

    public static AoESymmetrical readMax(class_2487 tag) {
        int column = 0;
        int row = 0;
        int layer = 0;
        if (tag.method_10573("MaxAoEColumn", 3)) {
            column = tag.method_10550("MaxAoEColumn");
        }
        if (tag.method_10573("MaxAoERow", 3)) {
            row = tag.method_10550("MaxAoERow");
        }
        if (tag.method_10573("MaxAoELayer", 3)) {
            layer = tag.method_10550("MaxAoELayer");
        }
        return column == 0 && row == 0 && layer == 0 ? NONE : AoESymmetrical.of(column, row, layer);
    }

    public static AoESymmetrical read(class_2487 tag, @Nullable AoESymmetrical defaultDefinition) {
        int layer;
        int row;
        int column;
        if (tag.method_10573("AoEColumn", 3)) {
            column = tag.method_10550("AoEColumn");
        } else {
            int n = column = defaultDefinition == null ? 0 : defaultDefinition.column;
        }
        if (tag.method_10573("AoERow", 3)) {
            row = tag.method_10550("AoERow");
        } else {
            int n = row = defaultDefinition == null ? 0 : defaultDefinition.row;
        }
        if (tag.method_10573("AoELayer", 3)) {
            layer = tag.method_10550("AoELayer");
        } else {
            int n = layer = defaultDefinition == null ? 0 : defaultDefinition.layer;
        }
        if (column == 0 && row == 0 && layer == 0) {
            return NONE;
        }
        tag.method_10569("AoEColumn", column);
        tag.method_10569("AoERow", row);
        tag.method_10569("AoELayer", layer);
        return AoESymmetrical.of(column, row, layer);
    }

    public static int getColumn(class_2487 tag, AoESymmetrical defaultDefinition) {
        if (tag.method_10573("AoEColumn", 3)) {
            return tag.method_10550("AoEColumn");
        }
        return defaultDefinition.column;
    }

    public static int getRow(class_2487 tag, AoESymmetrical defaultDefinition) {
        if (tag.method_10573("AoERow", 3)) {
            return tag.method_10550("AoERow");
        }
        return defaultDefinition.row;
    }

    public static int getLayer(class_2487 tag, AoESymmetrical defaultDefinition) {
        if (tag.method_10573("AoELayer", 3)) {
            return tag.method_10550("AoELayer");
        }
        return defaultDefinition.layer;
    }

    public static void increaseColumn(class_2487 tag, AoESymmetrical defaultDefinition) {
        if (!tag.method_10573("AoEColumn", 3)) {
            tag.method_10569("AoEColumn", defaultDefinition.column);
        } else {
            int currentColumn = tag.method_10550("AoEColumn");
            if (currentColumn < defaultDefinition.column) {
                tag.method_10569("AoEColumn", currentColumn + 1);
            }
        }
    }

    public static void increaseRow(class_2487 tag, AoESymmetrical defaultDefinition) {
        if (!tag.method_10573("AoERow", 3)) {
            tag.method_10569("AoERow", defaultDefinition.row);
        } else {
            int currentRow = tag.method_10550("AoERow");
            if (currentRow < defaultDefinition.row) {
                tag.method_10569("AoERow", currentRow + 1);
            }
        }
    }

    public static void increaseLayer(class_2487 tag, AoESymmetrical defaultDefinition) {
        if (!tag.method_10573("AoELayer", 3)) {
            tag.method_10569("AoELayer", defaultDefinition.layer);
        } else {
            int currentLayer = tag.method_10550("AoELayer");
            if (currentLayer < defaultDefinition.layer) {
                tag.method_10569("AoELayer", currentLayer + 1);
            }
        }
    }

    public static void decreaseColumn(class_2487 tag, AoESymmetrical defaultDefinition) {
        if (!tag.method_10573("AoEColumn", 3)) {
            tag.method_10569("AoEColumn", defaultDefinition.column);
        } else {
            int currentColumn = tag.method_10550("AoEColumn");
            if (currentColumn > 0) {
                tag.method_10569("AoEColumn", currentColumn - 1);
            }
        }
    }

    public static void decreaseRow(class_2487 tag, AoESymmetrical defaultDefinition) {
        if (!tag.method_10573("AoERow", 3)) {
            tag.method_10569("AoERow", defaultDefinition.row);
        } else {
            int currentRow = tag.method_10550("AoERow");
            if (currentRow > 0) {
                tag.method_10569("AoERow", currentRow - 1);
            }
        }
    }

    public static void decreaseLayer(class_2487 tag, AoESymmetrical defaultDefinition) {
        if (!tag.method_10573("AoELayer", 3)) {
            tag.method_10569("AoELayer", defaultDefinition.layer);
        } else {
            int currentLayer = tag.method_10550("AoELayer");
            if (currentLayer > 0) {
                tag.method_10569("AoELayer", currentLayer - 1);
            }
        }
    }
}

