/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTAxeItem;
import com.gregtechceu.gtceu.api.item.tool.GTHoeItem;
import com.gregtechceu.gtceu.api.item.tool.GTShovelItem;
import com.gregtechceu.gtceu.api.item.tool.GTSwordItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolItem;
import com.gregtechceu.gtceu.api.item.tool.IGTToolDefinition;
import com.gregtechceu.gtceu.api.item.tool.MaterialToolTier;
import com.gregtechceu.gtceu.api.item.tool.ToolDefinitionBuilder;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.sound.ExistingSoundEntry;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gregtechceu.gtceu.common.item.tool.behavior.BlockRotatingBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.DisableShieldBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.EntityDamageBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.GrassPathBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.HarvestCropsBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.HarvestIceBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.HoeGroundBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.LogStripBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.PlungerBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.RotateRailBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.ScrapeBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.TreeFellingBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.WaxOffBehavior;
import com.lowdragmc.lowdraglib.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.class_1439;
import net.minecraft.class_1628;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1886;
import net.minecraft.class_1893;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class GTToolType {
    private static final Map<String, GTToolType> types = new HashMap<String, GTToolType>();
    public static final GTToolType SWORD = GTToolType.builder("sword").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("swords", true)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("swords", true)).harvestTag(TagPrefix.LoaderType.FORGE, TagUtil.createBlockTag("mineable/sword")).harvestTag(TagPrefix.LoaderType.FABRIC, TagUtil.createBlockTag("mineable/sword")).toolStats(b -> b.attacking().attackDamage(3.0f).attackSpeed(-2.4f)).constructor(GTSwordItem::create).build();
    public static final GTToolType PICKAXE = GTToolType.builder("pickaxe").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("pickaxes", true)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("pickaxes", true)).harvestTag(TagPrefix.LoaderType.FORGE, TagUtil.createBlockTag("mineable/pickaxe", true)).harvestTag(TagPrefix.LoaderType.FABRIC, TagUtil.createBlockTag("mineable/pickaxe", true)).toolStats(b -> b.blockBreaking().attackDamage(1.0f).attackSpeed(-2.8f)).build();
    public static final GTToolType SHOVEL = GTToolType.builder("shovel").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("shovels", true)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("shovels", true)).harvestTag(TagPrefix.LoaderType.FORGE, TagUtil.createBlockTag("mineable/shovel", true)).harvestTag(TagPrefix.LoaderType.FABRIC, TagUtil.createBlockTag("mineable/shovel", true)).toolStats(b -> b.blockBreaking().attackDamage(1.5f).attackSpeed(-3.0f).behaviors(GrassPathBehavior.INSTANCE)).constructor(GTShovelItem::create).build();
    public static final GTToolType AXE = GTToolType.builder("axe").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("axes", true)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("axes", true)).harvestTag(TagPrefix.LoaderType.FORGE, TagUtil.createBlockTag("mineable/axe", true)).harvestTag(TagPrefix.LoaderType.FABRIC, TagUtil.createBlockTag("mineable/axe", true)).toolStats(b -> b.blockBreaking().attackDamage(5.0f).attackSpeed(-3.2f).baseEfficiency(2.0f).behaviors(DisableShieldBehavior.INSTANCE, TreeFellingBehavior.INSTANCE, LogStripBehavior.INSTANCE, ScrapeBehavior.INSTANCE, WaxOffBehavior.INSTANCE)).constructor(GTAxeItem::create).build();
    public static final GTToolType HOE = GTToolType.builder("hoe").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("hoes", true)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("hoes", true)).harvestTag(TagPrefix.LoaderType.FORGE, TagUtil.createBlockTag("mineable/hoe", true)).harvestTag(TagPrefix.LoaderType.FABRIC, TagUtil.createBlockTag("mineable/hoe", true)).toolStats(b -> b.cannotAttack().attackSpeed(-1.0f)).constructor(GTHoeItem::create).build();
    public static final GTToolType MINING_HAMMER = GTToolType.builder("mining_hammer").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("tools/mining_hammers", false)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("mining_hammers", false)).harvestTag(TagPrefix.LoaderType.FORGE, TagUtil.createBlockTag("mineable/pickaxe", true)).harvestTag(TagPrefix.LoaderType.FABRIC, TagUtil.createBlockTag("mineable/pickaxe", true)).toolStats(b -> b.blockBreaking().aoe(1, 1, 0).efficiencyMultiplier(0.4f).attackDamage(1.5f).attackSpeed(-3.2f).durabilityMultiplier(3.0f)).build();
    public static final GTToolType SPADE = GTToolType.builder("spade").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("tools/spades", false)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("spades", false)).harvestTag(TagPrefix.LoaderType.FORGE, TagUtil.createBlockTag("mineable/shovel", true)).harvestTag(TagPrefix.LoaderType.FABRIC, TagUtil.createBlockTag("mineable/shovel", true)).toolStats(b -> b.blockBreaking().aoe(1, 1, 0).efficiencyMultiplier(0.4f).attackDamage(1.5f).attackSpeed(-3.2f).durabilityMultiplier(3.0f).behaviors(GrassPathBehavior.INSTANCE)).build();
    public static final GTToolType SCYTHE = GTToolType.builder("scythe").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("tools/scythes", false)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("scythes", false)).harvestTag(TagPrefix.LoaderType.FORGE, TagUtil.createBlockTag("mineable/hoe", true)).harvestTag(TagPrefix.LoaderType.FABRIC, TagUtil.createBlockTag("mineable/hoe", true)).toolStats(b -> b.blockBreaking().attacking().attackDamage(5.0f).attackSpeed(-3.0f).durabilityMultiplier(3.0f).aoe(2, 2, 2).behaviors(HoeGroundBehavior.INSTANCE, HarvestCropsBehavior.INSTANCE).canApplyEnchantment(class_1886.field_9069)).constructor(GTHoeItem::create).build();
    public static final GTToolType SAW = GTToolType.builder("saw").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("tools/saws", false)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("saws", false)).harvestTag(TagPrefix.LoaderType.FORGE, TagUtil.createBlockTag("mineable/saw", false)).harvestTag(TagPrefix.LoaderType.FABRIC, TagUtil.createBlockTag("mineable/saw", false)).toolStats(b -> b.crafting().damagePerCraftingAction(2).attackDamage(-1.0f).attackSpeed(-2.6f).behaviors(HarvestIceBehavior.INSTANCE)).sound(GTSoundEntries.SAW_TOOL).symbol(Character.valueOf('s')).build();
    public static final GTToolType HARD_HAMMER = GTToolType.builder("hammer").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("tools/hammers", false)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("hammers", false)).harvestTag(TagPrefix.LoaderType.FORGE, TagUtil.createBlockTag("mineable/hammer", false)).harvestTag(TagPrefix.LoaderType.FORGE, TagUtil.createBlockTag("mineable/pickaxe", true)).harvestTag(TagPrefix.LoaderType.FABRIC, TagUtil.createBlockTag("mineable/hammer", false)).harvestTag(TagPrefix.LoaderType.FABRIC, TagUtil.createBlockTag("mineable/pickaxe", true)).toolStats(b -> b.blockBreaking().crafting().damagePerCraftingAction(2).attackDamage(1.0f).attackSpeed(-2.8f).behaviors(new EntityDamageBehavior(2.0f, class_1439.class))).sound(GTSoundEntries.FORGE_HAMMER).symbol(Character.valueOf('h')).build();
    public static final GTToolType SOFT_MALLET = GTToolType.builder("mallet").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("tools/mallets", false)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("mallets", false)).toolStats(b -> b.crafting().cannotAttack().attackSpeed(-2.4f)).sound(GTSoundEntries.SOFT_MALLET_TOOL).symbol(Character.valueOf('r')).build();
    public static final GTToolType WRENCH = GTToolType.builder("wrench").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("tools/wrenches", false)).toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("tools/wrench", false)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("wrenches", false)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("wrench", false)).harvestTag(TagPrefix.LoaderType.FORGE, TagUtil.createBlockTag("mineable/wrench", false)).harvestTag(TagPrefix.LoaderType.FABRIC, TagUtil.createBlockTag("mineable/wrench", false)).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().attackDamage(1.0f).attackSpeed(-2.8f).behaviors(BlockRotatingBehavior.INSTANCE, new EntityDamageBehavior(3.0f, class_1439.class))).sound(GTSoundEntries.WRENCH_TOOL).symbol(Character.valueOf('w')).build();
    public static final GTToolType FILE = GTToolType.builder("file").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("tools/files", false)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("files", false)).toolStats(b -> b.crafting().damagePerCraftingAction(4).cannotAttack().attackSpeed(-2.4f)).sound(GTSoundEntries.FILE_TOOL).symbol(Character.valueOf('f')).build();
    public static final GTToolType CROWBAR = GTToolType.builder("crowbar").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("tools/crowbars", false)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("crowbars", false)).harvestTag(TagPrefix.LoaderType.FORGE, TagUtil.createBlockTag("mineable/crowbar", false)).harvestTag(TagPrefix.LoaderType.FABRIC, TagUtil.createBlockTag("mineable/crowbar", false)).toolStats(b -> b.blockBreaking().crafting().attackDamage(2.0f).attackSpeed(-2.4f).sneakBypassUse().behaviors(RotateRailBehavior.INSTANCE)).sound(new ExistingSoundEntry(class_3417.field_15075, class_3419.field_15245)).symbol(Character.valueOf('c')).build();
    public static final GTToolType SCREWDRIVER = GTToolType.builder("screwdriver").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("tools/screwdrivers", false)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("screwdrivers", false)).toolStats(b -> b.crafting().damagePerCraftingAction(4).sneakBypassUse().attackDamage(-1.0f).attackSpeed(3.0f).behaviors(new EntityDamageBehavior(3.0f, class_1628.class))).sound(GTSoundEntries.SCREWDRIVER_TOOL).symbol(Character.valueOf('d')).build();
    public static final GTToolType MORTAR = GTToolType.builder("mortar").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("tools/mortars", false)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("mortars", false)).toolStats(b -> b.crafting().damagePerCraftingAction(2).cannotAttack().attackSpeed(-2.4f)).sound(GTSoundEntries.MORTAR_TOOL).symbol(Character.valueOf('m')).build();
    public static final GTToolType WIRE_CUTTER = GTToolType.builder("wire_cutter").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("tools/wire_cutters", false)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("wire_cutters", false)).harvestTag(TagPrefix.LoaderType.FORGE, TagUtil.createBlockTag("mineable/wire_cutter", false)).harvestTag(TagPrefix.LoaderType.FABRIC, TagUtil.createBlockTag("mineable/wire_cutter", false)).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().damagePerCraftingAction(4).attackDamage(-1.0f).attackSpeed(-2.4f)).sound(GTSoundEntries.WIRECUTTER_TOOL).symbol(Character.valueOf('x')).build();
    public static final GTToolType KNIFE = GTToolType.builder("knife").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("tools/knives", false)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("knives", false)).harvestTag(TagPrefix.LoaderType.FORGE, TagUtil.createBlockTag("mineable/knife", false)).harvestTag(TagPrefix.LoaderType.FABRIC, TagUtil.createBlockTag("mineable/knife", false)).toolStats(b -> b.crafting().attacking().attackSpeed(3.0f)).constructor(GTSwordItem::create).symbol(Character.valueOf('k')).build();
    public static final GTToolType BUTCHERY_KNIFE = GTToolType.builder("butchery_knife").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("tools/butchery_knives", false)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("butchery_knives", false)).toolStats(b -> b.attacking().attackDamage(1.5f).attackSpeed(-1.3f).defaultEnchantment(class_1893.field_9110, 3)).constructor(GTSwordItem::create).build();
    public static final GTToolType PLUNGER = GTToolType.builder("plunger").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("tools/plungers", false)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("plungers", false)).toolStats(b -> b.cannotAttack().attackSpeed(-2.4f).sneakBypassUse().behaviors(PlungerBehavior.INSTANCE)).sound(GTSoundEntries.PLUNGER_TOOL).build();
    public static final GTToolType SHEARS = GTToolType.builder("shears").toolTag(TagPrefix.LoaderType.FORGE, TagUtil.createItemTag("tools/shears", false)).toolTag(TagPrefix.LoaderType.FABRIC, TagUtil.createItemTag("shears", false)).harvestTag(TagPrefix.LoaderType.FORGE, TagUtil.createBlockTag("mineable/shears", false)).harvestTag(TagPrefix.LoaderType.FABRIC, TagUtil.createBlockTag("mineable/shears", false)).toolStats(b -> b).build();
    public final String name;
    public final List<class_6862<class_1792>> itemTags;
    public final List<class_6862<class_2248>> harvestTags;
    public final class_2960 modelLocation;
    @Nullable
    public final SoundEntry soundEntry;
    public final boolean playSoundOnBlockDestroy;
    public final Character symbol;
    public final IGTToolDefinition toolDefinition;
    public final ToolConstructor constructor;
    public final int electricTier;

    public GTToolType(String name, Character symbol, IGTToolDefinition toolDefinition, ToolConstructor constructor, List<class_6862<class_2248>> harvestTags, List<class_6862<class_1792>> itemTags, class_2960 modelLocation, @Nullable SoundEntry soundEntry, boolean playSoundOnBlockDestroy, int electricTier) {
        this.name = name;
        this.symbol = symbol;
        this.toolDefinition = toolDefinition;
        this.constructor = constructor;
        this.itemTags = itemTags;
        this.harvestTags = harvestTags;
        this.modelLocation = modelLocation;
        this.soundEntry = soundEntry;
        this.playSoundOnBlockDestroy = playSoundOnBlockDestroy;
        this.electricTier = electricTier;
        types.put(name, this);
    }

    public boolean is(class_1799 itemStack) {
        return ToolHelper.is(itemStack, this);
    }

    public String getUnlocalizedName() {
        return "item.gtceu.tool." + this.name;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static Map<String, GTToolType> getTypes() {
        return types;
    }

    @FunctionalInterface
    public static interface ToolConstructor {
        public IGTTool apply(GTToolType var1, MaterialToolTier var2, Material var3, IGTToolDefinition var4, class_1792.class_1793 var5);
    }

    public static class Builder {
        private final String name;
        private final List<class_6862<class_1792>> forgeItemTags = new ArrayList<class_6862<class_1792>>();
        private final List<class_6862<class_1792>> fabricItemTags = new ArrayList<class_6862<class_1792>>();
        private final List<class_6862<class_2248>> forgeHarvestTags = new ArrayList<class_6862<class_2248>>();
        private final List<class_6862<class_2248>> fabricHarvestTags = new ArrayList<class_6862<class_2248>>();
        private IGTToolDefinition toolStats;
        private int tier = -1;
        private Character symbol = null;
        private ToolConstructor constructor = GTToolItem::create;
        private class_2960 modelLocation;
        private SoundEntry sound;
        private boolean playSoundOnBlockDestroy;

        public Builder(String name) {
            this.name = name;
            this.modelLocation = GTCEu.id("item/tools/" + name);
        }

        @SafeVarargs
        public final Builder toolTag(TagPrefix.LoaderType loader, class_6862<class_1792> ... tags) {
            (loader == TagPrefix.LoaderType.FORGE ? this.forgeItemTags : this.fabricItemTags).addAll(Arrays.stream(tags).toList());
            return this;
        }

        @SafeVarargs
        public final Builder harvestTag(TagPrefix.LoaderType loader, class_6862<class_2248> ... tags) {
            (loader == TagPrefix.LoaderType.FORGE ? this.forgeHarvestTags : this.fabricHarvestTags).addAll(Arrays.stream(tags).toList());
            return this;
        }

        public Builder toolStats(UnaryOperator<ToolDefinitionBuilder> builder) {
            this.toolStats = ((ToolDefinitionBuilder)builder.apply(new ToolDefinitionBuilder())).build();
            return this;
        }

        public Builder sound(SoundEntry sound) {
            return this.sound(sound, false);
        }

        public Builder sound(SoundEntry sound, boolean playSoundOnBlockDestroy) {
            this.sound = sound;
            this.playSoundOnBlockDestroy = playSoundOnBlockDestroy;
            return this;
        }

        private GTToolType get() {
            return new GTToolType(this.name, this.symbol, this.toolStats, this.constructor, Platform.isForge() ? this.forgeHarvestTags : this.fabricHarvestTags, Platform.isForge() ? this.forgeItemTags : this.fabricItemTags, this.modelLocation, this.sound, this.playSoundOnBlockDestroy, this.tier);
        }

        public GTToolType build() {
            if (this.symbol == null) {
                return this.get();
            }
            GTToolType existing = ToolHelper.getToolFromSymbol(this.symbol);
            if (existing != null) {
                throw new IllegalArgumentException(String.format("Symbol %s has been taken by %s already!", this.symbol, existing));
            }
            GTToolType supplied = this.get();
            ToolHelper.registerToolSymbol(this.symbol, supplied);
            return supplied;
        }

        public Builder toolStats(IGTToolDefinition toolStats) {
            this.toolStats = toolStats;
            return this;
        }

        public Builder tier(int tier) {
            this.tier = tier;
            return this;
        }

        public Builder symbol(Character symbol) {
            this.symbol = symbol;
            return this;
        }

        public Builder constructor(ToolConstructor constructor) {
            this.constructor = constructor;
            return this;
        }

        public Builder modelLocation(class_2960 modelLocation) {
            this.modelLocation = modelLocation;
            return this;
        }
    }
}

