/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.component;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.ICustomDescriptionId;
import com.gregtechceu.gtceu.api.item.component.IDurabilityBar;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_326;
import org.jetbrains.annotations.Nullable;

public interface IMaterialPartItem
extends IItemComponent,
IDurabilityBar,
IAddInformation,
ICustomDescriptionId {
    public int getPartMaxDurability(class_1799 var1);

    @javax.annotation.Nullable
    default public class_2487 getPartStatsTag(class_1799 itemStack) {
        return itemStack.method_7941("GT.PartStats");
    }

    default public class_2487 getOrCreatePartStatsTag(class_1799 itemStack) {
        return itemStack.method_7911("GT.PartStats");
    }

    default public Material getPartMaterial(class_1799 itemStack) {
        class_2487 compound = this.getPartStatsTag(itemStack);
        Material defaultMaterial = GTMaterials.Neutronium;
        if (compound == null || !compound.method_10573("Material", 8)) {
            return defaultMaterial;
        }
        String materialName = compound.method_10558("Material");
        Material material = GTMaterials.get(materialName);
        if (material == null || !material.hasProperty(PropertyKey.INGOT)) {
            return defaultMaterial;
        }
        return material;
    }

    default public void setPartMaterial(class_1799 itemStack, @Nonnull Material material) {
        if (!material.hasProperty(PropertyKey.INGOT)) {
            throw new IllegalArgumentException("Part material must have an Ingot!");
        }
        class_2487 compound = this.getOrCreatePartStatsTag(itemStack);
        compound.method_10582("Material", material.getName());
    }

    default public int getPartDamage(class_1799 itemStack) {
        class_2487 compound = this.getPartStatsTag(itemStack);
        if (compound == null || !compound.method_10573("Damage", 99)) {
            return 0;
        }
        return compound.method_10550("Damage");
    }

    default public void setPartDamage(class_1799 itemStack, int damage) {
        class_2487 compound = this.getOrCreatePartStatsTag(itemStack);
        compound.method_10569("Damage", Math.min(this.getPartMaxDurability(itemStack), damage));
    }

    @Override
    default public String getItemStackDisplayName(class_1799 itemStack) {
        Material material = this.getPartMaterial(itemStack);
        return LocalizationUtils.format((String)itemStack.method_7909().method_7876(), (Object[])new Object[0]) + "-" + LocalizationUtils.format((String)material.getUnlocalizedName(), (Object[])new Object[0]);
    }

    @Override
    default public void appendHoverText(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        Material material = this.getPartMaterial(stack);
        int maxDurability = this.getPartMaxDurability(stack);
        int damage = this.getPartDamage(stack);
        tooltipComponents.add((class_2561)class_2561.method_43469((String)"metaitem.tool.tooltip.durability", (Object[])new Object[]{maxDurability - damage, maxDurability}));
        tooltipComponents.add((class_2561)class_2561.method_43469((String)"metaitem.tool.tooltip.primary_material", (Object[])new Object[]{material.getLocalizedName()}));
    }

    @Environment(value=EnvType.CLIENT)
    public static class_326 getItemStackColor() {
        return (itemStack, i) -> {
            class_1792 patt3752$temp = itemStack.method_7909();
            if (patt3752$temp instanceof ComponentItem) {
                ComponentItem componentItem = (ComponentItem)patt3752$temp;
                for (IItemComponent component : componentItem.getComponents()) {
                    if (!(component instanceof IMaterialPartItem)) continue;
                    IMaterialPartItem materialPartItem = (IMaterialPartItem)component;
                    return materialPartItem.getPartMaterial(itemStack).getMaterialARGB();
                }
            }
            return -1;
        };
    }

    @Override
    default public float getDurabilityForDisplay(class_1799 itemStack) {
        int maxDurability = this.getPartMaxDurability(itemStack);
        return (float)(maxDurability - this.getPartDamage(itemStack)) * 1.0f / (float)maxDurability;
    }
}

