/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.DustProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.fabric.TagPrefixItemImpl;
import com.gregtechceu.gtceu.client.renderer.item.TagPrefixItemRenderer;
import com.gregtechceu.gtceu.common.data.GTDamageTypes;
import com.lowdragmc.lowdraglib.Platform;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_326;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class TagPrefixItem
extends class_1792 {
    public final TagPrefix tagPrefix;
    public final Material material;

    protected TagPrefixItem(class_1792.class_1793 properties, TagPrefix tagPrefix, Material material) {
        super(properties);
        this.tagPrefix = tagPrefix;
        this.material = material;
        if (Platform.isClient()) {
            TagPrefixItemRenderer.create(this, tagPrefix.materialIconType(), material.getMaterialIconSet());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static TagPrefixItem create(class_1792.class_1793 properties, TagPrefix tagPrefix, Material material) {
        void var2_2;
        void var1_1;
        return TagPrefixItemImpl.create(properties, (TagPrefix)var1_1, (Material)var2_2);
    }

    public void onRegister() {
    }

    @Environment(value=EnvType.CLIENT)
    public static class_326 tintColor() {
        return (itemStack, index) -> {
            class_1792 patt2194$temp = itemStack.method_7909();
            if (patt2194$temp instanceof TagPrefixItem) {
                TagPrefixItem tagPrefixItem = (TagPrefixItem)patt2194$temp;
                return tagPrefixItem.material.getLayerARGB(index);
            }
            return -1;
        };
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        super.method_7851(stack, level, tooltipComponents, isAdvanced);
        if (this.tagPrefix.tooltip() != null) {
            this.tagPrefix.tooltip().accept(this.material, tooltipComponents);
        }
    }

    public String method_7876() {
        return this.tagPrefix.getUnlocalizedName(this.material);
    }

    public String method_7866(class_1799 stack) {
        return this.tagPrefix.getUnlocalizedName(this.material);
    }

    public class_2561 method_7848() {
        return this.tagPrefix.getLocalizedName(this.material);
    }

    public class_2561 method_7864(class_1799 stack) {
        return this.method_7848();
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        super.method_7888(stack, level, entity, slotId, isSelected);
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            if (livingEntity.field_6012 % 20 == 0) {
                if (this.tagPrefix != TagPrefix.ingotHot || !this.material.hasProperty(PropertyKey.BLAST)) {
                    return;
                }
                float heatDamage = (float)(this.material.getBlastTemperature() - 1750) / 1000.0f + 2.0f;
                class_1799 armor = livingEntity.method_6118(class_1304.field_6174);
                if ((double)heatDamage > 0.0) {
                    livingEntity.method_5643(GTDamageTypes.HEAT.source((class_1936)level), heatDamage);
                } else if ((double)heatDamage < 0.0) {
                    livingEntity.method_5643(GTDamageTypes.FROST.source((class_1936)level), -heatDamage);
                }
            }
        }
    }

    public int getItemBurnTime() {
        DustProperty property;
        DustProperty dustProperty = property = this.material == null ? null : this.material.getProperty(PropertyKey.DUST);
        if (property != null) {
            return (int)((long)property.getBurnTime() * this.tagPrefix.getMaterialAmount(this.material) / 3628800L);
        }
        return -1;
    }
}

