/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item;

import com.gregtechceu.gtceu.api.item.IItemUseFirst;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.ICustomDescriptionId;
import com.gregtechceu.gtceu.api.item.component.ICustomRenderer;
import com.gregtechceu.gtceu.api.item.component.IDurabilityBar;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.item.component.IItemLifeCycle;
import com.gregtechceu.gtceu.api.item.component.IItemUIFactory;
import com.gregtechceu.gtceu.api.item.component.ISubItemHandler;
import com.gregtechceu.gtceu.api.item.fabric.ComponentItemImpl;
import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.gui.factory.HeldItemUIFactory;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_6328;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public class ComponentItem
extends class_1792
implements HeldItemUIFactory.IHeldItemUIHolder,
IItemRendererProvider,
IItemUseFirst {
    protected List<IItemComponent> components = new ArrayList<IItemComponent>();

    protected ComponentItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ComponentItem create(class_1792.class_1793 properties) {
        return ComponentItemImpl.create(properties);
    }

    public void attachComponents(IItemComponent ... components) {
        this.components.addAll(Arrays.asList(components));
        for (IItemComponent component : components) {
            component.onAttached(this);
        }
    }

    public void fillItemCategory(class_1761 category, class_2371<class_1799> items) {
        boolean found = false;
        for (IItemComponent component : this.components) {
            if (!(component instanceof ISubItemHandler)) continue;
            ISubItemHandler subItemHandler = (ISubItemHandler)component;
            subItemHandler.fillItemCategory(this, category, items);
            found = true;
        }
        if (found) {
            return;
        }
        items.add((Object)new class_1799((class_1935)this));
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IAddInformation)) continue;
            IAddInformation addInformation = (IAddInformation)component;
            addInformation.appendHoverText(stack, level, tooltipComponents, isAdvanced);
        }
    }

    public boolean method_31567(class_1799 stack) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IDurabilityBar)) continue;
            IDurabilityBar durabilityBar = (IDurabilityBar)component;
            return durabilityBar.isBarVisible(stack);
        }
        return super.method_31567(stack);
    }

    public int method_31569(class_1799 stack) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IDurabilityBar)) continue;
            IDurabilityBar durabilityBar = (IDurabilityBar)component;
            return durabilityBar.getBarWidth(stack);
        }
        return super.method_31569(stack);
    }

    public int method_31571(class_1799 stack) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IDurabilityBar)) continue;
            IDurabilityBar durabilityBar = (IDurabilityBar)component;
            return durabilityBar.getBarColor(stack);
        }
        return super.method_31571(stack);
    }

    public class_1269 method_7884(class_1838 context) {
        for (IItemComponent component : this.components) {
            IInteractionItem interactionItem;
            class_1269 result;
            if (!(component instanceof IInteractionItem) || (result = (interactionItem = (IInteractionItem)component).method_7884(context)) == class_1269.field_5811) continue;
            return result;
        }
        return super.method_7884(context);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        for (IItemComponent component : this.components) {
            IInteractionItem interactionItem;
            class_1271<class_1799> result;
            if (!(component instanceof IInteractionItem) || (result = (interactionItem = (IInteractionItem)component).use(this, level, player, usedHand)).method_5467() == class_1269.field_5811) continue;
            return result;
        }
        return super.method_7836(level, player, usedHand);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 level, class_1309 livingEntity) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IInteractionItem)) continue;
            IInteractionItem interactionItem = (IInteractionItem)component;
            stack = interactionItem.finishUsingItem(stack, level, livingEntity);
        }
        return super.method_7861(stack, level, livingEntity);
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 itemStack, class_1838 context) {
        for (IItemComponent component : this.components) {
            IInteractionItem interactionItem;
            class_1269 result;
            if (!(component instanceof IInteractionItem) || (result = (interactionItem = (IInteractionItem)component).onItemUseFirst(itemStack, context)) == class_1269.field_5811) continue;
            return result;
        }
        return class_1269.field_5811;
    }

    public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 interactionTarget, class_1268 usedHand) {
        for (IItemComponent component : this.components) {
            IInteractionItem interactionItem;
            class_1269 result;
            if (!(component instanceof IInteractionItem) || (result = (interactionItem = (IInteractionItem)component).interactLivingEntity(stack, player, interactionTarget, usedHand)) == class_1269.field_5811) continue;
            return result;
        }
        return class_1269.field_5811;
    }

    public String method_7866(class_1799 stack) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof ICustomDescriptionId)) continue;
            ICustomDescriptionId customDescriptionId = (ICustomDescriptionId)component;
            return customDescriptionId.getItemStackDisplayName(stack);
        }
        return super.method_7866(stack);
    }

    @Nullable
    public ModularUI createUI(class_1657 entityPlayer, HeldItemUIFactory.HeldItemHolder holder) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IItemUIFactory)) continue;
            IItemUIFactory uiFactory = (IItemUIFactory)component;
            return uiFactory.createUI(holder, entityPlayer);
        }
        return null;
    }

    @Nullable
    public IRenderer getRenderer(class_1799 stack) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof ICustomRenderer)) continue;
            ICustomRenderer customRenderer = (ICustomRenderer)component;
            return customRenderer.getRenderer();
        }
        return null;
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IItemLifeCycle)) continue;
            IItemLifeCycle lifeCycle = (IItemLifeCycle)component;
            lifeCycle.inventoryTick(stack, level, entity, slotId, isSelected);
        }
    }

    public List<IItemComponent> getComponents() {
        return this.components;
    }
}

