/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.common.item.CoverPlaceBehavior;
import com.lowdragmc.lowdraglib.client.scene.ISceneBlockRenderHook;
import com.lowdragmc.lowdraglib.gui.animation.Animation;
import com.lowdragmc.lowdraglib.gui.animation.Transform;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class CoverContainerConfigurator
extends WidgetGroup {
    protected final ICoverable coverable;
    protected final ItemStackTransfer transfer;
    protected SceneWidget sceneWidget;
    protected SlotWidget slotWidget;
    protected ImageWidget background;
    @Nullable
    protected class_2350 side;
    @Nullable
    protected CoverBehavior coverBehavior;
    @Nullable
    protected Widget coverConfigurator;
    private boolean needUpdate;

    public CoverContainerConfigurator(ICoverable coverable) {
        super(0, 0, 120, 80);
        this.coverable = coverable;
        this.transfer = new ItemStackTransfer(){

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
        this.transfer.setFilter(itemStack -> itemStack.method_7960() || this.side != null && CoverPlaceBehavior.isCoverBehaviorItem(itemStack, () -> false, coverDef -> ICoverable.canPlaceCover(coverDef, this.coverable)));
    }

    public void initWidget() {
        super.initWidget();
        this.background = new ImageWidget(0, 0, 120, 80, (IGuiTexture)GuiTextures.BACKGROUND_INVERSE);
        this.addWidget((Widget)this.background);
        this.sceneWidget = new SceneWidget(4, 4, 112, 72, this.coverable.getLevel()).setRenderedCore(List.of(this.coverable.getPos()), null).setRenderSelect(false).setOnSelected(this::onSideSelected);
        if (this.isRemote()) {
            this.sceneWidget.getRenderer().addRenderedBlocks(List.of(this.coverable.getPos().method_10084(), this.coverable.getPos().method_10074(), this.coverable.getPos().method_10095(), this.coverable.getPos().method_10072(), this.coverable.getPos().method_10078(), this.coverable.getPos().method_10067()), new ISceneBlockRenderHook(){

                @Environment(value=EnvType.CLIENT)
                public void apply(boolean isTESR, class_1921 layer) {
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
                }
            });
            class_241 playerRotation = this.gui.entityPlayer.method_5802();
            this.sceneWidget.setCameraYawAndPitch(playerRotation.field_1343, playerRotation.field_1342 - 90.0f);
        }
        this.addWidget(this.sceneWidget.setBackground(new IGuiTexture[]{ColorPattern.BLACK.rectTexture()}));
        this.slotWidget = new SlotWidget((IItemTransfer)this.transfer, 0, 4, 58).setChangeListener(this::coverRemoved).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.FILTER_SLOT_OVERLAY}));
        this.addWidget((Widget)this.slotWidget);
        this.slotWidget.setVisible(false);
        this.slotWidget.setActive(false);
    }

    private void coverRemoved() {
        class_1657 class_16572 = this.getGui().entityPlayer;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            if (this.side != null) {
                Object object;
                class_1799 item = this.transfer.getStackInSlot(0);
                if (this.coverable.getCoverAtSide(this.side) != null) {
                    this.coverable.removeCover(false, this.side, (class_1657)serverPlayer);
                }
                if (!item.method_7960() && this.coverable.getCoverAtSide(this.side) == null && (object = item.method_7909()) instanceof ComponentItem) {
                    ComponentItem componentItem = (ComponentItem)object;
                    for (IItemComponent component : componentItem.getComponents()) {
                        if (!(component instanceof CoverPlaceBehavior)) continue;
                        CoverPlaceBehavior placeBehavior = (CoverPlaceBehavior)component;
                        this.coverable.placeCoverOnSide(this.side, item, placeBehavior.coverDefinition(), serverPlayer);
                    }
                }
            }
        }
    }

    private void onSideSelected(class_2338 blockPos, class_2350 direction) {
        if (blockPos.equals((Object)this.coverable.getPos()) && this.side != direction) {
            this.side = direction;
            this.slotWidget.setActive(true);
            this.slotWidget.setVisible(true);
            this.checkCoverBehaviour();
        }
    }

    public boolean checkCoverBehaviour() {
        CoverBehavior coverBehaviour;
        if (this.side != null && (coverBehaviour = this.coverable.getCoverAtSide(this.side)) != this.coverBehavior) {
            this.coverBehavior = coverBehaviour;
            class_1799 attachItem = coverBehaviour == null ? class_1799.field_8037 : coverBehaviour.getAttachItem();
            this.transfer.setStackInSlot(0, attachItem);
            this.transfer.onContentsChanged(0);
            this.updateCoverConfigurator();
            return true;
        }
        return false;
    }

    public void updateScreen() {
        super.updateScreen();
        if (this.side != null && this.checkCoverBehaviour()) {
            this.writeClientAction(-2, buf -> {});
        }
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.side != null && this.needUpdate && this.checkCoverBehaviour()) {
            this.needUpdate = false;
        }
    }

    public void handleClientAction(int id, class_2540 buffer) {
        if (id == -2) {
            this.needUpdate = true;
        } else {
            super.handleClientAction(id, buffer);
        }
    }

    protected void updateCoverConfigurator() {
        CoverBehavior coverBehavior;
        if (this.coverConfigurator != null) {
            this.removeWidgetAnima(this.coverConfigurator, new Transform().offset(-this.coverConfigurator.getSize().width / 2, -this.coverConfigurator.getSize().height / 2).scale(0.0f).duration(300L));
            this.coverConfigurator = null;
            this.sceneWidget.animation(new Animation().duration(300L).size(new Size(112, 72)));
            this.setSize(new Size(120, 80));
            this.background.animation(new Animation().duration(300L).size(this.getSize()));
        }
        if (this.side != null && (coverBehavior = this.coverable.getCoverAtSide(this.side)) instanceof IUICover) {
            IUICover iuiCover = (IUICover)((Object)coverBehavior);
            this.coverConfigurator = iuiCover.createUIWidget();
            this.coverConfigurator.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND});
            this.coverConfigurator.setSelfPosition(new Position(4, 76));
            this.addWidgetAnima(this.coverConfigurator, new Transform().offset(-this.coverConfigurator.getSize().width / 2, -this.coverConfigurator.getSize().height / 2).scale(0.0f).duration(300L));
            this.sceneWidget.animation(new Animation().duration(300L).size(new Size(Math.max(120, this.coverConfigurator.getSize().width + 8) - 8, 72)));
            this.setSize(new Size(Math.max(120, this.coverConfigurator.getSize().width + 8), Math.max(80, 80 + this.coverConfigurator.getSize().height)));
            this.background.animation(new Animation().duration(300L).size(this.getSize()));
        }
    }
}

