/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.misc;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidVeinSavedData;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.FluidVeinWorldEntry;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.BedrockOreVeinSavedData;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.OreVeinWorldEntry;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.apache.commons.lang3.ArrayUtils;

public abstract class ProspectorMode<T> {
    public static ProspectorMode<String> ORE = new ProspectorMode<String>("metaitem.prospector.mode.ores", 16){
        private final Map<class_2680, String> BLOCK_CACHE = new HashMap<class_2680, String>();
        private final Map<String, IGuiTexture> ICON_CACHE = new HashMap<String, IGuiTexture>();

        public void scan(String[][][] storage, class_2818 chunk) {
            class_2338.class_2339 pos = new class_2338.class_2339();
            class_6862<class_2248> oreTag = TagUtil.createBlockTag("ores");
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = chunk.method_31600() - 1; y >= chunk.method_31607(); --y) {
                        pos.method_10103(x, y, z);
                        class_2680 state = chunk.method_8320((class_2338)pos);
                        if (!state.method_26164(oreTag)) continue;
                        String itemName = this.BLOCK_CACHE.computeIfAbsent(state, blockState -> {
                            Object name = class_7923.field_41175.method_10221((Object)blockState.method_26204()).toString();
                            UnificationEntry entry = ChemicalHelper.getOrComputeUnificationEntry((class_1935)blockState.method_26204());
                            if (entry != null && entry.material != null) {
                                name = "material_" + entry.material.getName();
                            }
                            return name;
                        });
                        storage[x][z] = (String[])ArrayUtils.add((Object[])storage[x][z], (Object)itemName);
                    }
                }
            }
        }

        @Override
        public int getItemColor(String item) {
            Material mat;
            if (item.startsWith("material_") && (mat = GTMaterials.get(item.substring(9))) != null) {
                return mat.getMaterialRGB();
            }
            return ((class_2248)class_7923.field_41175.method_10223((class_2960)new class_2960((String)item))).method_26403().field_16011;
        }

        @Override
        public IGuiTexture getItemIcon(String item) {
            return this.ICON_CACHE.computeIfAbsent(item, name -> {
                Material mat;
                if (name.startsWith("material_") && (mat = GTMaterials.get(name.substring(9))) != null) {
                    ArrayList<class_1799> list = new ArrayList<class_1799>();
                    for (TagPrefix oreTag : TagPrefix.ORES.keySet()) {
                        for (class_2248 block : ChemicalHelper.getBlocks(new UnificationEntry(oreTag, mat))) {
                            list.add(new class_1799((class_1935)block));
                        }
                    }
                    return new ItemStackTexture((class_1799[])list.toArray(class_1799[]::new)).scale(0.8f);
                }
                return new ItemStackTexture(new class_1799[]{new class_1799((class_1935)class_7923.field_41175.method_10223(new class_2960(name)))}).scale(0.8f);
            });
        }

        @Override
        public String getDescriptionId(String item) {
            Material mat;
            if (item.startsWith("material_") && (mat = GTMaterials.get(item.substring(9))) != null) {
                return mat.getUnlocalizedName();
            }
            return ((class_2248)class_7923.field_41175.method_10223(new class_2960(item))).method_9539();
        }

        @Override
        public String getUniqueID(String item) {
            return item;
        }

        @Override
        public void serialize(String item, class_2540 buf) {
            buf.method_10814(item);
        }

        @Override
        public String deserialize(class_2540 buf) {
            return buf.method_19772();
        }

        @Override
        public Class<String> getItemClass() {
            return String.class;
        }

        @Override
        public void appendTooltips(List<String[]> items, List<class_2561> tooltips, String selected) {
            HashMap<String, Integer> counter = new HashMap<String, Integer>();
            for (String[] array : items) {
                for (String item2 : array) {
                    if (!"[all]".equals(selected) && !selected.equals(this.getUniqueID(item2))) continue;
                    counter.put(item2, counter.getOrDefault(item2, 0) + 1);
                }
            }
            counter.forEach((item, count) -> tooltips.add((class_2561)class_2561.method_43471((String)this.getDescriptionId((String)item)).method_27693(" --- " + count)));
        }
    };
    public static ProspectorMode<FluidInfo> FLUID = new ProspectorMode<FluidInfo>("metaitem.prospector.mode.fluid", 1){

        public void scan(FluidInfo[][][] storage, class_2818 chunk) {
            class_3218 serverLevel;
            FluidVeinWorldEntry fluidVein;
            class_1937 class_19372 = chunk.method_12200();
            if (class_19372 instanceof class_3218 && (fluidVein = BedrockFluidVeinSavedData.getOrCreate(serverLevel = (class_3218)class_19372).getFluidVeinWorldEntry(chunk.method_12004().field_9181, chunk.method_12004().field_9180)).getDefinition() != null) {
                int left = 100 * fluidVein.getOperationsRemaining() / 100000;
                storage[0][0] = new FluidInfo[]{new FluidInfo(fluidVein.getDefinition().getStoredFluid().get(), left, fluidVein.getFluidYield())};
            }
        }

        @Override
        public int getItemColor(FluidInfo item) {
            FluidStack fluidStack = FluidStack.create((class_3611)item.fluid, (long)item.yield);
            if (fluidStack.getFluid() == class_3612.field_15908) {
                return -36864;
            }
            return FluidHelper.getColor((FluidStack)fluidStack);
        }

        @Override
        public IGuiTexture getItemIcon(FluidInfo item) {
            return new ItemStackTexture(new class_1792[]{item.fluid.method_15774()});
        }

        @Override
        public String getDescriptionId(FluidInfo item) {
            return FluidStack.create((class_3611)item.fluid, (long)item.yield).getDisplayName().getString();
        }

        @Override
        public String getUniqueID(FluidInfo item) {
            return class_7923.field_41173.method_10221((Object)item.fluid).toString();
        }

        @Override
        public void serialize(FluidInfo item, class_2540 buf) {
            buf.method_10814(class_7923.field_41173.method_10221((Object)item.fluid).toString());
            buf.method_10804(item.left);
            buf.method_10804(item.yield);
        }

        @Override
        public FluidInfo deserialize(class_2540 buf) {
            return new FluidInfo((class_3611)class_7923.field_41173.method_10223(new class_2960(buf.method_19772())), buf.method_10816(), buf.method_10816());
        }

        @Override
        public Class<FluidInfo> getItemClass() {
            return FluidInfo.class;
        }

        @Override
        public void appendTooltips(List<FluidInfo[]> items, List<class_2561> tooltips, String selected) {
            for (FluidInfo[] array : items) {
                for (FluidInfo item : array) {
                    tooltips.add((class_2561)class_2561.method_43471((String)this.getDescriptionId(item)).method_27693(" --- %s (%s%%)".formatted(item.yield, item.left)));
                }
            }
        }

        @Environment(value=EnvType.CLIENT)
        public void drawSpecialGrid(class_332 graphics, FluidInfo[] items, int x, int y, int width, int height) {
            if (items.length > 0) {
                FluidInfo item = items[0];
                double progress = (double)item.left * 1.0 / (double)Math.max(Math.min(item.left, 100), 1);
                float drawnU = (float)ProgressTexture.FillDirection.DOWN_TO_UP.getDrawnU(progress);
                float drawnV = (float)ProgressTexture.FillDirection.DOWN_TO_UP.getDrawnV(progress);
                float drawnWidth = (float)ProgressTexture.FillDirection.DOWN_TO_UP.getDrawnWidth(progress);
                float drawnHeight = (float)ProgressTexture.FillDirection.DOWN_TO_UP.getDrawnHeight(progress);
                DrawerHelper.drawFluidForGui((class_332)graphics, (FluidStack)FluidStack.create((class_3611)item.fluid(), (long)item.left), (long)100L, (int)((int)((float)x + drawnU * (float)width)), (int)((int)((float)y + drawnV * (float)height)), (int)((int)((float)width * drawnWidth)), (int)((int)((float)height * drawnHeight)));
            }
        }
    };
    public static ProspectorMode<OreInfo> BEDROCK_ORE = new ProspectorMode<OreInfo>("metaitem.prospector.mode.bedrock_ore", 1){

        public void scan(OreInfo[][][] storage, class_2818 chunk) {
            class_3218 serverLevel;
            OreVeinWorldEntry oreVein;
            class_1937 class_19372 = chunk.method_12200();
            if (class_19372 instanceof class_3218 && (oreVein = BedrockOreVeinSavedData.getOrCreate(serverLevel = (class_3218)class_19372).getOreVeinWorldEntry(chunk.method_12004().field_9181, chunk.method_12004().field_9180)).getDefinition() != null) {
                int left = 100 * oreVein.getOperationsRemaining() / 100000;
                for (Map.Entry<Integer, Material> entry : oreVein.getDefinition().getBedrockVeinMaterials()) {
                    storage[0][0] = (OreInfo[])ArrayUtils.add((Object[])storage[0][0], (Object)new OreInfo(entry.getValue(), entry.getKey(), left, oreVein.getOreYield()));
                }
            }
        }

        @Override
        public int getItemColor(OreInfo item) {
            return item.material.getMaterialRGB();
        }

        @Override
        public IGuiTexture getItemIcon(OreInfo item) {
            Material material = item.material;
            class_1799 stack = ChemicalHelper.get(TagPrefix.get(ConfigHolder.INSTANCE.machines.bedrockOreDropTagPrefix), material);
            if (stack.method_7960()) {
                stack = ChemicalHelper.get(TagPrefix.crushed, material);
            }
            if (stack.method_7960()) {
                stack = ChemicalHelper.get(TagPrefix.gem, material);
            }
            if (stack.method_7960()) {
                stack = ChemicalHelper.get(TagPrefix.ore, material);
            }
            return new ItemStackTexture(new class_1799[]{stack}).scale(0.8f);
        }

        @Override
        public String getDescriptionId(OreInfo item) {
            return item.material.getUnlocalizedName();
        }

        @Override
        public String getUniqueID(OreInfo item) {
            return item.material.getName();
        }

        @Override
        public void serialize(OreInfo item, class_2540 buf) {
            buf.method_10814((String)GTRegistries.MATERIALS.getKey(item.material));
            buf.method_10804(item.weight);
            buf.method_10804(item.left);
            buf.method_10804(item.yield);
        }

        @Override
        public OreInfo deserialize(class_2540 buf) {
            return new OreInfo((Material)GTRegistries.MATERIALS.get(buf.method_19772()), buf.method_10816(), buf.method_10816(), buf.method_10816());
        }

        @Override
        public Class<OreInfo> getItemClass() {
            return OreInfo.class;
        }

        @Override
        public void appendTooltips(List<OreInfo[]> items, List<class_2561> tooltips, String selected) {
            for (OreInfo[] array : items) {
                int totalWeight = Arrays.stream(array).mapToInt(OreInfo::weight).sum();
                for (OreInfo item : array) {
                    float chance = (float)item.weight / (float)totalWeight * 100.0f;
                    tooltips.add((class_2561)class_2561.method_43471((String)this.getDescriptionId(item)).method_27693(" (").method_10852((class_2561)class_2561.method_43469((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(chance)) + "%"})).method_27693(") --- %s (%s%%)".formatted(item.yield, item.left)));
                }
            }
        }
    };
    public final String unlocalizedName;
    public final int cellSize;

    ProspectorMode(@Nonnull String unlocalizedName, int cellSize) {
        this.unlocalizedName = unlocalizedName;
        this.cellSize = cellSize;
    }

    public abstract void scan(T[][][] var1, class_2818 var2);

    public abstract int getItemColor(T var1);

    public abstract IGuiTexture getItemIcon(T var1);

    public abstract String getDescriptionId(T var1);

    public abstract String getUniqueID(T var1);

    public abstract void serialize(T var1, class_2540 var2);

    public abstract T deserialize(class_2540 var1);

    public abstract Class<T> getItemClass();

    public abstract void appendTooltips(List<T[]> var1, List<class_2561> var2, String var3);

    @Environment(value=EnvType.CLIENT)
    public void drawSpecialGrid(class_332 graphics, T[] items, int x, int y, int width, int height) {
    }

    public record OreInfo(Material material, int weight, int left, int yield) {
    }

    public record FluidInfo(class_3611 fluid, int left, int yield) {
    }
}

