/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.ores;

import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedIndicators;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVein;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreGenCache;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2826;
import net.minecraft.class_3825;
import net.minecraft.class_4076;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5867;
import net.minecraft.class_6328;
import net.minecraft.class_6677;

@class_6328
@ParametersAreNonnullByDefault
public class OrePlacer {
    private final OreGenCache oreGenCache = new OreGenCache();

    public void placeOres(class_5281 level, class_2794 chunkGenerator, class_2791 chunk) {
        class_6677 random = new class_6677(level.method_8412() ^ chunk.method_12004().method_8324());
        List<GeneratedVein> generatedVeins = this.oreGenCache.consumeChunkVeins(level, chunkGenerator, chunk);
        List<GeneratedIndicators> generatedIndicators = this.oreGenCache.consumeChunkIndicators(level, chunkGenerator, chunk);
        try (class_5867 access = new class_5867((class_1936)level);){
            generatedVeins.forEach(generatedVein -> this.placeVein(chunk, (class_5819)random, access, (GeneratedVein)generatedVein));
            generatedIndicators.forEach(generatedIndicator -> this.placeIndicators(chunk, access, (GeneratedIndicators)generatedIndicator));
        }
    }

    private void placeVein(class_2791 chunk, class_5819 random, class_5867 access, GeneratedVein generatedVein) {
        class_3825 layerTarget = generatedVein.getLayer().getTarget();
        this.resolvePlacerLists(chunk, generatedVein).forEach((sectionPos, placers) -> {
            class_2826 section = access.method_33944(sectionPos.method_19767());
            if (section == null) {
                return;
            }
            placers.forEach((pos, placer) -> {
                class_2680 blockState = section.method_12254(class_4076.method_18684((int)pos.method_10263()), class_4076.method_18684((int)pos.method_10264()), class_4076.method_18684((int)pos.method_10260()));
                if (layerTarget.method_16768(blockState, random)) {
                    placer.placeBlock(access, section);
                }
            });
        });
    }

    private Map<class_4076, Map<class_2338, OreBlockPlacer>> resolvePlacerLists(class_2791 chunk, GeneratedVein vein) {
        return vein.consumeOres(chunk.method_12004()).entrySet().stream().collect(Collectors.groupingBy(entry -> class_4076.method_18682((class_2338)((class_2338)entry.getKey())), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private void placeIndicators(class_2791 chunk, class_5867 access, GeneratedIndicators generatedVein) {
        generatedVein.consumeIndicators(chunk.method_12004()).forEach(placer -> placer.placeIndicators(access));
    }
}

