/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.ores;

import com.gregtechceu.gtceu.api.data.worldgen.IWorldGenLayer;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_6328;

@class_6328
@ParametersAreNonnullByDefault
public class GeneratedVein {
    private final class_1923 origin;
    private final IWorldGenLayer layer;
    private final Map<class_1923, Map<class_2338, OreBlockPlacer>> generatedOres;

    public GeneratedVein(class_1923 origin, IWorldGenLayer layer, Map<class_2338, OreBlockPlacer> oresByPosition) {
        this.origin = origin;
        this.layer = layer;
        this.generatedOres = WorldGeneratorUtils.groupByChunks(oresByPosition);
    }

    public Map<class_2338, OreBlockPlacer> consumeOres(class_1923 chunk) {
        return this.generatedOres.getOrDefault(chunk, Map.of());
    }

    public String toString() {
        return "GeneratedVein[origin=" + this.origin + ", chunks={" + this.generatedOres.keySet().stream().map(class_1923::toString).collect(Collectors.joining(", ")) + "}]";
    }

    public class_1923 getOrigin() {
        return this.origin;
    }

    public IWorldGenLayer getLayer() {
        return this.layer;
    }
}

