/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator.veins;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreVeinUtil;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTFeatures;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2826;
import net.minecraft.class_3124;
import net.minecraft.class_3233;
import net.minecraft.class_3532;
import net.minecraft.class_3818;
import net.minecraft.class_3825;
import net.minecraft.class_4076;
import net.minecraft.class_5216;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5867;
import net.minecraft.class_6328;
import net.minecraft.class_6677;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_7138;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

@class_6328
@ParametersAreNonnullByDefault
public class VeinedVeinGenerator
extends VeinGenerator {
    public static final Codec<Either<List<class_3124.class_5876>, Material>> BLOCK_ENTRY_CODEC = Codec.either((Codec)class_3124.class_5876.field_29067.listOf(), GTRegistries.MATERIALS.codec());
    public static final Codec<VeinedVeinGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VeinBlockDefinition.CODEC.listOf().fieldOf("ore_blocks").forGetter(it -> it.oreBlocks), (App)VeinBlockDefinition.CODEC.listOf().fieldOf("rare_blocks").forGetter(it -> it.rareBlocks), (App)class_2680.field_24734.fieldOf("filler_block").orElse((Object)class_2246.field_10124.method_9564()).forGetter(it -> it.fillerBlock), (App)Codec.INT.fieldOf("min_y").forGetter(it -> it.minYLevel), (App)Codec.INT.fieldOf("max_y").forGetter(it -> it.maxYLevel), (App)Codec.FLOAT.fieldOf("veininess_threshold").orElse((Object)Float.valueOf(0.4f)).forGetter(it -> Float.valueOf(it.veininessThreshold)), (App)Codec.INT.fieldOf("edge_roundoff_begin").orElse((Object)20).forGetter(it -> it.edgeRoundoffBegin), (App)Codec.DOUBLE.fieldOf("max_edge_roundoff").orElse((Object)0.2).forGetter(it -> it.maxEdgeRoundoff), (App)Codec.FLOAT.fieldOf("min_richness").orElse((Object)Float.valueOf(0.1f)).forGetter(it -> Float.valueOf(it.minRichness)), (App)Codec.FLOAT.fieldOf("max_richness").orElse((Object)Float.valueOf(0.3f)).forGetter(it -> Float.valueOf(it.maxRichness)), (App)Codec.FLOAT.fieldOf("max_richness_threshold").orElse((Object)Float.valueOf(0.6f)).forGetter(it -> Float.valueOf(it.maxRichnessThreshold)), (App)Codec.FLOAT.fieldOf("rare_block_chance").orElse((Object)Float.valueOf(0.02f)).forGetter(it -> Float.valueOf(it.rareBlockChance))).apply((Applicative)instance, VeinedVeinGenerator::new));
    public List<VeinBlockDefinition> oreBlocks;
    public List<VeinBlockDefinition> rareBlocks;
    public class_2680 fillerBlock;
    public int minYLevel;
    public int maxYLevel;
    public float veininessThreshold = 0.4f;
    public int edgeRoundoffBegin = 20;
    public double maxEdgeRoundoff = 0.2;
    public float minRichness = 0.1f;
    public float maxRichness = 0.3f;
    public float maxRichnessThreshold = 0.6f;
    public float rareBlockChance = 0.02f;

    public VeinedVeinGenerator(GTOreDefinition entry) {
        super(entry);
    }

    @Override
    public List<Map.Entry<Either<class_2680, Material>, Integer>> getAllEntries() {
        Stream s1 = this.oreBlocks.stream().flatMap(definition -> (Stream)definition.block.map(state -> state.stream().map(target -> Map.entry(Either.left((Object)target.field_29069), definition.weight)), material -> Stream.of(Map.entry(Either.right((Object)material), definition.weight))));
        Stream s2 = this.rareBlocks == null ? null : this.rareBlocks.stream().flatMap(definition -> (Stream)definition.block.map(state -> state.stream().map(target -> Map.entry(Either.left((Object)target.field_29069), definition.weight)), material -> Stream.of(Map.entry(Either.right((Object)material), definition.weight))));
        return (s2 == null ? s1 : Stream.concat(s1, s2)).collect(Collectors.toList());
    }

    @Override
    public Map<class_2338, OreBlockPlacer> generate(class_5281 level, class_5819 random, GTOreDefinition entry, class_2338 origin) {
        class_6748 blender;
        Object2ObjectOpenHashMap generatedBlocks = new Object2ObjectOpenHashMap();
        class_2378 densityFunctions = (class_2378)GTRegistries.builtinRegistry().method_33310(class_7924.field_41240).get();
        List<Map.Entry> commonEntries = this.oreBlocks.stream().map(b -> Map.entry(b.weight, b)).toList();
        List<Map.Entry> rareEntries = this.rareBlocks == null ? null : this.rareBlocks.stream().map(b -> Map.entry(b.weight, b)).toList();
        class_7138 randomState = level.method_8410().method_14178().method_41248();
        if (level instanceof class_3233) {
            class_3233 region = (class_3233)level;
            blender = class_6748.method_39342((class_3233)region);
        } else {
            blender = class_6748.method_39336();
        }
        final class_6748 finalizedBlender = blender;
        class_6910 veinToggle = VeinedVeinGenerator.mapToNoise((class_6910)densityFunctions.method_10223(GTFeatures.NEW_ORE_VEIN_TOGGLE), randomState);
        class_6910 veinRidged = VeinedVeinGenerator.mapToNoise((class_6910)densityFunctions.method_10223(GTFeatures.NEW_ORE_VEIN_RIDGED), randomState);
        int size = entry.clusterSize();
        int radius = class_3532.method_15386((float)((float)size / 2.0f));
        boolean placedCount = false;
        final int randOffsetX = random.method_43048(16);
        final int randOffsetY = random.method_43048(16);
        final int randOffsetZ = random.method_43048(16);
        class_2338 posMin = origin.method_10069(-radius, -radius, -radius);
        class_2338 posMax = origin.method_10069(radius, radius, radius);
        for (class_2338 chunkedPos : class_2338.method_10097((class_2338)posMin, (class_2338)posMax)) {
            int lowY;
            double edgeRoundoff;
            final int x = chunkedPos.method_10263();
            final int y = chunkedPos.method_10264();
            final int z = chunkedPos.method_10260();
            class_6910.class_6912 functionContext = new class_6910.class_6912(){

                public int comp_371() {
                    return x + randOffsetX;
                }

                public int comp_372() {
                    return y + randOffsetY;
                }

                public int comp_373() {
                    return z + randOffsetZ;
                }

                public class_6748 method_39327() {
                    return finalizedBlender;
                }
            };
            double toggleNoise = veinToggle.method_40464(functionContext);
            int blockY = origin.method_10264();
            double absToggleNoise = Math.abs(toggleNoise);
            int minY = blockY - this.minYLevel;
            int maxY = this.maxYLevel - blockY;
            if (minY < 0 || maxY < 0 || absToggleNoise + (edgeRoundoff = class_3532.method_32854((double)(lowY = Math.min(maxY, minY)), (double)0.0, (double)this.edgeRoundoffBegin, (double)(-this.maxEdgeRoundoff), (double)0.0)) < (double)this.veininessThreshold || random.method_43057() > entry.density() || veinRidged.method_40464(functionContext) >= 0.0) continue;
            double chance = class_3532.method_32854((double)absToggleNoise, (double)this.veininessThreshold, (double)this.maxRichnessThreshold, (double)this.minRichness, (double)this.maxRichness);
            class_2338.class_2339 pos = new class_2338.class_2339(x, y, z);
            long randomSeed = random.method_43055();
            generatedBlocks.put(pos, (access, section) -> this.placeBlock(access, section, randomSeed, entry, chance, rareEntries, pos, commonEntries));
        }
        return generatedBlocks;
    }

    @Nullable
    private void placeBlock(class_5867 access, class_2826 section, long randomSeed, GTOreDefinition entry, double chance, List<? extends Map.Entry<Integer, VeinBlockDefinition>> rareEntries, class_2338.class_2339 pos, List<? extends Map.Entry<Integer, VeinBlockDefinition>> commonEntries) {
        class_6677 random = new class_6677(randomSeed);
        int sectionX = class_4076.method_18684((int)pos.method_10263());
        int sectionY = class_4076.method_18684((int)pos.method_10264());
        int sectionZ = class_4076.method_18684((int)pos.method_10260());
        class_2680 current = section.method_12254(sectionX, sectionY, sectionZ);
        if (random.method_43057() <= entry.density()) {
            if ((double)random.method_43057() < chance) {
                if (this.rareBlocks != null && !this.rareBlocks.isEmpty() && random.method_43057() < this.rareBlockChance) {
                    VeinedVeinGenerator.placeOre(this.rareBlocks.get((int)GTUtil.getRandomItem((class_5819)random, rareEntries, (int)rareEntries.size())).block, current, access, section, (class_5819)random, pos, entry);
                } else {
                    VeinedVeinGenerator.placeOre(this.oreBlocks.get((int)GTUtil.getRandomItem((class_5819)random, commonEntries, (int)commonEntries.size())).block, current, access, section, (class_5819)random, pos, entry);
                }
            } else {
                if (this.fillerBlock == null || this.fillerBlock.method_26215()) {
                    return;
                }
                if (!OreVeinUtil.canPlaceOre(current, arg_0 -> ((class_5867)access).method_33946(arg_0), (class_5819)random, entry, pos)) {
                    return;
                }
                section.method_12256(sectionX, sectionY, sectionZ, this.fillerBlock, false);
            }
        }
    }

    protected static void placeOre(Either<List<class_3124.class_5876>, Material> block, class_2680 current, class_5867 level, class_2826 section, class_5819 random, class_2338.class_2339 pos, GTOreDefinition entry) {
        int x = class_4076.method_18684((int)pos.method_10263());
        int y = class_4076.method_18684((int)pos.method_10264());
        int z = class_4076.method_18684((int)pos.method_10260());
        block.ifLeft(blockStates -> {
            for (class_3124.class_5876 targetState : blockStates) {
                if (!OreVeinUtil.canPlaceOre(current, arg_0 -> ((class_5867)level).method_33946(arg_0), random, entry, targetState, pos) || targetState.field_29069.method_26215()) continue;
                section.method_12256(x, y, z, targetState.field_29069, false);
                break;
            }
        }).ifRight(material -> {
            if (!OreVeinUtil.canPlaceOre(current, arg_0 -> ((class_5867)level).method_33946(arg_0), random, entry, pos)) {
                return;
            }
            class_2680 currentState = level.method_33946((class_2338)pos);
            Optional<TagPrefix> prefix = ChemicalHelper.getOrePrefix(currentState);
            if (prefix.isEmpty()) {
                return;
            }
            class_2248 toPlace = ChemicalHelper.getBlock(prefix.get(), material);
            if (toPlace == null || toPlace.method_9564().method_26215()) {
                return;
            }
            section.method_12256(x, y, z, toPlace.method_9564(), false);
        });
    }

    @Override
    public VeinGenerator build() {
        return this;
    }

    @Override
    public VeinGenerator copy() {
        return new VeinedVeinGenerator(this.oreBlocks, this.rareBlocks, this.fillerBlock, this.minYLevel, this.maxYLevel, this.veininessThreshold, this.edgeRoundoffBegin, this.maxEdgeRoundoff, this.minRichness, this.maxRichness, this.maxRichnessThreshold, this.rareBlockChance);
    }

    @Override
    public Codec<? extends VeinGenerator> codec() {
        return CODEC;
    }

    public VeinedVeinGenerator oreBlock(Material block, int weight) {
        return this.oreBlock(new VeinBlockDefinition(block, weight));
    }

    public VeinedVeinGenerator oreBlock(class_2680 blockState, int weight) {
        class_3124.class_5876 target = class_3124.method_33994((class_3825)class_3818.field_16868, (class_2680)blockState);
        return this.oreBlock(new VeinBlockDefinition(List.of(target), weight));
    }

    public VeinedVeinGenerator oreBlock(VeinBlockDefinition material) {
        if (this.oreBlocks == null) {
            this.oreBlocks = new ArrayList<VeinBlockDefinition>();
        }
        this.oreBlocks.add(material);
        return this;
    }

    public VeinedVeinGenerator rareBlock(Material block, int weight) {
        return this.rareBlock(new VeinBlockDefinition(block, weight));
    }

    public VeinedVeinGenerator rareBlock(class_2680 blockState, int weight) {
        class_3124.class_5876 target = class_3124.method_33994((class_3825)class_3818.field_16868, (class_2680)blockState);
        return this.rareBlock(new VeinBlockDefinition(List.of(target), weight));
    }

    public VeinedVeinGenerator rareBlock(VeinBlockDefinition material) {
        if (this.rareBlocks == null) {
            this.rareBlocks = new ArrayList<VeinBlockDefinition>();
        }
        this.rareBlocks.add(material);
        return this;
    }

    private static class_6910 mapToNoise(class_6910 function, final class_7138 randomState) {
        return function.method_40469(new class_6910.class_6915(){

            public class_6910 apply(class_6910 densityFunction) {
                return densityFunction;
            }

            public class_6910.class_7270 method_42358(class_6910.class_7270 noiseHolder) {
                class_6880 holder = noiseHolder.comp_662();
                class_5216 noise = randomState.method_41558((class_5321)holder.method_40230().orElseThrow());
                return new class_6910.class_7270(holder, noise);
            }
        });
    }

    public VeinedVeinGenerator(List<VeinBlockDefinition> oreBlocks, List<VeinBlockDefinition> rareBlocks, class_2680 fillerBlock, int minYLevel, int maxYLevel, float veininessThreshold, int edgeRoundoffBegin, double maxEdgeRoundoff, float minRichness, float maxRichness, float maxRichnessThreshold, float rareBlockChance) {
        this.oreBlocks = oreBlocks;
        this.rareBlocks = rareBlocks;
        this.fillerBlock = fillerBlock;
        this.minYLevel = minYLevel;
        this.maxYLevel = maxYLevel;
        this.veininessThreshold = veininessThreshold;
        this.edgeRoundoffBegin = edgeRoundoffBegin;
        this.maxEdgeRoundoff = maxEdgeRoundoff;
        this.minRichness = minRichness;
        this.maxRichness = maxRichness;
        this.maxRichnessThreshold = maxRichnessThreshold;
        this.rareBlockChance = rareBlockChance;
    }

    public VeinedVeinGenerator fillerBlock(class_2680 fillerBlock) {
        this.fillerBlock = fillerBlock;
        return this;
    }

    public VeinedVeinGenerator minYLevel(int minYLevel) {
        this.minYLevel = minYLevel;
        return this;
    }

    public VeinedVeinGenerator maxYLevel(int maxYLevel) {
        this.maxYLevel = maxYLevel;
        return this;
    }

    public VeinedVeinGenerator veininessThreshold(float veininessThreshold) {
        this.veininessThreshold = veininessThreshold;
        return this;
    }

    public VeinedVeinGenerator edgeRoundoffBegin(int edgeRoundoffBegin) {
        this.edgeRoundoffBegin = edgeRoundoffBegin;
        return this;
    }

    public VeinedVeinGenerator maxEdgeRoundoff(double maxEdgeRoundoff) {
        this.maxEdgeRoundoff = maxEdgeRoundoff;
        return this;
    }

    public VeinedVeinGenerator minRichness(float minRichness) {
        this.minRichness = minRichness;
        return this;
    }

    public VeinedVeinGenerator maxRichness(float maxRichness) {
        this.maxRichness = maxRichness;
        return this;
    }

    public VeinedVeinGenerator maxRichnessThreshold(float maxRichnessThreshold) {
        this.maxRichnessThreshold = maxRichnessThreshold;
        return this;
    }

    public VeinedVeinGenerator rareBlockChance(float rareBlockChance) {
        this.rareBlockChance = rareBlockChance;
        return this;
    }

    public record VeinBlockDefinition(Either<List<class_3124.class_5876>, Material> block, int weight) {
        public static final Codec<VeinBlockDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BLOCK_ENTRY_CODEC.fieldOf("block").forGetter(x -> x.block), (App)Codec.INT.fieldOf("weight").forGetter(x -> x.weight)).apply((Applicative)instance, VeinBlockDefinition::new));

        public VeinBlockDefinition(Material block, int weight) {
            this((Either<List<class_3124.class_5876>, Material>)Either.right((Object)block), weight);
        }

        public VeinBlockDefinition(List<class_3124.class_5876> block, int weight) {
            this((Either<List<class_3124.class_5876>, Material>)Either.left(block), weight);
        }
    }
}

