/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid;

import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class FluidVeinWorldEntry {
    @Nullable
    private BedrockFluidDefinition vein;
    private int fluidYield;
    private int operationsRemaining;

    public FluidVeinWorldEntry(@Nullable BedrockFluidDefinition vein, int fluidYield, int operationsRemaining) {
        this.vein = vein;
        this.fluidYield = fluidYield;
        this.operationsRemaining = operationsRemaining;
    }

    private FluidVeinWorldEntry() {
    }

    public BedrockFluidDefinition getDefinition() {
        return this.vein;
    }

    public void setOperationsRemaining(int amount) {
        this.operationsRemaining = amount;
    }

    public void decreaseOperations(int amount) {
        this.operationsRemaining = ConfigHolder.INSTANCE.worldgen.oreVeins.infiniteBedrockOresFluids ? this.operationsRemaining : Math.max(0, this.operationsRemaining - amount);
    }

    public class_2487 writeToNBT() {
        class_2487 tag = new class_2487();
        tag.method_10569("fluidYield", this.fluidYield);
        tag.method_10569("operationsRemaining", this.operationsRemaining);
        if (this.vein != null) {
            tag.method_10582("vein", ((class_2960)GTRegistries.BEDROCK_FLUID_DEFINITIONS.getKey(this.vein)).toString());
        }
        return tag;
    }

    @Nonnull
    public static FluidVeinWorldEntry readFromNBT(@Nonnull class_2487 tag) {
        FluidVeinWorldEntry info = new FluidVeinWorldEntry();
        info.fluidYield = tag.method_10550("fluidYield");
        info.operationsRemaining = tag.method_10550("operationsRemaining");
        if (tag.method_10545("vein")) {
            info.vein = (BedrockFluidDefinition)GTRegistries.BEDROCK_FLUID_DEFINITIONS.get(new class_2960(tag.method_10558("vein")));
        }
        return info;
    }

    @Nullable
    public BedrockFluidDefinition getVein() {
        return this.vein;
    }

    public int getFluidYield() {
        return this.fluidYield;
    }

    public int getOperationsRemaining() {
        return this.operationsRemaining;
    }
}

