/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.FluidVeinWorldEntry;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6328;
import net.minecraft.class_6880;

@ParametersAreNonnullByDefault
@class_6328
public class BedrockFluidVeinSavedData
extends class_18 {
    public static final int VEIN_CHUNK_SIZE = 8;
    public static final int MAXIMUM_VEIN_OPERATIONS = 100000;
    public final HashMap<class_1923, FluidVeinWorldEntry> veinFluids = new HashMap();
    private final HashMap<class_6880<class_1959>, Integer> biomeWeights = new HashMap();
    private final class_3218 serverLevel;

    public static BedrockFluidVeinSavedData getOrCreate(class_3218 serverLevel) {
        return (BedrockFluidVeinSavedData)serverLevel.method_17983().method_17924(tag -> new BedrockFluidVeinSavedData(serverLevel, (class_2487)tag), () -> new BedrockFluidVeinSavedData(serverLevel), "gtceu_bedrock_fluid");
    }

    public BedrockFluidVeinSavedData(class_3218 serverLevel) {
        this.serverLevel = serverLevel;
    }

    public BedrockFluidVeinSavedData(class_3218 serverLevel, class_2487 nbt) {
        this(serverLevel);
        class_2499 list = nbt.method_10554("veinInfo", 10);
        for (class_2520 tag : list) {
            if (!(tag instanceof class_2487)) continue;
            class_2487 compoundTag = (class_2487)tag;
            class_1923 chunkPos = new class_1923(compoundTag.method_10537("p"));
            this.veinFluids.put(chunkPos, FluidVeinWorldEntry.readFromNBT(compoundTag.method_10562("d")));
        }
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 oilList = new class_2499();
        for (Map.Entry<class_1923, FluidVeinWorldEntry> entry : this.veinFluids.entrySet()) {
            class_2487 tag = new class_2487();
            tag.method_10544("p", entry.getKey().method_8324());
            tag.method_10566("d", (class_2520)entry.getValue().writeToNBT());
            oilList.add((Object)tag);
        }
        nbt.method_10566("veinInfo", (class_2520)oilList);
        return nbt;
    }

    public FluidVeinWorldEntry getFluidVeinWorldEntry(int chunkX, int chunkZ) {
        if (!this.veinFluids.containsKey(new class_1923(chunkX, chunkZ))) {
            BedrockFluidDefinition definition = null;
            int query = class_5819.method_43049((long)Objects.hash(this.serverLevel.method_8412(), chunkX / 8, chunkZ / 8)).method_43054();
            class_6880 biome = this.serverLevel.method_23753(new class_2338(chunkX << 4, 64, chunkZ << 4));
            int totalWeight = this.getTotalWeight((class_6880<class_1959>)biome);
            if (totalWeight > 0) {
                int weight = Math.abs(query % totalWeight);
                for (BedrockFluidDefinition fluidDefinition : GTRegistries.BEDROCK_FLUID_DEFINITIONS) {
                    int veinWeight = fluidDefinition.getWeight() + fluidDefinition.getBiomeWeightModifier().apply((class_6880<class_1959>)biome);
                    if (veinWeight <= 0 || fluidDefinition.getDimensionFilter() != null && !fluidDefinition.getDimensionFilter().stream().anyMatch(dim -> WorldGeneratorUtils.isSameDimension((class_5321<class_1937>)dim, (class_5321<class_1937>)this.serverLevel.method_27983())) || (weight -= veinWeight) >= 0) continue;
                    definition = fluidDefinition;
                    break;
                }
            }
            class_5819 random = class_5819.method_43049((long)(961L * (long)chunkX + (long)chunkZ * 31L + (long)Long.hashCode(this.serverLevel.method_8412())));
            int maximumYield = 0;
            if (definition != null) {
                maximumYield = definition.getMaximumYield() - definition.getMinimumYield() <= 0 ? definition.getMinimumYield() : random.method_43048(definition.getMaximumYield() - definition.getMinimumYield()) + definition.getMinimumYield();
                maximumYield = Math.min(maximumYield, definition.getMaximumYield());
            }
            this.veinFluids.put(new class_1923(chunkX, chunkZ), new FluidVeinWorldEntry(definition, maximumYield, 100000));
            this.method_80();
        }
        return this.veinFluids.get(new class_1923(chunkX, chunkZ));
    }

    public int getTotalWeight(class_6880<class_1959> biome) {
        return this.biomeWeights.computeIfAbsent(biome, b -> {
            int totalWeight = 0;
            for (BedrockFluidDefinition definition : GTRegistries.BEDROCK_FLUID_DEFINITIONS) {
                if (definition.getDimensionFilter() != null && !definition.getDimensionFilter().stream().anyMatch(dim -> WorldGeneratorUtils.isSameDimension((class_5321<class_1937>)dim, (class_5321<class_1937>)this.serverLevel.method_27983()))) continue;
                totalWeight += definition.getBiomeWeightModifier().apply(biome).intValue();
                totalWeight += definition.getWeight();
            }
            return totalWeight;
        });
    }

    public int getFluidYield(int chunkX, int chunkZ) {
        return this.getFluidVeinWorldEntry(chunkX, chunkZ).getFluidYield();
    }

    public int getDepletedFluidYield(int chunkX, int chunkZ) {
        FluidVeinWorldEntry info = this.getFluidVeinWorldEntry(chunkX, chunkZ);
        if (info.getDefinition() == null) {
            return 0;
        }
        return info.getDefinition().getDepletedYield();
    }

    public int getOperationsRemaining(int chunkX, int chunkZ) {
        return this.getFluidVeinWorldEntry(chunkX, chunkZ).getOperationsRemaining();
    }

    @Nullable
    public class_3611 getFluidInChunk(int chunkX, int chunkZ) {
        FluidVeinWorldEntry info = this.getFluidVeinWorldEntry(chunkX, chunkZ);
        if (info.getDefinition() == null) {
            return null;
        }
        return info.getDefinition().getStoredFluid().get();
    }

    public void depleteVein(int chunkX, int chunkZ, int amount, boolean ignoreVeinStats) {
        FluidVeinWorldEntry info = this.getFluidVeinWorldEntry(chunkX, chunkZ);
        if (ignoreVeinStats) {
            info.decreaseOperations(amount);
            if (amount != 0) {
                this.method_80();
            }
            return;
        }
        BedrockFluidDefinition definition = info.getDefinition();
        if (definition == null || definition.getDepletionChance() == 0) {
            return;
        }
        if (definition.getDepletionChance() == 100 || GTValues.RNG.method_43048(100) <= definition.getDepletionChance()) {
            info.decreaseOperations(definition.getDepletionAmount());
            this.method_80();
        }
    }
}

