/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.properties;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.MaterialProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import javax.annotation.Nullable;

public class IngotProperty
implements IMaterialProperty<IngotProperty> {
    private Material smeltingInto;
    private Material arcSmeltingInto;
    private Material macerateInto;
    @Nullable
    private Material magneticMaterial;

    @Override
    public void verifyProperty(MaterialProperties properties) {
        properties.ensureSet(PropertyKey.DUST, true);
        if (properties.hasProperty(PropertyKey.GEM)) {
            throw new IllegalStateException("Material " + properties.getMaterial() + " has both Ingot and Gem Property, which is not allowed!");
        }
        if (this.smeltingInto == null) {
            this.smeltingInto = properties.getMaterial();
        } else {
            this.smeltingInto.getProperties().ensureSet(PropertyKey.INGOT, true);
        }
        if (this.arcSmeltingInto == null) {
            this.arcSmeltingInto = properties.getMaterial();
        } else {
            this.arcSmeltingInto.getProperties().ensureSet(PropertyKey.INGOT, true);
        }
        if (this.macerateInto == null) {
            this.macerateInto = properties.getMaterial();
        } else {
            this.macerateInto.getProperties().ensureSet(PropertyKey.INGOT, true);
        }
        if (this.magneticMaterial != null) {
            this.magneticMaterial.getProperties().ensureSet(PropertyKey.INGOT, true);
        }
    }

    public Material getSmeltingInto() {
        return this.smeltingInto;
    }

    public void setSmeltingInto(Material smeltingInto) {
        this.smeltingInto = smeltingInto;
    }

    public Material getArcSmeltingInto() {
        return this.arcSmeltingInto;
    }

    public void setArcSmeltingInto(Material arcSmeltingInto) {
        this.arcSmeltingInto = arcSmeltingInto;
    }

    public Material getMacerateInto() {
        return this.macerateInto;
    }

    public void setMacerateInto(Material macerateInto) {
        this.macerateInto = macerateInto;
    }

    @Nullable
    public Material getMagneticMaterial() {
        return this.magneticMaterial;
    }

    public void setMagneticMaterial(@Nullable Material magneticMaterial) {
        this.magneticMaterial = magneticMaterial;
    }
}

