/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.properties;

import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.MaterialProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import javax.annotation.Nonnull;

public class BlastProperty
implements IMaterialProperty<BlastProperty> {
    private int blastTemperature;
    private GasTier gasTier = null;
    private int durationOverride = -1;
    private int eutOverride = -1;

    public BlastProperty(int blastTemperature) {
        this.blastTemperature = blastTemperature;
    }

    public BlastProperty(int blastTemperature, GasTier gasTier, int eutOverride, int durationOverride) {
        this.blastTemperature = blastTemperature;
        this.gasTier = gasTier;
        this.eutOverride = eutOverride;
        this.durationOverride = durationOverride;
    }

    public BlastProperty() {
        this(0);
    }

    public int getBlastTemperature() {
        return this.blastTemperature;
    }

    public void setBlastTemperature(int blastTemp) {
        if (blastTemp <= 0) {
            throw new IllegalArgumentException("Blast Temperature must be greater than zero!");
        }
        this.blastTemperature = blastTemp;
    }

    public GasTier getGasTier() {
        return this.gasTier;
    }

    public void setGasTier(@Nonnull GasTier tier) {
        this.gasTier = tier;
    }

    public int getDurationOverride() {
        return this.durationOverride;
    }

    public void setDurationOverride(int duration) {
        this.durationOverride = duration;
    }

    public int getEUtOverride() {
        return this.eutOverride;
    }

    public void setEutOverride(int eut) {
        this.eutOverride = eut;
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        properties.ensureSet(PropertyKey.INGOT, true);
    }

    public static GasTier validateGasTier(String gasTierName) {
        if (gasTierName == null) {
            return null;
        }
        if ("LOW".equalsIgnoreCase(gasTierName)) {
            return GasTier.LOW;
        }
        if ("MID".equalsIgnoreCase(gasTierName)) {
            return GasTier.MID;
        }
        if ("HIGH".equalsIgnoreCase(gasTierName)) {
            return GasTier.HIGH;
        }
        if ("HIGHER".equalsIgnoreCase(gasTierName)) {
            return GasTier.HIGHER;
        }
        if ("HIGHEST".equalsIgnoreCase(gasTierName)) {
            return GasTier.HIGHEST;
        }
        String message = "Gas Tier must be either \"LOW\", \"MID\", \"HIGH\", \"HIGHER\", or \"HIGHEST\"";
        throw new IllegalArgumentException("Could not find valid gas tier for name: " + gasTierName + ". " + message);
    }

    public static enum GasTier {
        LOW,
        MID,
        HIGH,
        HIGHER,
        HIGHEST;

        public static final GasTier[] VALUES;

        static {
            VALUES = GasTier.values();
        }
    }
}

