/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.cover.filter;

import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.PhantomSlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class SimpleItemFilter
implements ItemFilter {
    protected boolean isBlackList;
    protected boolean ignoreNbt;
    protected class_1799[] matches = new class_1799[9];
    protected Consumer<ItemFilter> itemWriter = filter -> {};
    protected Consumer<ItemFilter> onUpdated = filter -> this.itemWriter.accept((ItemFilter)filter);
    protected int maxStackSize;

    protected SimpleItemFilter() {
        Arrays.fill(this.matches, class_1799.field_8037);
        this.maxStackSize = 1;
    }

    public static SimpleItemFilter loadFilter(class_1799 itemStack) {
        return SimpleItemFilter.loadFilter(itemStack.method_7948(), filter -> itemStack.method_7980(filter.saveFilter()));
    }

    private static SimpleItemFilter loadFilter(class_2487 tag, Consumer<ItemFilter> itemWriter) {
        SimpleItemFilter handler = new SimpleItemFilter();
        handler.itemWriter = itemWriter;
        handler.isBlackList = tag.method_10577("isBlackList");
        handler.ignoreNbt = tag.method_10577("matchNbt");
        class_2499 list = tag.method_10554("matches", 10);
        for (int i = 0; i < list.size(); ++i) {
            handler.matches[i] = class_1799.method_7915((class_2487)((class_2487)list.method_10534(i)));
        }
        return handler;
    }

    @Override
    public void setOnUpdated(Consumer<ItemFilter> onUpdated) {
        this.onUpdated = filter -> {
            this.itemWriter.accept((ItemFilter)filter);
            onUpdated.accept((ItemFilter)filter);
        };
    }

    @Override
    public class_2487 saveFilter() {
        class_2487 tag = new class_2487();
        tag.method_10556("isBlackList", this.isBlackList);
        tag.method_10556("matchNbt", this.ignoreNbt);
        class_2499 list = new class_2499();
        for (class_1799 match : this.matches) {
            list.add((Object)match.method_7953(new class_2487()));
        }
        tag.method_10566("matches", (class_2520)list);
        return tag;
    }

    public void setBlackList(boolean blackList) {
        this.isBlackList = blackList;
        this.onUpdated.accept(this);
    }

    public void setIgnoreNbt(boolean ingoreNbt) {
        this.ignoreNbt = ingoreNbt;
        this.onUpdated.accept(this);
    }

    @Override
    public WidgetGroup openConfigurator(int x, int y) {
        WidgetGroup group = new WidgetGroup(x, y, 79, 54);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int index = i * 3 + j;
                ItemStackTransfer handler = new ItemStackTransfer(this.matches[index]);
                PhantomSlotWidget slot = new PhantomSlotWidget((IItemTransfer)handler, 0, i * 18, j * 18){

                    public void updateScreen() {
                        super.updateScreen();
                        this.setMaxStackSize(SimpleItemFilter.this.maxStackSize);
                    }

                    public void detectAndSendChanges() {
                        super.detectAndSendChanges();
                        this.setMaxStackSize(SimpleItemFilter.this.maxStackSize);
                    }
                };
                slot.setChangeListener(() -> {
                    this.matches[index] = handler.getStackInSlot(0);
                    this.onUpdated.accept(this);
                }).setBackground(new IGuiTexture[]{GuiTextures.SLOT});
                group.addWidget((Widget)slot);
            }
        }
        group.addWidget((Widget)new ToggleButtonWidget(56, 9, 18, 18, (IGuiTexture)GuiTextures.BUTTON_BLACKLIST, this::isBlackList, this::setBlackList));
        group.addWidget((Widget)new ToggleButtonWidget(56, 27, 18, 18, (IGuiTexture)GuiTextures.BUTTON_FILTER_NBT, this::isIgnoreNbt, this::setIgnoreNbt));
        return group;
    }

    @Override
    public boolean test(class_1799 itemStack) {
        return this.testItemCount(itemStack) > 0;
    }

    @Override
    public int testItemCount(class_1799 itemStack) {
        int totalItemCount = this.getTotalConfiguredItemCount(itemStack);
        if (this.isBlackList) {
            return totalItemCount > 0 ? 0 : Integer.MAX_VALUE;
        }
        return totalItemCount;
    }

    public int getTotalConfiguredItemCount(class_1799 itemStack) {
        int totalCount = 0;
        for (class_1799 candidate : this.matches) {
            if (this.ignoreNbt && class_1799.method_31577((class_1799)candidate, (class_1799)itemStack)) {
                totalCount += candidate.method_7947();
                continue;
            }
            if (!ItemTransferHelper.canItemStacksStack((class_1799)candidate, (class_1799)itemStack)) continue;
            totalCount += candidate.method_7947();
        }
        return totalCount;
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
        for (class_1799 match : this.matches) {
            match.method_7939(Math.min(match.method_7947(), maxStackSize));
        }
    }

    @Override
    public boolean isBlackList() {
        return this.isBlackList;
    }

    public boolean isIgnoreNbt() {
        return this.ignoreNbt;
    }

    public class_1799[] getMatches() {
        return this.matches;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }
}

