/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.cover.filter;

import com.gregtechceu.gtceu.api.cover.filter.Filter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.syncdata.IEnhancedManaged;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.FieldManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1799;
import net.minecraft.class_6328;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public abstract class FilterHandler<T, F extends Filter<T, F>>
implements IEnhancedManaged {
    private final IEnhancedManaged container;
    @Persisted
    @DescSynced
    @NotNull
    private class_1799 filterItem = class_1799.field_8037;
    @Nullable
    private F filter;
    @Nullable
    private ItemStackTransfer filterSlot;
    @Nullable
    private WidgetGroup filterGroup;
    @NotNull
    private Consumer<F> onFilterLoaded = filter -> {};
    @NotNull
    private Consumer<F> onFilterRemoved = filter -> {};
    @NotNull
    private Consumer<F> onFilterUpdated = filter -> {};
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(FilterHandler.class);
    private final FieldManagedStorage syncStorage = new FieldManagedStorage((IManaged)this);

    public FilterHandler(IEnhancedManaged container) {
        this.container = container;
    }

    protected abstract F loadFilter(class_1799 var1);

    protected abstract F getEmptyFilter();

    protected abstract boolean canInsertFilterItem(class_1799 var1);

    public Widget createFilterSlotUI(int xPos, int yPos) {
        return new SlotWidget((IItemTransfer)this.getFilterSlot(), 0, xPos, yPos).setChangeListener(this::updateFilter).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.FILTER_SLOT_OVERLAY}));
    }

    public Widget createFilterConfigUI(int xPos, int yPos, int width, int height) {
        this.filterGroup = new WidgetGroup(xPos, yPos, width, height);
        if (!this.filterItem.method_7960()) {
            this.filterGroup.addWidget((Widget)this.getFilter().openConfigurator(0, 0));
        }
        return this.filterGroup;
    }

    public boolean isFilterPresent() {
        return this.filter != null || !this.filterItem.method_7960();
    }

    public F getFilter() {
        if (this.filter == null) {
            if (this.filterItem.method_7960()) {
                return this.getEmptyFilter();
            }
            this.loadFilterFromItem();
        }
        return this.filter;
    }

    public boolean test(T resource) {
        return this.getFilter().test(resource);
    }

    public FilterHandler<T, F> onFilterLoaded(Consumer<F> onFilterLoaded) {
        this.onFilterLoaded = onFilterLoaded;
        return this;
    }

    public FilterHandler<T, F> onFilterRemoved(Consumer<F> onFilterRemoved) {
        this.onFilterRemoved = onFilterRemoved;
        return this;
    }

    public FilterHandler<T, F> onFilterUpdated(Consumer<F> onFilterUpdated) {
        this.onFilterUpdated = onFilterUpdated;
        return this;
    }

    private ItemStackTransfer getFilterSlot() {
        if (this.filterSlot == null) {
            this.filterSlot = new ItemStackTransfer(this.filterItem);
            this.filterSlot.setFilter(this::canInsertFilterItem);
        }
        return this.filterSlot;
    }

    private void updateFilter() {
        ItemStackTransfer filterContainer = this.getFilterSlot();
        if (LDLib.isRemote() && !filterContainer.getStackInSlot(0).method_7960() && !this.filterItem.method_7960()) {
            return;
        }
        this.filterItem = filterContainer.getStackInSlot(0);
        if (this.filter != null) {
            this.filter = null;
            this.onFilterRemoved.accept(this.filter);
        }
        this.loadFilterFromItem();
    }

    private void loadFilterFromItem() {
        if (!this.filterItem.method_7960()) {
            this.filter = this.loadFilter(this.filterItem);
            this.filter.setOnUpdated(this.onFilterUpdated);
            this.onFilterLoaded.accept(this.filter);
        }
        this.updateFilterGroupUI();
    }

    private void updateFilterGroupUI() {
        if (this.filterGroup == null) {
            return;
        }
        this.filterGroup.clearAllWidgets();
        if (!this.filterItem.method_7960() && this.filter != null) {
            this.filterGroup.addWidget((Widget)this.filter.openConfigurator(0, 0));
        }
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onChanged() {
        this.container.onChanged();
    }

    @Override
    public void scheduleRenderUpdate() {
        this.container.scheduleRenderUpdate();
    }

    @NotNull
    public class_1799 getFilterItem() {
        return this.filterItem;
    }

    public FieldManagedStorage getSyncStorage() {
        return this.syncStorage;
    }
}

