/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability.recipe;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.content.IContentSerializer;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_2540;
import net.minecraft.class_2561;

public class RecipeCapability<T> {
    public final String name;
    public final int color;
    public final IContentSerializer<T> serializer;

    protected RecipeCapability(String name, int color, IContentSerializer<T> serializer) {
        this.name = name;
        this.color = color;
        this.serializer = serializer;
    }

    public T copyInner(T content) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        this.serializer.toNetwork(buf, content);
        return this.serializer.fromNetwork(buf);
    }

    public T copyWithModifier(T content, ContentModifier modifier) {
        return this.copyInner(content);
    }

    public final T copyContent(Object content) {
        return (T)this.copyInner(content);
    }

    public final T copyContent(Object content, ContentModifier modifier) {
        return (T)this.copyWithModifier(content, modifier);
    }

    public T of(Object o) {
        return this.serializer.of(o);
    }

    public String slotName(IO io) {
        return "%s_%s".formatted(this.name, io.name().toLowerCase(Locale.ROOT));
    }

    public String slotName(IO io, int index) {
        return "%s_%s_%s".formatted(this.name, io.name().toLowerCase(Locale.ROOT), index);
    }

    public class_2561 getTraslateComponent() {
        return class_2561.method_43471((String)"recipe.capability.%s.name".formatted(this.name));
    }

    public double calculateAmount(List<T> left) {
        return 1.0;
    }
}

