/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability;

import com.gregtechceu.gtceu.api.block.IAppearance;
import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.widget.CoverContainerConfigurator;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.utils.RayTraceHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public interface ICoverable
extends ITickSubscription,
IAppearance,
IFancyConfigurator {
    public class_1937 getLevel();

    public class_2338 getPos();

    public long getOffsetTimer();

    public void markDirty();

    public boolean isInValid();

    public void notifyBlockUpdate();

    public void scheduleRenderUpdate();

    public void scheduleNeighborShapeUpdate();

    public boolean canPlaceCoverOnSide(CoverDefinition var1, class_2350 var2);

    public double getCoverPlateThickness();

    public class_2350 getFrontFacing();

    public boolean shouldRenderBackSide();

    public IItemTransfer getItemTransferCap(@Nullable class_2350 var1, boolean var2);

    public IFluidTransfer getFluidTransferCap(@Nullable class_2350 var1, boolean var2);

    public void setCoverAtSide(@Nullable CoverBehavior var1, class_2350 var2);

    @Nullable
    public CoverBehavior getCoverAtSide(class_2350 var1);

    default public boolean placeCoverOnSide(class_2350 side, class_1799 itemStack, CoverDefinition coverDefinition, class_3222 player) {
        CoverBehavior coverBehavior = coverDefinition.createCoverBehavior(this, side);
        if (!this.canPlaceCoverOnSide(coverDefinition, side) || !coverBehavior.canAttach()) {
            return false;
        }
        if (this.getCoverAtSide(side) != null) {
            this.removeCover(side, (class_1657)player);
        }
        coverBehavior.onAttached(itemStack, player);
        coverBehavior.onLoad();
        this.setCoverAtSide(coverBehavior, side);
        this.notifyBlockUpdate();
        this.markDirty();
        this.scheduleNeighborShapeUpdate();
        return true;
    }

    default public boolean removeCover(boolean dropItself, class_2350 side, @Nullable class_1657 player) {
        CoverBehavior coverBehavior = this.getCoverAtSide(side);
        if (coverBehavior == null) {
            return false;
        }
        List<class_1799> drops = coverBehavior.getAdditionalDrops();
        if (dropItself) {
            drops.add(coverBehavior.getPickItem());
        }
        coverBehavior.onRemoved();
        this.setCoverAtSide(null, side);
        for (class_1799 dropStack : drops) {
            if (player != null && player.method_31548().method_7394(dropStack)) continue;
            class_2248.method_9577((class_1937)this.getLevel(), (class_2338)this.getPos(), (class_1799)dropStack);
        }
        this.notifyBlockUpdate();
        this.markDirty();
        this.scheduleNeighborShapeUpdate();
        return true;
    }

    default public boolean removeCover(class_2350 side, @Nullable class_1657 player) {
        return this.removeCover(true, side, player);
    }

    default public List<CoverBehavior> getCovers() {
        return Arrays.stream(class_2350.values()).map(this::getCoverAtSide).filter(Objects::nonNull).collect(Collectors.toList());
    }

    default public void onLoad() {
        for (CoverBehavior cover : this.getCovers()) {
            cover.onLoad();
        }
    }

    default public void onUnload() {
        for (CoverBehavior cover : this.getCovers()) {
            cover.onUnload();
        }
    }

    default public void onNeighborChanged(class_2248 block, class_2338 fromPos, boolean isMoving) {
        for (CoverBehavior cover : this.getCovers()) {
            cover.onNeighborChanged(block, fromPos, isMoving);
        }
    }

    default public boolean hasAnyCover() {
        for (class_2350 facing : class_2350.values()) {
            if (this.getCoverAtSide(facing) == null) continue;
            return true;
        }
        return false;
    }

    default public boolean hasCover(class_2350 facing) {
        return this.getCoverAtSide(facing) != null;
    }

    default public boolean isRemote() {
        return this.getLevel() == null ? LDLib.isRemote() : this.getLevel().field_9236;
    }

    default public class_265[] addCoverCollisionBoundingBox() {
        double plateThickness = this.getCoverPlateThickness();
        ArrayList<class_265> shapes = new ArrayList<class_265>();
        if (plateThickness > 0.0) {
            for (class_2350 side : class_2350.values()) {
                if (this.getCoverAtSide(side) == null) continue;
                class_265 coverBox = ICoverable.getCoverPlateBox(side, plateThickness);
                shapes.add(coverBox);
            }
        }
        return (class_265[])shapes.toArray(class_265[]::new);
    }

    public static boolean doesCoverCollide(class_2350 side, List<class_265> collisionBox, double plateThickness) {
        if (side == null) {
            return false;
        }
        if (plateThickness > 0.0) {
            class_265 coverPlateBox = ICoverable.getCoverPlateBox(side, plateThickness);
            List aabbs = coverPlateBox.method_1090();
            for (class_238 aabb : aabbs) {
                if (!(class_259.method_1085((class_2350.class_2351)side.method_10166(), (class_238)aabb, collisionBox, (double)plateThickness) < plateThickness)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static class_2350 rayTraceCoverableSide(ICoverable coverable, class_1657 player) {
        class_3965 rayTrace = RayTraceHelper.rayTraceRange((class_1937)coverable.getLevel(), (class_1657)player, (double)ToolHelper.getPlayerBlockReach(player));
        if (rayTrace.method_17783() == class_239.class_240.field_1333) {
            return null;
        }
        return ICoverable.traceCoverSide(rayTrace);
    }

    @Nullable
    public static class_2350 traceCoverSide(class_3965 result) {
        return ICoverable.determineGridSideHit(result);
    }

    @Nullable
    public static class_2350 determineGridSideHit(class_3965 result) {
        return GTUtil.determineWrenchingSide(result.method_17780(), (float)(result.method_17784().field_1352 - (double)result.method_17777().method_10263()), (float)(result.method_17784().field_1351 - (double)result.method_17777().method_10264()), (float)(result.method_17784().field_1350 - (double)result.method_17777().method_10260()));
    }

    public static class_265 getCoverPlateBox(class_2350 side, double plateThickness) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11036 -> class_259.method_1081((double)0.0, (double)(1.0 - plateThickness), (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            case class_2350.field_11033 -> class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)plateThickness, (double)1.0);
            case class_2350.field_11043 -> class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)plateThickness);
            case class_2350.field_11035 -> class_259.method_1081((double)0.0, (double)0.0, (double)(1.0 - plateThickness), (double)1.0, (double)1.0, (double)1.0);
            case class_2350.field_11039 -> class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)plateThickness, (double)1.0, (double)1.0);
            case class_2350.field_11034 -> class_259.method_1081((double)(1.0 - plateThickness), (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        };
    }

    public static boolean canPlaceCover(CoverDefinition coverDef, ICoverable coverable) {
        for (class_2350 facing : class_2350.values()) {
            CoverBehavior cover;
            if (!coverable.canPlaceCoverOnSide(coverDef, facing) || !(cover = coverDef.createCoverBehavior(coverable, facing)).canAttach()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    default public class_2680 getBlockAppearance(class_2680 state, class_1920 level, class_2338 pos, class_2350 side, class_2680 sourceState, class_2338 sourcePos) {
        if (this.hasCover(side)) {
            return this.getCoverAtSide(side).getAppearance(sourceState, sourcePos);
        }
        return null;
    }

    @Override
    default public String getTitle() {
        return "gtceu.gui.cover_setting.title";
    }

    @Override
    default public IGuiTexture getIcon() {
        return GuiTextures.TOOL_COVER_SETTINGS;
    }

    @Override
    default public Widget createConfigurator() {
        return new CoverContainerConfigurator(this);
    }

    public static class PrimaryBoxData {
        public final boolean usePlacementGrid;

        public PrimaryBoxData(boolean usePlacementGrid) {
            this.usePlacementGrid = usePlacementGrid;
        }
    }
}

