/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.blockentity;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.BlockProperties;
import com.gregtechceu.gtceu.api.block.MaterialPipeBlock;
import com.gregtechceu.gtceu.api.block.PipeBlock;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.IToolable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.IToolGridHighLight;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.pipenet.IAttachData;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.api.pipenet.PipeCoverContainer;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.syncdata.EnhancedFieldManagedStorage;
import com.gregtechceu.gtceu.api.syncdata.IEnhancedManaged;
import com.gregtechceu.gtceu.api.syncdata.RequireRerender;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.syncdata.IManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAsyncAutoSyncBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAutoPersistBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3738;
import net.minecraft.class_3965;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public abstract class PipeBlockEntity<PipeType extends Enum<PipeType>, NodeDataType extends IAttachData>
extends class_2586
implements IPipeNode<PipeType, NodeDataType>,
IEnhancedManaged,
IAsyncAutoSyncBlockEntity,
IAutoPersistBlockEntity,
IToolGridHighLight,
IToolable {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PipeBlockEntity.class);
    private final EnhancedFieldManagedStorage syncStorage = new EnhancedFieldManagedStorage(this);
    private final long offset = GTValues.RNG.method_43048(20);
    @DescSynced
    @Persisted(key="cover")
    protected final PipeCoverContainer coverContainer = new PipeCoverContainer(this);
    @DescSynced
    @Persisted
    @RequireRerender
    protected int connections = 0;
    @Persisted
    @DescSynced
    @RequireRerender
    private int paintingColor = -1;
    @Persisted
    @DescSynced
    @RequireRerender
    private String frameMaterial;
    private final List<TickableSubscription> serverTicks = new ArrayList<TickableSubscription>();
    private final List<TickableSubscription> waitingToAdd = new ArrayList<TickableSubscription>();

    public PipeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
    }

    @Override
    public void scheduleRenderUpdate() {
        IPipeNode.super.scheduleRenderUpdate();
    }

    public IManagedStorage getRootStorage() {
        return this.syncStorage;
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onChanged() {
        class_1937 level = this.method_10997();
        if (level != null && !level.field_9236 && level.method_8503() != null) {
            level.method_8503().execute(() -> ((PipeBlockEntity)this).method_5431());
        }
    }

    @Override
    public long getOffsetTimer() {
        return this.field_11863 == null ? this.offset : this.field_11863.method_8510() + this.offset;
    }

    public void method_11012() {
        super.method_11012();
        this.coverContainer.onUnload();
    }

    public void method_10996() {
        super.method_10996();
        this.coverContainer.onLoad();
    }

    @Override
    public int getNumConnections() {
        int count = 0;
        for (int connections = this.getConnections(); connections > 0; connections &= connections - 1) {
            ++count;
        }
        return count;
    }

    @Override
    @Nullable
    public TickableSubscription subscribeServerTick(Runnable runnable) {
        if (!this.isRemote()) {
            class_1937 class_19372;
            TickableSubscription subscription = new TickableSubscription(runnable);
            this.waitingToAdd.add(subscription);
            class_2680 blockState = this.method_11010();
            if (!((Boolean)blockState.method_11654((class_2769)BlockProperties.SERVER_TICK)).booleanValue() && (class_19372 = this.method_10997()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                blockState = (class_2680)blockState.method_11657((class_2769)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(true));
                this.method_31664(blockState);
                serverLevel.method_8503().method_18858((Runnable)new class_3738(0, () -> serverLevel.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(true)))));
            }
            return subscription;
        }
        return null;
    }

    @Override
    public void unsubscribe(@Nullable TickableSubscription current) {
        if (current != null) {
            current.unsubscribe();
        }
    }

    @Override
    public final void serverTick() {
        if (!this.waitingToAdd.isEmpty()) {
            this.serverTicks.addAll(this.waitingToAdd);
            this.waitingToAdd.clear();
        }
        Iterator<TickableSubscription> iter = this.serverTicks.iterator();
        while (iter.hasNext()) {
            TickableSubscription tickable = iter.next();
            if (tickable.isStillSubscribed()) {
                tickable.run();
            }
            if (tickable.isStillSubscribed()) continue;
            iter.remove();
        }
        if (this.serverTicks.isEmpty() && this.waitingToAdd.isEmpty()) {
            this.method_10997().method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public boolean isBlocked(class_2350 side) {
        return (this.connections & 1 << side.ordinal()) == 0;
    }

    @Override
    public void setBlocked(class_2350 side, boolean isBlocked) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.connections = !isBlocked ? (this.connections |= 1 << side.ordinal()) : (this.connections &= ~(1 << side.ordinal()));
            this.getPipeBlock().getWorldPipeNet(serverLevel).updateBlockedConnections(this.method_11016(), side, isBlocked);
            this.updateConnections();
            this.notifyBlockUpdate();
        }
    }

    @Override
    public int getVisualConnections() {
        int visualConnections = this.connections;
        for (class_2350 side : class_2350.values()) {
            CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
            if (cover == null || !cover.blockPipePassThrough()) continue;
            visualConnections |= 1 << side.ordinal();
        }
        return visualConnections;
    }

    @Override
    public boolean shouldRenderGrid(class_1657 player, class_1799 held, Set<GTToolType> toolTypes) {
        if (toolTypes.contains(this.getPipeTuneTool()) || toolTypes.contains(GTToolType.SCREWDRIVER)) {
            return true;
        }
        for (CoverBehavior cover : this.coverContainer.getCovers()) {
            if (!cover.shouldRenderGrid(player, held, toolTypes)) continue;
            return true;
        }
        return false;
    }

    public ResourceTexture getPipeTexture(boolean isBlock) {
        return isBlock ? GuiTextures.TOOL_PIPE_CONNECT : GuiTextures.TOOL_PIPE_BLOCK;
    }

    @Override
    public ResourceTexture sideTips(class_1657 player, Set<GTToolType> toolTypes, class_2350 side) {
        if (toolTypes.contains(this.getPipeTuneTool())) {
            return this.getPipeTexture(this.isBlocked(side));
        }
        CoverBehavior cover = this.coverContainer.getCoverAtSide(side);
        if (cover != null) {
            return cover.sideTips(player, toolTypes, side);
        }
        return null;
    }

    @Override
    public Pair<GTToolType, class_1269> onToolClick(Set<GTToolType> toolTypes, class_1799 itemStack, class_1838 context) {
        CoverBehavior coverBehavior;
        class_1657 playerIn = context.method_8036();
        if (playerIn == null) {
            return Pair.of(null, (Object)class_1269.field_5811);
        }
        class_1268 hand = context.method_20287();
        class_3965 hitResult = new class_3965(context.method_17698(), context.method_8038(), context.method_8037(), false);
        class_2350 gridSide = ICoverable.determineGridSideHit(hitResult);
        CoverBehavior coverBehavior2 = coverBehavior = gridSide == null ? null : this.coverContainer.getCoverAtSide(gridSide);
        if (gridSide == null) {
            gridSide = hitResult.method_17780();
        }
        if (toolTypes.contains(GTToolType.SCREWDRIVER)) {
            if (coverBehavior != null) {
                return Pair.of((Object)GTToolType.SCREWDRIVER, (Object)coverBehavior.onScrewdriverClick(playerIn, hand, hitResult));
            }
        } else if (toolTypes.contains(GTToolType.SOFT_MALLET)) {
            if (coverBehavior != null) {
                return Pair.of((Object)GTToolType.SOFT_MALLET, (Object)coverBehavior.onSoftMalletClick(playerIn, hand, hitResult));
            }
        } else {
            if (toolTypes.contains(this.getPipeTuneTool())) {
                IPipeNode node;
                this.setBlocked(gridSide, !this.isBlocked(gridSide));
                if (!this.isBlocked(gridSide) && (node = this.getPipeBlock().getPileTile((class_1922)this.getPipeLevel(), this.getPipePos().method_10093(gridSide))) != null && node.isBlocked(gridSide.method_10153())) {
                    node.setBlocked(gridSide.method_10153(), false);
                }
                return Pair.of((Object)this.getPipeTuneTool(), (Object)class_1269.field_21466);
            }
            if (toolTypes.contains(GTToolType.CROWBAR) && coverBehavior != null) {
                if (!this.isRemote()) {
                    this.getCoverContainer().removeCover(gridSide, playerIn);
                }
                return Pair.of((Object)GTToolType.CROWBAR, (Object)class_1269.field_21466);
            }
        }
        return Pair.of(null, (Object)class_1269.field_5811);
    }

    protected GTToolType getPipeTuneTool() {
        return GTToolType.WRENCH;
    }

    @Override
    public int getDefaultPaintingColor() {
        int n;
        PipeBlock pipeBlock = this.getPipeBlock();
        if (pipeBlock instanceof MaterialPipeBlock) {
            MaterialPipeBlock materialPipeBlock = (MaterialPipeBlock)pipeBlock;
            n = materialPipeBlock.material.getMaterialRGB();
        } else {
            n = IPipeNode.super.getDefaultPaintingColor();
        }
        return n;
    }

    @Override
    @Nullable
    public Material getFrameMaterial() {
        return this.frameMaterial == null ? null : (Material)GTRegistries.MATERIALS.get(this.frameMaterial);
    }

    public EnhancedFieldManagedStorage getSyncStorage() {
        return this.syncStorage;
    }

    @Override
    public PipeCoverContainer getCoverContainer() {
        return this.coverContainer;
    }

    @Override
    public int getConnections() {
        return this.connections;
    }

    @Override
    public void setConnections(int connections) {
        this.connections = connections;
    }

    @Override
    public int getPaintingColor() {
        return this.paintingColor;
    }

    @Override
    public void setPaintingColor(int paintingColor) {
        this.paintingColor = paintingColor;
    }
}

