/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.block;

import com.gregtechceu.gtceu.api.block.AppearanceBlock;
import com.gregtechceu.gtceu.api.block.BlockProperties;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6328;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

@class_6328
@ParametersAreNonnullByDefault
public class MetaMachineBlock
extends AppearanceBlock
implements IMachineBlock {
    public final MachineDefinition definition;
    public final RotationState rotationState;

    public MetaMachineBlock(class_4970.class_2251 properties, MachineDefinition definition) {
        super(properties);
        this.definition = definition;
        this.rotationState = RotationState.get();
        if (this.rotationState != RotationState.NONE) {
            this.method_9590((class_2680)this.method_9564().method_11657((class_2769)this.rotationState.property, (Comparable)this.rotationState.defaultDirection));
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        pBuilder.method_11667(new class_2769[]{BlockProperties.SERVER_TICK});
        RotationState rotationState = RotationState.get();
        if (rotationState != RotationState.NONE) {
            pBuilder.method_11667(new class_2769[]{rotationState.property});
        }
    }

    @Nullable
    public MetaMachine getMachine(class_1922 level, class_2338 pos) {
        return MetaMachine.getMachine(level, pos);
    }

    @Nullable
    public IRenderer getRenderer(class_2680 state) {
        return this.definition.getRenderer();
    }

    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return this.getRotationState() == RotationState.NONE ? this.definition.getShape(class_2350.field_11043) : this.definition.getShape((class_2350)pState.method_11654((class_2769)this.getRotationState().property));
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        super.method_9496(state, level, pos, random);
        MetaMachine machine = this.getMachine((class_1922)level, pos);
        if (machine != null) {
            machine.animateTick(random);
        }
    }

    public boolean method_37403(class_2680 state, class_1922 level, class_2338 pos) {
        return false;
    }

    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, @Nullable class_1309 player, class_1799 pStack) {
        if (!pLevel.field_9236) {
            MetaMachine machine = this.getMachine((class_1922)pLevel, pPos);
            if (machine instanceof IDropSaveMachine) {
                IDropSaveMachine dropSaveMachine = (IDropSaveMachine)((Object)machine);
                class_2487 tag = pStack.method_7969();
                if (tag != null) {
                    dropSaveMachine.loadFromItem(tag);
                }
            }
            if (machine instanceof IMachineLife) {
                IMachineLife machineLife = (IMachineLife)((Object)machine);
                machineLife.onMachinePlaced(player, pStack);
            }
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        RotationState rotationState = this.getRotationState();
        class_1657 player = context.method_8036();
        class_2338 blockPos = context.method_8037();
        class_2680 state = this.method_9564();
        if (player != null && rotationState != RotationState.NONE) {
            class_243 pos = player.method_19538();
            if (Math.abs(pos.field_1352 - (double)((float)blockPos.method_10263() + 0.5f)) < 2.0 && Math.abs(pos.field_1350 - (double)((float)blockPos.method_10260() + 0.5f)) < 2.0) {
                double d0 = pos.field_1351 + (double)player.method_5751();
                if (d0 - (double)blockPos.method_10264() > 2.0 && rotationState.test(class_2350.field_11036)) {
                    return (class_2680)state.method_11657((class_2769)rotationState.property, (Comparable)class_2350.field_11036);
                }
                if ((double)blockPos.method_10264() - d0 > 0.0 && rotationState.test(class_2350.field_11033)) {
                    return (class_2680)state.method_11657((class_2769)rotationState.property, (Comparable)class_2350.field_11033);
                }
            }
            if (rotationState == RotationState.Y_AXIS) {
                return (class_2680)state.method_11657((class_2769)rotationState.property, (Comparable)class_2350.field_11036);
            }
            return (class_2680)state.method_11657((class_2769)rotationState.property, (Comparable)player.method_5735().method_10153());
        }
        return state;
    }

    public class_2350 getFrontFacing(class_2680 state) {
        return this.getRotationState() == RotationState.NONE ? class_2350.field_11043 : (class_2350)state.method_11654((class_2769)this.getRotationState().property);
    }

    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        IDropSaveMachine dropSaveMachine;
        class_1799 itemStack = super.method_9574(level, pos, state);
        MetaMachine metaMachine = this.getMachine(level, pos);
        if (metaMachine instanceof IDropSaveMachine && (dropSaveMachine = (IDropSaveMachine)((Object)metaMachine)).savePickClone()) {
            dropSaveMachine.saveToItem(itemStack.method_7948());
        }
        return itemStack;
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 level, List<class_2561> tooltip, class_1836 flag) {
        this.definition.getTooltipBuilder().accept(stack, tooltip);
        String mainKey = String.format("%s.machine.%s.tooltip", this.definition.getId().method_12836(), this.definition.getId().method_12832());
        if (LocalizationUtils.exist((String)mainKey)) {
            tooltip.add(1, (class_2561)class_2561.method_43471((String)mainKey));
        }
    }

    public boolean method_9592(class_2680 pState, class_1937 pLevel, class_2338 pPos, int pId, int pParam) {
        class_2586 tile = pLevel.method_8321(pPos);
        if (tile != null) {
            return tile.method_11004(pId, pParam);
        }
        return false;
    }

    public class_2680 method_9598(class_2680 pState, class_2470 pRotation) {
        return super.method_9598(pState, pRotation);
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        class_8567 context = builder.method_51874(class_181.field_1224, (Object)state).method_51875(class_173.field_1172);
        class_1297 entity = (class_1297)context.method_51869(class_181.field_1226);
        class_2586 tileEntity = (class_2586)context.method_51869(class_181.field_1228);
        List drops = super.method_9560(state, builder);
        if (tileEntity instanceof IMachineBlockEntity) {
            IDropSaveMachine dropSaveMachine;
            IMachineBlockEntity holder = (IMachineBlockEntity)tileEntity;
            MetaMachine machine = holder.getMetaMachine();
            for (class_2350 direction : class_2350.values()) {
                machine.getCoverContainer().removeCover(direction, null);
            }
            if (machine instanceof IMachineModifyDrops) {
                IMachineModifyDrops machineModifyDrops = (IMachineModifyDrops)((Object)machine);
                if (entity instanceof class_1657) {
                    machineModifyDrops.onDrops(drops, (class_1657)entity);
                }
            }
            if (machine instanceof IDropSaveMachine && (dropSaveMachine = (IDropSaveMachine)((Object)machine)).saveBreak()) {
                for (class_1799 drop : drops) {
                    MetaMachineItem item;
                    class_1792 class_17922 = drop.method_7909();
                    if (!(class_17922 instanceof MetaMachineItem) || (item = (MetaMachineItem)class_17922).method_7711() != this) continue;
                    dropSaveMachine.saveToItem(drop.method_7948());
                }
            }
        }
        return drops;
    }

    public void method_9536(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pNewState, boolean pIsMoving) {
        if (pState.method_31709()) {
            if (!pState.method_27852(pNewState.method_26204())) {
                MetaMachine metaMachine = this.getMachine((class_1922)pLevel, pPos);
                if (metaMachine instanceof IMachineLife) {
                    IMachineLife machineLife = (IMachineLife)((Object)metaMachine);
                    machineLife.onMachineRemoved();
                }
                pLevel.method_8455(pPos, (class_2248)this);
                pLevel.method_8544(pPos);
            } else if (this.rotationState != RotationState.NONE) {
                MetaMachine machine;
                class_2350 oldFacing = (class_2350)pState.method_11654((class_2769)this.rotationState.property);
                class_2350 newFacing = (class_2350)pNewState.method_11654((class_2769)this.rotationState.property);
                if (newFacing != oldFacing && (machine = this.getMachine((class_1922)pLevel, pPos)) != null) {
                    machine.onRotated(oldFacing, newFacing);
                }
            }
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        IInteractedMachine interactedMachine;
        class_1269 result;
        MetaMachine machine = this.getMachine((class_1922)world, pos);
        class_1799 itemStack = player.method_5998(hand);
        Set<GTToolType> types = ToolHelper.getToolTypes(itemStack);
        if (machine != null && !types.isEmpty() && ToolHelper.canUse(itemStack)) {
            Pair<GTToolType, class_1269> result2 = machine.onToolClick(types, itemStack, new class_1838(player, hand, hit));
            if (result2.getSecond() == class_1269.field_21466 && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                ToolHelper.playToolSound((GTToolType)result2.getFirst(), serverPlayer);
                if (!serverPlayer.method_7337()) {
                    ToolHelper.damageItem(itemStack, (class_1309)serverPlayer, 1);
                }
            }
            if (result2.getSecond() != class_1269.field_5811) {
                return (class_1269)result2.getSecond();
            }
        }
        if (machine instanceof IInteractedMachine && (result = (interactedMachine = (IInteractedMachine)((Object)machine)).onUse(state, world, pos, player, hand, hit)) != class_1269.field_5811) {
            return result;
        }
        if (machine instanceof IUIMachine) {
            IUIMachine uiMachine = (IUIMachine)((Object)machine);
            return uiMachine.tryToOpenUI(player, hand, hit);
        }
        return class_1269.field_5811;
    }

    public boolean canConnectRedstone(class_1922 level, class_2338 pos, class_2350 side) {
        return this.getMachine(level, pos).canConnectRedstone(side);
    }

    public int method_9524(class_2680 state, class_1922 level, class_2338 pos, class_2350 direction) {
        return this.getMachine(level, pos).getOutputSignal(direction);
    }

    public int method_9603(class_2680 state, class_1922 level, class_2338 pos, class_2350 direction) {
        return this.getMachine(level, pos).getOutputDirectSignal(direction);
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        return this.getMachine((class_1922)level, pos).getAnalogOutputSignal();
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        MetaMachine machine = this.getMachine((class_1922)level, pos);
        if (machine != null) {
            machine.onNeighborChanged(block, fromPos, isMoving);
        }
        super.method_9612(state, level, pos, block, fromPos, isMoving);
    }

    @Override
    public class_2680 getBlockAppearance(class_2680 state, class_1920 level, class_2338 pos, class_2350 side, class_2680 sourceState, class_2338 sourcePos) {
        MetaMachine machine = this.getMachine((class_1922)level, pos);
        if (machine != null) {
            return machine.getBlockAppearance(state, level, pos, side, sourceState, sourcePos);
        }
        return super.getBlockAppearance(state, level, pos, side, sourceState, sourcePos);
    }

    @Override
    public MachineDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public RotationState getRotationState() {
        return this.rotationState;
    }
}

