/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import com.jaquadro.minecraft.storagedrawers.inventory.DrawerStorageImpl;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;

public class DrawerStackStorage
extends SingleStackStorage {
    DrawerStorageImpl storage;
    int slot;
    class_1799 lastReleasedSnapshot = null;

    DrawerStackStorage(DrawerStorageImpl storage, int slot) {
        this.storage = storage;
        this.slot = slot;
    }

    void updateSlot(int slot) {
        this.slot = slot;
    }

    protected class_1799 getStack() {
        IDrawer drawer = this.storage.getDrawer(this.slot);
        return drawer.getStoredItemPrototype().method_46651(drawer.getStoredItemCount());
    }

    protected void setStack(class_1799 stack) {
        if (stack.method_7947() > 0) {
            this.storage.getDrawer(this.slot).setStoredItem(stack, stack.method_7947());
        } else {
            this.storage.getDrawer(this.slot).setStoredItemCount(0);
        }
    }

    protected int getCapacity(ItemVariant itemVariant) {
        return this.storage.getDrawer(this.slot).getMaxCapacity(itemVariant.toStack());
    }

    public long insert(ItemVariant insertedVariant, long maxAmount, TransactionContext transaction) {
        IDrawerAttributes attr;
        if (!this.storage.getDrawer(this.slot).canItemBeStored(insertedVariant.toStack())) {
            return 0L;
        }
        long inserted = super.insert(insertedVariant, maxAmount, transaction);
        if (inserted < maxAmount && (attr = this.storage.group.getCapability(Capabilities.DRAWER_ATTRIBUTES)) != null && attr.isVoid()) {
            inserted = maxAmount;
        }
        return inserted;
    }

    public long extract(ItemVariant variant, long maxAmount, TransactionContext transaction) {
        if (!this.storage.getDrawer(this.slot).canItemBeExtracted(variant.toStack())) {
            return 0L;
        }
        return super.extract(variant, maxAmount, transaction);
    }

    protected void releaseSnapshot(class_1799 snapshot) {
        this.lastReleasedSnapshot = snapshot;
    }

    protected void onFinalCommit() {
        class_1799 original = this.lastReleasedSnapshot;
        class_1799 currentStack = this.getStack();
        if (!original.method_7960() && original.method_7909() == currentStack.method_7909()) {
            original.method_7980(currentStack.method_7969());
            original.method_7939(currentStack.method_7947());
            this.setStack(original);
        } else {
            original.method_7939(0);
        }
    }
}

